/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.planexporter.AccessDatabase;
import org.apache.derby.impl.tools.planexporter.CreateHTMLFile;
import org.apache.derby.impl.tools.planexporter.CreateXMLFile;

public class PlanExporter {
    private static String dbURL = null;
    private static String xslStyleSheetName = "resources/vanilla_html.xsl";
    private static final int XML = 1;
    private static final int HTML = 2;
    private static final int XSL = 3;
    private static final LocalizedResource LOC_RES = LocalizedResource.getInstance();

    public static void main(String[] args) {
        try {
            if (args.length > 4 && args.length < 10) {
                dbURL = args[0];
                AccessDatabase access = new AccessDatabase(dbURL, args[1], args[2]);
                if (access.verifySchemaExistance()) {
                    if (access.initializeDataArray()) {
                        access.createXMLFragment();
                        access.markTheDepth();
                        String stmt = access.statement();
                        String time = access.time();
                        access.closeConnection();
                        if (args.length == 8 && args[3].equalsIgnoreCase("-adv")) {
                            int opt1 = PlanExporter.selectArg(args[4]);
                            int opt2 = PlanExporter.selectArg(args[6]);
                            if (opt1 == 1 && opt2 == 3) {
                                if (args[7].toUpperCase().endsWith(".XSL")) {
                                    PlanExporter.generateXML(access, args[5], stmt, time, args[7]);
                                } else {
                                    PlanExporter.generateXML(access, args[5], stmt, time, args[7] + ".xsl");
                                }
                            } else if (opt1 == 3 && opt2 == 1) {
                                if (args[5].toUpperCase().endsWith(".XSL")) {
                                    PlanExporter.generateXML(access, args[7], stmt, time, args[5]);
                                } else {
                                    PlanExporter.generateXML(access, args[7], stmt, time, args[5] + ".xsl");
                                }
                            } else {
                                PlanExporter.printHelp();
                            }
                        } else if (args.length == 5) {
                            int opt = PlanExporter.selectArg(args[3]);
                            if (opt == 0 || opt == 3) {
                                PlanExporter.printHelp();
                            } else if (opt == 1) {
                                PlanExporter.generateXML(access, args[4], stmt, time, null);
                            } else {
                                PlanExporter.generateXML(access, "temp.xml", stmt, time, null);
                                PlanExporter.generateHTML("temp.xml", args[4], xslStyleSheetName, true);
                                PlanExporter.deleteFile("temp.xml");
                            }
                        } else if (args.length == 7) {
                            int opt1 = PlanExporter.selectArg(args[3]);
                            int opt2 = PlanExporter.selectArg(args[5]);
                            if (opt1 == 0 || opt2 == 0) {
                                PlanExporter.printHelp();
                            } else if (opt1 == 1 && opt2 == 2) {
                                PlanExporter.generateXML(access, args[4], stmt, time, null);
                                PlanExporter.generateHTML(args[4], args[6], xslStyleSheetName, true);
                            } else if (opt1 == 2 && opt2 == 1) {
                                PlanExporter.generateXML(access, args[6], stmt, time, null);
                                PlanExporter.generateHTML(args[6], args[4], xslStyleSheetName, true);
                            } else if (opt1 == 2 && opt2 == 3) {
                                PlanExporter.generateXML(access, "temp.xml", stmt, time, null);
                                PlanExporter.generateHTML("temp.xml", args[4], args[6], false);
                                PlanExporter.deleteFile("temp.xml");
                            } else if (opt1 == 3 && opt2 == 2) {
                                PlanExporter.generateXML(access, "temp.xml", stmt, time, null);
                                PlanExporter.generateHTML("temp.xml", args[6], args[4], false);
                                PlanExporter.deleteFile("temp.xml");
                            } else {
                                PlanExporter.printHelp();
                            }
                        } else if (args.length == 9) {
                            int opt1 = PlanExporter.selectArg(args[3]);
                            int opt2 = PlanExporter.selectArg(args[5]);
                            int opt3 = PlanExporter.selectArg(args[7]);
                            if (opt1 == 0 || opt2 == 0 || opt3 == 0) {
                                PlanExporter.printHelp();
                            } else if (opt1 == 1 && opt2 == 2 && opt3 == 3) {
                                PlanExporter.generateXML(access, args[4], stmt, time, null);
                                PlanExporter.generateHTML(args[4], args[6], args[8], false);
                            } else if (opt1 == 2 && opt2 == 3 && opt3 == 1) {
                                PlanExporter.generateXML(access, args[8], stmt, time, null);
                                PlanExporter.generateHTML(args[8], args[4], args[6], false);
                            } else if (opt1 == 3 && opt2 == 1 && opt3 == 2) {
                                PlanExporter.generateXML(access, args[6], stmt, time, null);
                                PlanExporter.generateHTML(args[6], args[8], args[4], false);
                            } else if (opt1 == 1 && opt2 == 3 && opt3 == 2) {
                                PlanExporter.generateXML(access, args[4], stmt, time, null);
                                PlanExporter.generateHTML(args[4], args[8], args[6], false);
                            } else if (opt1 == 2 && opt2 == 1 && opt3 == 3) {
                                PlanExporter.generateXML(access, args[6], stmt, time, null);
                                PlanExporter.generateHTML(args[6], args[4], args[8], false);
                            } else if (opt1 == 3 && opt2 == 2 && opt3 == 1) {
                                PlanExporter.generateXML(access, args[8], stmt, time, null);
                                PlanExporter.generateHTML(args[8], args[6], args[4], false);
                            } else {
                                PlanExporter.printHelp();
                            }
                        } else {
                            PlanExporter.printHelp();
                        }
                    } else {
                        System.out.println(LOC_RES.getTextMessage("PE_NoStatisticsCaptured", new Object[0]));
                    }
                } else {
                    System.out.println(LOC_RES.getTextMessage("PE_ErrorSchemaNotExist", new Object[0]));
                }
            } else {
                PlanExporter.printHelp();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static int selectArg(String arg) {
        if (arg.equalsIgnoreCase("-xml")) {
            return 1;
        }
        if (arg.equalsIgnoreCase("-html")) {
            return 2;
        }
        if (arg.equalsIgnoreCase("-xsl")) {
            return 3;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateXML(AccessDatabase access, String arg, String stmt, String time, String xsl) throws IOException {
        Writer out;
        CreateXMLFile xmlFile = new CreateXMLFile(access);
        Object fileName = arg.toUpperCase().endsWith(".XML") ? arg : arg + ".xml";
        try {
            out = AccessController.doPrivileged(new PrivilegedExceptionAction<Writer>((String)fileName){
                final /* synthetic */ String val$fileName;
                {
                    this.val$fileName = string;
                }

                @Override
                public Writer run() throws IOException {
                    return new OutputStreamWriter((OutputStream)new FileOutputStream(this.val$fileName), "UTF-8");
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
        try {
            xmlFile.writeTheXMLFile(stmt, time, out, xsl);
        }
        finally {
            out.close();
        }
    }

    private static void generateHTML(String arg, String path, String style, boolean def) throws Exception {
        CreateHTMLFile htmlFile = new CreateHTMLFile();
        if (arg.toUpperCase().endsWith(".XML")) {
            htmlFile.getHTML(arg, style, path, def);
        } else {
            htmlFile.getHTML(arg.concat(".xml"), style, path, def);
        }
    }

    private static void printHelp() {
        System.out.println(LOC_RES.getTextMessage("PE_HelpText", new Object[0]));
    }

    private static void deleteFile(final String fileName) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                File delFile = new File(fileName);
                if (!delFile.exists()) {
                    return null;
                }
                delFile.delete();
                return null;
            }
        });
    }
}

