/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.InvalidMacException;

public class CbcBlockCipher {
    private static final byte[] FILLUP = Bytes.createBytes((Random)new SecureRandom(), (int)256);

    public static byte[] decrypt(CipherSuite suite, SecretKey key, SecretKey macKey, byte[] additionalData, byte[] ciphertext) throws GeneralSecurityException {
        int fragmentLength;
        byte[] plaintextOversized = new byte[ciphertext.length + Math.max(suite.getMacMessageBlockLength(), 256)];
        int ivlength = suite.getRecordIvLength();
        Cipher blockCipher = suite.getThreadLocalCipher();
        blockCipher.init(2, (Key)key, new IvParameterSpec(ciphertext, 0, ivlength));
        int plaintextLength = blockCipher.doFinal(ciphertext, ivlength, ciphertext.length - ivlength, plaintextOversized);
        System.arraycopy(FILLUP, 0, plaintextOversized, plaintextLength, suite.getMacMessageBlockLength());
        int macLength = suite.getMacLength();
        int paddingLength = plaintextOversized[plaintextLength - 1] & 0xFF;
        int fullLength = plaintextLength - macLength - 1;
        int leftLength = fullLength - paddingLength;
        if (leftLength < 0) {
            fragmentLength = fullLength;
            paddingLength = 0;
        } else {
            fragmentLength = leftLength;
        }
        if (!CbcBlockCipher.checkPadding(paddingLength, plaintextOversized, fragmentLength + macLength)) {
            fragmentLength = fullLength;
            paddingLength = 0;
        }
        int additionalIndex = additionalData.length - 2;
        additionalData[additionalIndex] = (byte)(fragmentLength >> 8 & 0xFF);
        additionalData[additionalIndex + 1] = (byte)(fragmentLength & 0xFF);
        MessageDigest md = suite.getThreadLocalMacMessageDigest();
        md.reset();
        byte[] mac = CbcBlockCipher.getBlockCipherMac(suite.getThreadLocalMac(), macKey, additionalData, plaintextOversized, fragmentLength);
        int macMessageLengthBytes = suite.getMacMessageLengthBytes();
        int macMessageBlockLength = suite.getMacMessageBlockLength();
        int macBytes = additionalData.length + fragmentLength + macMessageLengthBytes;
        int macBlocks1 = (macBytes + paddingLength) / macMessageBlockLength;
        int macBlocks2 = macBytes / macMessageBlockLength;
        int blocks = macBlocks1 - macBlocks2;
        md.update(plaintextOversized, fragmentLength, blocks * macMessageBlockLength + 1);
        md.reset();
        byte[] macFromMessage = Arrays.copyOfRange(plaintextOversized, fragmentLength, fragmentLength + macLength);
        boolean ok = MessageDigest.isEqual(macFromMessage, mac);
        Bytes.clear((byte[])mac);
        Bytes.clear((byte[])macFromMessage);
        byte[] payload = null;
        if (ok) {
            payload = Arrays.copyOf(plaintextOversized, fragmentLength);
        }
        Bytes.clear((byte[])plaintextOversized);
        if (!ok) {
            throw new InvalidMacException();
        }
        return payload;
    }

    public static byte[] encrypt(CipherSuite suite, SecretKey key, SecretKey macKey, byte[] additionalData, byte[] payload) throws GeneralSecurityException {
        DatagramWriter plainMessage = new DatagramWriter(true);
        plainMessage.writeBytes(payload);
        byte[] mac = CbcBlockCipher.getBlockCipherMac(suite.getThreadLocalMac(), macKey, additionalData, payload, payload.length);
        plainMessage.writeBytes(mac);
        Bytes.clear((byte[])mac);
        int ciphertextLength = payload.length + suite.getMacLength() + 1;
        int blocksize = suite.getRecordIvLength();
        int lastBlockBytes = ciphertextLength % blocksize;
        int paddingLength = lastBlockBytes > 0 ? blocksize - lastBlockBytes : 0;
        byte[] padding = new byte[paddingLength + 1];
        Arrays.fill(padding, (byte)paddingLength);
        plainMessage.writeBytes(padding);
        Bytes.clear((byte[])padding);
        Cipher blockCipher = suite.getThreadLocalCipher();
        blockCipher.init(1, key);
        byte[] iv = blockCipher.getIV();
        byte[] plaintext = plainMessage.toByteArray();
        plainMessage.close();
        byte[] message = Arrays.copyOf(iv, iv.length + plaintext.length);
        blockCipher.doFinal(plaintext, 0, plaintext.length, message, iv.length);
        return message;
    }

    public static byte[] getBlockCipherMac(Mac hmac, SecretKey macKey, byte[] additionalData, byte[] content, int length) throws InvalidKeyException {
        hmac.init(macKey);
        hmac.update(additionalData);
        hmac.update(content, 0, length);
        byte[] mac = hmac.doFinal();
        hmac.reset();
        return mac;
    }

    public static boolean checkPadding(int padding, byte[] data, int offset) {
        int index;
        if (data.length < offset + 257) {
            throw new IllegalArgumentException("data must contain 257 bytes from offset on!");
        }
        int result1 = 0;
        int result2 = 0;
        byte pad = (byte)padding;
        for (index = 0; index <= padding; ++index) {
            result1 = (byte)(result1 | pad ^ data[offset + index]);
        }
        for (index = padding + 1; index < 256; ++index) {
            result2 = (byte)(result2 | pad ^ data[offset + index]);
        }
        int n = data.length - 1;
        data[n] = (byte)(data[n] ^ result2);
        return result1 == 0;
    }
}

