"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.KMS = exports.cacheClients = exports.excludeRegions = exports.limitRegions = exports.getClient = exports.cacheKmsClients = exports.getKmsClient = exports.KmsKeyringNode = void 0;
const kms_keyring_1 = require("@aws-crypto/kms-keyring");
Object.defineProperty(exports, "getClient", { enumerable: true, get: function () { return kms_keyring_1.getClient; } });
Object.defineProperty(exports, "limitRegions", { enumerable: true, get: function () { return kms_keyring_1.limitRegions; } });
Object.defineProperty(exports, "excludeRegions", { enumerable: true, get: function () { return kms_keyring_1.excludeRegions; } });
Object.defineProperty(exports, "cacheClients", { enumerable: true, get: function () { return kms_keyring_1.cacheClients; } });
const material_management_node_1 = require("@aws-crypto/material-management-node");
const client_kms_1 = require("@aws-sdk/client-kms");
Object.defineProperty(exports, "KMS", { enumerable: true, get: function () { return client_kms_1.KMS; } });
const version_1 = require("./version");
const getKmsClient = (0, kms_keyring_1.getClient)(client_kms_1.KMS, {
    customUserAgent: `AwsEncryptionSdkJavascriptNodejs/${version_1.version}`,
});
exports.getKmsClient = getKmsClient;
const cacheKmsClients = (0, kms_keyring_1.cacheClients)(getKmsClient);
exports.cacheKmsClients = cacheKmsClients;
class KmsKeyringNode extends (0, kms_keyring_1.KmsKeyringClass)(material_management_node_1.KeyringNode) {
    constructor({ clientProvider = cacheKmsClients, keyIds, generatorKeyId, grantTokens, discovery, } = {}) {
        super({ clientProvider, keyIds, generatorKeyId, grantTokens, discovery });
    }
}
exports.KmsKeyringNode = KmsKeyringNode;
(0, material_management_node_1.immutableClass)(KmsKeyringNode);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia21zX2tleXJpbmdfbm9kZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9rbXNfa2V5cmluZ19ub2RlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxvRUFBb0U7QUFDcEUsc0NBQXNDOzs7QUFFdEMseURBVWdDO0FBcUM5QiwwRkExQ0EsdUJBQVMsT0EwQ0E7QUFDVCw2RkExQ0EsMEJBQVksT0EwQ0E7QUFDWiwrRkExQ0EsNEJBQWMsT0EwQ0E7QUFDZCw2RkExQ0EsMEJBQVksT0EwQ0E7QUF2Q2QsbUZBSzZDO0FBQzdDLG9EQUEwRDtBQWtDeEQsb0ZBbENPLGdCQUFHLE9Ba0NQO0FBakNMLHVDQUFtQztBQUNuQyxNQUFNLFlBQVksR0FBRyxJQUFBLHVCQUFTLEVBQUMsZ0JBQUcsRUFBRTtJQUNsQyxlQUFlLEVBQUUsb0NBQW9DLGlCQUFPLEVBQUU7Q0FDL0QsQ0FBQyxDQUFBO0FBd0JBLG9DQUFZO0FBdkJkLE1BQU0sZUFBZSxHQUFHLElBQUEsMEJBQVksRUFBQyxZQUFZLENBQUMsQ0FBQTtBQXdCaEQsMENBQWU7QUFsQmpCLE1BQWEsY0FBZSxTQUFRLElBQUEsNkJBQWUsRUFHakQsc0NBQW1DLENBQUM7SUFDcEMsWUFBWSxFQUNWLGNBQWMsR0FBRyxlQUFlLEVBQ2hDLE1BQU0sRUFDTixjQUFjLEVBQ2QsV0FBVyxFQUNYLFNBQVMsTUFDYyxFQUFFO1FBQ3pCLEtBQUssQ0FBQyxFQUFFLGNBQWMsRUFBRSxNQUFNLEVBQUUsY0FBYyxFQUFFLFdBQVcsRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFBO0lBQzNFLENBQUM7Q0FDRjtBQWJELHdDQWFDO0FBQ0QsSUFBQSx5Q0FBYyxFQUFDLGNBQWMsQ0FBQyxDQUFBIn0=