"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertEventStreamToObservable = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const convertEventStreamToObservable = stream => {
  const reader = stream.getReader();
  let observerOutside;
  const output$ = new _rxjs.Observable(observer => {
    observerOutside = observer;
    const decoder = new TextDecoder();
    async function processNextChunk() {
      try {
        const {
          done,
          value
        } = await reader.read();
        if (done) {
          observer.complete();
          return;
        }
        const chunk = decoder.decode(value);
        observer.next(chunk);
        processNextChunk();
      } catch (error) {
        observer.error(error);
      }
    }
    processNextChunk();
  });
  return {
    output$,
    cancel: () => {
      var _observerOutside;
      reader.cancel();
      (_observerOutside = observerOutside) === null || _observerOutside === void 0 || _observerOutside.complete();
    }
  };
};
exports.convertEventStreamToObservable = convertEventStreamToObservable;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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