"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseSuggestedActions = exports.BasicInputOutputParser = void 0;
var _dompurify = _interopRequireDefault(require("dompurify"));
var _jsdom = require("jsdom");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const sanitize = content => {
  const window = new _jsdom.JSDOM('').window;
  const DOMPurify = (0, _dompurify.default)(window);
  return DOMPurify.sanitize(content, {
    FORBID_TAGS: ['img']
  }).replace(/!+\[/g, '[');
};
const isStringArray = array => Array.isArray(array) && !!array.length && array.every(item => typeof item === 'string');
const parseSuggestedActions = value => {
  if (!value) {
    return [];
  }
  const suggestedOutputString = value;
  let suggestedActions = [];
  try {
    suggestedActions = JSON.parse(suggestedOutputString);
  } catch (e) {
    suggestedActions = [];
  }
  if (isStringArray(suggestedActions)) {
    return suggestedActions;
  }

  /**
   * Get json-like substring from a string
   *
   *  /\{                  // Match an opening curly brace
   *    .*                 // Match any preleading spaces and letters
   *    response[^\n]*\:   // Match "response" key because suggestion tool uses { response: [action1, action2] }
   *                       // in its prompt so that the parsedResult may contain a "response" field.
   *                       // If prompt changed, the logic here need to change accordingly.
   *    .*                 // Match any any string behind the "response:"
   *  \}/g             // Match a closing curly brace, and 'g' flag for global search
   *
   */
  const jsonPattern = /\{.*response[^\n]*\:.*\}/g;

  /**
   * Use the regular expression to find the JSON substring
   */
  const match = value.match(jsonPattern);
  const matchedResult = match && match[0];
  if (!matchedResult) {
    return [];
  }
  try {
    const parsedResult = JSON.parse(matchedResult);
    if (parsedResult !== null && parsedResult !== void 0 && parsedResult.response && isStringArray(parsedResult.response)) {
      return parsedResult.response;
    }
  } catch (e) {
    return [];
  }
  return [];
};
exports.parseSuggestedActions = parseSuggestedActions;
const BasicInputOutputParser = exports.BasicInputOutputParser = {
  order: 0,
  id: 'output_message',
  async parserProvider(interaction, options) {
    var _reverse$, _interaction$addition;
    /**
     * From UX, only the last interaction need to parse suggestedActions.
     */
    const isLatestInteraction = ((_reverse$ = [...options.interactions].reverse()[0]) === null || _reverse$ === void 0 ? void 0 : _reverse$.interaction_id) === interaction.interaction_id;
    const suggestedActions = isLatestInteraction ? parseSuggestedActions(((_interaction$addition = interaction.additional_info) === null || _interaction$addition === void 0 ? void 0 : _interaction$addition['QuestionSuggestor.output']) || '') : [];
    const inputItem = {
      type: 'input',
      contentType: 'text',
      content: interaction.input
    };
    const outputItems = [{
      type: 'output',
      contentType: 'markdown',
      content: sanitize(interaction.response),
      interactionId: interaction.interaction_id,
      suggestedActions: suggestedActions.filter(item => item).map(item => ({
        actionType: 'send_as_input',
        message: item
      }))
    }];
    return [inputItem, ...outputItems];
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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