"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_API_ROUTE_PREFIX = exports.MIN_SUPPORTED_VERSION = exports.MINIMUM_FULL_SUPPORTED_VERSION = exports.MAX_WORKFLOW_NAME_TO_DISPLAY = exports.MAX_TEMPLATE_STRING_LENGTH = exports.MAX_STRING_LENGTH = exports.MAX_JSON_STRING_LENGTH = exports.MAX_DOCS_TO_IMPORT = exports.MAX_DOCS = exports.MAX_DESCRIPTION_LENGTH = exports.MAX_BYTES_FORMATTED = exports.MAX_BYTES = exports.MATCH_QUERY_TEXT = exports.MATCH_PHRASE_QUERY_TEXT = exports.MATCH_PHRASE_PREFIX_QUERY_TEXT = exports.MATCH_BOOLEAN_QUERY_TEXT = exports.MAIN_PLUGIN_DOC_LINK = exports.LEFT_NAV_SELECTED_STYLE = exports.LABEL_FIELD_PATTERN = exports.KNN_VECTOR_DOCS_LINK = exports.KNN_QUERY = exports.JSONPATH_ROOT_SELECTOR = exports.JSONPATH_DOCS_LINK = exports.JSONLINES_LINK = exports.INVALID_DATASOURCE_MSG = exports.INSPECTOR_TAB_ID = exports.INSPECTOR_TABS = exports.INPUT_TRANSFORM_OPTIONS = exports.INGEST_PIPELINE_NODE_API_PATH = exports.INGEST_NODE_API_PATH = exports.INDEX_NOT_FOUND_EXCEPTION = exports.INDEX_NAME_REGEXP = exports.IMAGE_FIELD_PATTERN = exports.HYBRID_SEARCH_QUERY_MATCH_TERM = exports.HYBRID_SEARCH_QUERY_MATCH_NEURAL = exports.HYBRID_SEARCH_QUERY_MATCH_KNN = exports.GITHUB_FEEDBACK_LINK = exports.GET_WORKFLOW_STATE_NODE_API_PATH = exports.GET_WORKFLOW_NODE_API_PATH = exports.GET_PRESET_WORKFLOWS_NODE_API_PATH = exports.GET_MAPPINGS_NODE_API_PATH = exports.GET_INDEX_NODE_API_PATH = exports.GENERAL_TEXT_GENERATION_PROMPT = exports.GENERAL_SUMMARIZE_PROMPT = exports.GENERAL_QA_WITH_CONTEXT_PROMPT = exports.GENERAL_QA_NO_CONTEXT_PROMPT = exports.FUZZY_QUERY_TEXT = exports.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = exports.FLOW_FRAMEWORK_API_ROUTE_PREFIX = exports.FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = exports.FETCH_ALL_QUERY_LARGE = exports.FETCH_ALL_QUERY = exports.EXPANDED_FORM_QUERY_ISSUE = exports.EXISTS_QUERY_TEXT = exports.ERROR_GETTING_WORKFLOW_MSG = exports.EMPTY_OUTPUT_MAP_ENTRY = exports.EMPTY_MAP_ENTRY = exports.EMPTY_INPUT_MAP_ENTRY = exports.EMPTY_FIELD_STRING = exports.DEPROVISION_WORKFLOW_NODE_API_PATH = exports.DELIMITER_OPTIONAL_FIELDS = exports.DELETE_WORKFLOW_NODE_API_PATH = exports.DEFAULT_VECTOR_FIELD = exports.DEFAULT_TEXT_FIELD = exports.DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = exports.DEFAULT_PROMPT_ROLE_FIELD = exports.DEFAULT_PROMPT_RESULTS_FIELD = exports.DEFAULT_PROMPT_QUESTION_FIELD = exports.DEFAULT_NEW_WORKFLOW_STATE_TYPE = exports.DEFAULT_NEW_WORKFLOW_NAME = exports.DEFAULT_NEW_WORKFLOW_DESCRIPTION = exports.DEFAULT_LLM_RESPONSE_FIELD = exports.DEFAULT_K = exports.DEFAULT_IMAGE_FIELD = exports.DEFAULT_FETCH_SIZE = exports.DEEPSEEK_CHAT_DOCS_LINK = exports.DATE_FORMAT_PATTERN = exports.CREATE_WORKFLOW_NODE_API_PATH = exports.CREATE_WORKFLOW_LINK = exports.CONFIG_STEP = exports.COMPONENT_ID = exports.COMPONENT_CLASS = exports.COMPONENT_CATEGORY = exports.COHERE_EMBEDDING_MODEL_DOCS_LINK = exports.COHERE_CONFIGS = exports.CLAUDE_SUMMARIZE_PROMPT = exports.CLAUDE_QA_WITH_CONTEXT_PROMPT = exports.CAT_INDICES_NODE_API_PATH = exports.BULK_NODE_API_PATH = exports.BULK_API_DOCS_LINK = exports.BEDROCK_TITAN_EMBEDDING_DOCS_LINK = exports.BEDROCK_CONFIGS = exports.BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = exports.BASE_WORKFLOW_NODE_API_PATH = exports.BASE_OPENSEARCH_NODE_API_PATH = exports.BASE_NODE_API_PATH = exports.BASE_MODEL_NODE_API_PATH = exports.BASE_CONNECTOR_NODE_API_PATH = void 0;
exports.WORKFLOW_TYPE_LEGACY = exports.WORKFLOW_TYPE = exports.WORKFLOW_TUTORIAL_LINK = exports.WORKFLOW_NAME_RESTRICTIONS = exports.WORKFLOW_NAME_REGEXP = exports.WILDCARD_QUERY_TEXT = exports.VECTOR_TEMPLATE_PLACEHOLDER = exports.VECTOR_PATTERN = exports.VECTOR_FIELD_PATTERN = exports.VECTOR = exports.UPDATE_WORKFLOW_NODE_API_PATH = exports.UPDATE_MODEL_DOCS_LINK = exports.UI_METADATA_SCHEMA_VERSION = exports.TRANSFORM_TYPE = exports.TRANSFORM_CONTEXT = exports.TEXT_FIELD_PATTERN = exports.TEXT_CHUNKING_PROCESSOR_LINK = exports.TEXT_CHUNKING_ALGORITHM = exports.TERM_QUERY_TEXT = exports.SOURCE_OPTIONS = exports.SORT_ORDER = exports.SIMULATE_PIPELINE_NODE_API_PATH = exports.SHARED_OPTIONAL_FIELDS = exports.SEMANTIC_SEARCH_TEMPLATE_QUERY = exports.SEMANTIC_SEARCH_QUERY_NEURAL = exports.SEARCH_WORKFLOWS_NODE_API_PATH = exports.SEARCH_PIPELINE_ROUTE = exports.SEARCH_PIPELINE_NODE_API_PATH = exports.SEARCH_PIPELINE_DOCS_LINK = exports.SEARCH_MODELS_NODE_API_PATH = exports.SEARCH_INDEX_NODE_API_PATH = exports.SEARCH_CONNECTORS_NODE_API_PATH = exports.SAGEMAKER_SPARSE_DEPLOY_LINK = exports.REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = exports.REQUEST_PREFIX = exports.QUERY_TEXT_PATTERN = exports.QUERY_STRING_QUERY_TEXT = exports.QUERY_PRESETS = exports.QUERY_IMAGE_PATTERN = exports.PROVISION_WORKFLOW_NODE_API_PATH = exports.PROVISION_TIMEOUT = exports.PROMPT_PRESETS = exports.PROCESSOR_TYPE = exports.PROCESSOR_CONTEXT = exports.PREFIX_QUERY_TEXT = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OUTPUT_TRANSFORM_OPTIONS = exports.OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = exports.OPENSEARCH_FLOW = exports.OPENAI_GPT35_DOCS_LINK = exports.OPENAI_CONFIGS = exports.OMIT_SYSTEM_INDEX_PATTERN = exports.NO_TRANSFORMATION = exports.NO_TEMPLATES_FOUND_MSG = exports.NO_MODIFICATIONS_FOUND_TEXT = exports.NORMALIZATION_PROCESSOR_LINK = exports.NODE_CATEGORY = exports.NEURAL_SPARSE_SEARCH_QUERY = exports.NEURAL_SPARSE_CONFIGS = exports.MULTIMODAL_SEARCH_QUERY_NEURAL = exports.MULTIMODAL_SEARCH_QUERY_BOOL = exports.MODEL_TYPE = exports.MODEL_OUTPUT_SCHEMA_NESTED_PATH = exports.MODEL_OUTPUT_SCHEMA_FULL_PATH = exports.MODEL_ID_PATTERN = exports.MODEL_CATEGORY = exports.ML_SEARCH_MODELS_ROUTE = exports.ML_SEARCH_CONNECTORS_ROUTE = exports.ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = exports.ML_REMOTE_MODEL_LINK = exports.ML_MODEL_ROUTE_PREFIX = exports.ML_MODELS_SETUP_DOCS_LINK = exports.ML_INTERFACE_LINK = exports.ML_INFERENCE_RESPONSE_DOCS_LINK = exports.ML_INFERENCE_DOCS_LINK = exports.ML_CONNECTOR_ROUTE_PREFIX = void 0;
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'opensearch-flow';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'AI Search Flows'; // visible plugin name in the context of OSD
const OPENSEARCH_FLOW = exports.OPENSEARCH_FLOW = 'OpenSearch Flow'; // overall feature / name that the plugin encapsulates

/**
 * BACKEND FLOW FRAMEWORK APIs
 */
const FLOW_FRAMEWORK_API_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_API_ROUTE_PREFIX = '/_plugins/_flow_framework';
const FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = `${FLOW_FRAMEWORK_API_ROUTE_PREFIX}/workflow`;
const FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = `${FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/_search`;
const FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = `${FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/state/_search`;

/**
 * BACKEND ML PLUGIN APIs
 */
const ML_API_ROUTE_PREFIX = exports.ML_API_ROUTE_PREFIX = '/_plugins/_ml';
const ML_MODEL_ROUTE_PREFIX = exports.ML_MODEL_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/models`;
const ML_CONNECTOR_ROUTE_PREFIX = exports.ML_CONNECTOR_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/connectors`;
const ML_SEARCH_MODELS_ROUTE = exports.ML_SEARCH_MODELS_ROUTE = `${ML_MODEL_ROUTE_PREFIX}/_search`;
const ML_SEARCH_CONNECTORS_ROUTE = exports.ML_SEARCH_CONNECTORS_ROUTE = `${ML_CONNECTOR_ROUTE_PREFIX}/_search`;

/**
 * OpenSearch APIs
 */
const SEARCH_PIPELINE_ROUTE = exports.SEARCH_PIPELINE_ROUTE = '/_search/pipeline';

/**
 * NODE APIs
 */
const BASE_NODE_API_PATH = exports.BASE_NODE_API_PATH = '/api/flow_framework';

// OpenSearch node APIs
const BASE_OPENSEARCH_NODE_API_PATH = exports.BASE_OPENSEARCH_NODE_API_PATH = `${BASE_NODE_API_PATH}/opensearch`;
const CAT_INDICES_NODE_API_PATH = exports.CAT_INDICES_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/catIndices`;
const GET_MAPPINGS_NODE_API_PATH = exports.GET_MAPPINGS_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/mappings`;
const GET_INDEX_NODE_API_PATH = exports.GET_INDEX_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getIndex`;
const SEARCH_INDEX_NODE_API_PATH = exports.SEARCH_INDEX_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/search`;
const INGEST_NODE_API_PATH = exports.INGEST_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/ingest`;
const BULK_NODE_API_PATH = exports.BULK_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/bulk`;
const SIMULATE_PIPELINE_NODE_API_PATH = exports.SIMULATE_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/simulatePipeline`;
const INGEST_PIPELINE_NODE_API_PATH = exports.INGEST_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getIngestPipeline`;
const SEARCH_PIPELINE_NODE_API_PATH = exports.SEARCH_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getSearchPipeline`;

// Flow Framework node APIs
const BASE_WORKFLOW_NODE_API_PATH = exports.BASE_WORKFLOW_NODE_API_PATH = `${BASE_NODE_API_PATH}/workflow`;
const GET_WORKFLOW_NODE_API_PATH = exports.GET_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}`;
const SEARCH_WORKFLOWS_NODE_API_PATH = exports.SEARCH_WORKFLOWS_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/search`;
const GET_WORKFLOW_STATE_NODE_API_PATH = exports.GET_WORKFLOW_STATE_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/state`;
const CREATE_WORKFLOW_NODE_API_PATH = exports.CREATE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/create`;
const UPDATE_WORKFLOW_NODE_API_PATH = exports.UPDATE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/update`;
const PROVISION_WORKFLOW_NODE_API_PATH = exports.PROVISION_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/provision`;
const DEPROVISION_WORKFLOW_NODE_API_PATH = exports.DEPROVISION_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/deprovision`;
const DELETE_WORKFLOW_NODE_API_PATH = exports.DELETE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/delete`;
const GET_PRESET_WORKFLOWS_NODE_API_PATH = exports.GET_PRESET_WORKFLOWS_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/presets`;

// ML Plugin node APIs
const BASE_MODEL_NODE_API_PATH = exports.BASE_MODEL_NODE_API_PATH = `${BASE_NODE_API_PATH}/model`;
const BASE_CONNECTOR_NODE_API_PATH = exports.BASE_CONNECTOR_NODE_API_PATH = `${BASE_NODE_API_PATH}/connector`;
const SEARCH_MODELS_NODE_API_PATH = exports.SEARCH_MODELS_NODE_API_PATH = `${BASE_MODEL_NODE_API_PATH}/search`;
const SEARCH_CONNECTORS_NODE_API_PATH = exports.SEARCH_CONNECTORS_NODE_API_PATH = `${BASE_CONNECTOR_NODE_API_PATH}/search`;

/**
 * Remote model dimensions. Used for attempting to pre-fill dimension size
 * based on the specified remote model from a remote service, if found
 */

// Amazon BedRock
const BEDROCK_CONFIGS = exports.BEDROCK_CONFIGS = {
  [`amazon.titan-embed-text-v1`]: {
    dimension: 1536,
    fieldName: 'embedding'
  },
  [`amazon.titan-embed-text-v2`]: {
    dimension: 1024,
    fieldName: 'embedding'
  },
  [`amazon.titan-embed-image-v1`]: {
    dimension: 1024,
    fieldName: 'embedding'
  },
  [`cohere.embed-english-v3`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`cohere.embed-multilingual-v3`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  }
};

// Cohere
const COHERE_CONFIGS = exports.COHERE_CONFIGS = {
  [`embed-english-v3.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-english-light-v3.0`]: {
    dimension: 384,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-v3.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-light-v3.0`]: {
    dimension: 384,
    fieldName: 'embeddings'
  },
  [`embed-english-v2.0`]: {
    dimension: 4096,
    fieldName: 'embeddings'
  },
  [`embed-english-light-v2.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-v2.0`]: {
    dimension: 768,
    fieldName: 'embeddings'
  }
};

// OpenAI
const OPENAI_CONFIGS = exports.OPENAI_CONFIGS = {
  [`text-embedding-3-small`]: {
    dimension: 1536,
    fieldName: 'embedding'
  },
  [`text-embedding-3-large`]: {
    dimension: 3072,
    fieldName: 'embedding'
  },
  [`text-embedding-ada-002`]: {
    dimension: 1536,
    fieldName: 'embedding'
  }
};

// Neural Sparse
const NEURAL_SPARSE_CONFIGS = exports.NEURAL_SPARSE_CONFIGS = {
  [`opensearch-neural-sparse-encoding-v2-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-v1`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-multilingual-v1`]: {
    dimension: 105879,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v2-mini`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v3-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v1`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v2-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  }
};

/**
 * Various constants pertaining to Workflow configs
 */

/**
 * Schema versioning for tracking all changes made to the config fields within ui_metadata. Used for BWC and debugging.
 * Version 1: Initial release
 * Version 2: Updates ML search response processor to have an additional "ext_output" field. https://github.com/opensearch-project/dashboards-flow-framework/pull/699
 */
const UI_METADATA_SCHEMA_VERSION = exports.UI_METADATA_SCHEMA_VERSION = 2;

// frontend-specific workflow types, derived from the available preset templates
let WORKFLOW_TYPE = exports.WORKFLOW_TYPE = /*#__PURE__*/function (WORKFLOW_TYPE) {
  WORKFLOW_TYPE["SEMANTIC_SEARCH"] = "Semantic Search";
  WORKFLOW_TYPE["MULTIMODAL_SEARCH"] = "Multimodal Search";
  WORKFLOW_TYPE["HYBRID_SEARCH"] = "Hybrid Search";
  WORKFLOW_TYPE["VECTOR_SEARCH_WITH_RAG"] = "RAG with Vector Retrieval";
  WORKFLOW_TYPE["HYBRID_SEARCH_WITH_RAG"] = "RAG with Hybrid Search";
  WORKFLOW_TYPE["SEMANTIC_SEARCH_USING_SPARSE_ENCODERS"] = "Semantic Search using Sparse Encoders";
  WORKFLOW_TYPE["CUSTOM"] = "Custom Search";
  WORKFLOW_TYPE["UNKNOWN"] = "Unknown";
  return WORKFLOW_TYPE;
}({});
let WORKFLOW_TYPE_LEGACY = exports.WORKFLOW_TYPE_LEGACY = /*#__PURE__*/function (WORKFLOW_TYPE_LEGACY) {
  WORKFLOW_TYPE_LEGACY["SEMANTIC_SEARCH"] = "Semantic Search";
  WORKFLOW_TYPE_LEGACY["MULTIMODAL_SEARCH"] = "Multimodal Search";
  WORKFLOW_TYPE_LEGACY["HYBRID_SEARCH"] = "Hybrid Search";
  WORKFLOW_TYPE_LEGACY["CUSTOM"] = "Custom Search";
  WORKFLOW_TYPE_LEGACY["UNKNOWN"] = "Unknown";
  return WORKFLOW_TYPE_LEGACY;
}({}); // If no datasource version is found, we default to 2.17.0
const MIN_SUPPORTED_VERSION = exports.MIN_SUPPORTED_VERSION = '2.17.0';
// Min version to support ML processors
const MINIMUM_FULL_SUPPORTED_VERSION = exports.MINIMUM_FULL_SUPPORTED_VERSION = '2.19.0';

// the names should be consistent with the underlying implementation. used when generating the
// final ingest/search pipeline configurations.
let PROCESSOR_TYPE = exports.PROCESSOR_TYPE = /*#__PURE__*/function (PROCESSOR_TYPE) {
  PROCESSOR_TYPE["ML"] = "ml_inference";
  PROCESSOR_TYPE["SPLIT"] = "split";
  PROCESSOR_TYPE["SORT"] = "sort";
  PROCESSOR_TYPE["TEXT_CHUNKING"] = "text_chunking";
  PROCESSOR_TYPE["NORMALIZATION"] = "normalization-processor";
  PROCESSOR_TYPE["COLLAPSE"] = "collapse";
  PROCESSOR_TYPE["RERANK"] = "rerank";
  PROCESSOR_TYPE["TEXT_EMBEDDING"] = "text_embedding";
  PROCESSOR_TYPE["TEXT_IMAGE_EMBEDDING"] = "text_image_embedding";
  PROCESSOR_TYPE["COPY"] = "copy";
  return PROCESSOR_TYPE;
}({});
let MODEL_TYPE = exports.MODEL_TYPE = /*#__PURE__*/function (MODEL_TYPE) {
  MODEL_TYPE["TEXT_EMBEDDING"] = "text_embedding";
  MODEL_TYPE["SPARSE_ENCODER"] = "sparse_encoder";
  return MODEL_TYPE;
}({});
let MODEL_CATEGORY = exports.MODEL_CATEGORY = /*#__PURE__*/function (MODEL_CATEGORY) {
  MODEL_CATEGORY["EMBEDDING"] = "EMBEDDING";
  MODEL_CATEGORY["LLM"] = "LLM";
  MODEL_CATEGORY["SPARSE_ENCODER"] = "SPARSE_ENCODER";
  return MODEL_CATEGORY;
}({});
/**
 * Various constants pertaining to the drag-and-drop UI components
 */
let COMPONENT_CATEGORY = exports.COMPONENT_CATEGORY = /*#__PURE__*/function (COMPONENT_CATEGORY) {
  COMPONENT_CATEGORY["INGEST"] = "Ingest";
  COMPONENT_CATEGORY["SEARCH"] = "Search";
  return COMPONENT_CATEGORY;
}({});
let NODE_CATEGORY = exports.NODE_CATEGORY = /*#__PURE__*/function (NODE_CATEGORY) {
  NODE_CATEGORY["CUSTOM"] = "custom";
  NODE_CATEGORY["INGEST_GROUP"] = "ingestGroup";
  NODE_CATEGORY["SEARCH_GROUP"] = "searchGroup";
  return NODE_CATEGORY;
}({});
/**
 * A base set of component classes / types.
 */
let COMPONENT_CLASS = exports.COMPONENT_CLASS = /*#__PURE__*/function (COMPONENT_CLASS) {
  COMPONENT_CLASS["INDEX"] = "index";
  COMPONENT_CLASS["KNN_INDEX"] = "knn_index";
  COMPONENT_CLASS["TRANSFORMER"] = "transformer";
  COMPONENT_CLASS["ML_TRANSFORMER"] = "ml_transformer";
  COMPONENT_CLASS["SEARCH_REQUEST"] = "search_request";
  COMPONENT_CLASS["DOCUMENT"] = "document";
  COMPONENT_CLASS["SEARCH_RESPONSE"] = "search_response";
  return COMPONENT_CLASS;
}({});
/**
 * LINKS
 */
const ML_INFERENCE_DOCS_LINK = exports.ML_INFERENCE_DOCS_LINK = 'https://opensearch.org/docs/latest/ingest-pipelines/processors/ml-inference/#configuration-parameters';
const ML_INFERENCE_RESPONSE_DOCS_LINK = exports.ML_INFERENCE_RESPONSE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/ml-inference-search-response/#request-fields';
const ML_REMOTE_MODEL_LINK = exports.ML_REMOTE_MODEL_LINK = 'https://docs.opensearch.org/docs/latest/ml-commons-plugin/remote-models/supported-connectors/';
const ML_INTERFACE_LINK = exports.ML_INTERFACE_LINK = 'https://docs.opensearch.org/docs/latest/ml-commons-plugin/api/model-apis/register-model/#the-interface-parameter';
const TEXT_CHUNKING_PROCESSOR_LINK = exports.TEXT_CHUNKING_PROCESSOR_LINK = 'https://opensearch.org/docs/latest/ingest-pipelines/processors/text-chunking/';
const CREATE_WORKFLOW_LINK = exports.CREATE_WORKFLOW_LINK = 'https://opensearch.org/docs/latest/automating-configurations/api/create-workflow/';
const WORKFLOW_TUTORIAL_LINK = exports.WORKFLOW_TUTORIAL_LINK = 'https://opensearch.org/docs/latest/automating-configurations/workflow-tutorial/';
const MAIN_PLUGIN_DOC_LINK = exports.MAIN_PLUGIN_DOC_LINK = 'https://docs.opensearch.org/latest/vector-search/ai-search/workflow-builder/';
const NORMALIZATION_PROCESSOR_LINK = exports.NORMALIZATION_PROCESSOR_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/normalization-processor/';
const GITHUB_FEEDBACK_LINK = exports.GITHUB_FEEDBACK_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/issues/new/choose';
const JSONPATH_DOCS_LINK = exports.JSONPATH_DOCS_LINK = 'https://www.npmjs.com/package/jsonpath-plus';
const KNN_VECTOR_DOCS_LINK = exports.KNN_VECTOR_DOCS_LINK = 'https://opensearch.org/docs/latest/field-types/supported-field-types/knn-vector/';
const BULK_API_DOCS_LINK = exports.BULK_API_DOCS_LINK = 'https://opensearch.org/docs/latest/api-reference/document-apis/bulk/';
const SEARCH_PIPELINE_DOCS_LINK = exports.SEARCH_PIPELINE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/using-search-pipeline/';
const ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = exports.ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/ml-inference-search-response/#example-externally-hosted-text-embedding-model';
const UPDATE_MODEL_DOCS_LINK = exports.UPDATE_MODEL_DOCS_LINK = 'https://opensearch.org/docs/latest/ml-commons-plugin/api/model-apis/update-model/';
const JSONLINES_LINK = exports.JSONLINES_LINK = 'https://jsonlines.org/';
const EXPANDED_FORM_QUERY_ISSUE = exports.EXPANDED_FORM_QUERY_ISSUE = 'https://github.com/opensearch-project/OpenSearch/issues/17358';

// Large Language Models Documentation Links
const BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = exports.BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#claude-3-sonnet-hosted-on-amazon-bedrock';
const OPENAI_GPT35_DOCS_LINK = exports.OPENAI_GPT35_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#openai-gpt-35';
const DEEPSEEK_CHAT_DOCS_LINK = exports.DEEPSEEK_CHAT_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#deepseek-chat';

// Embedding Models Documentation Links
const COHERE_EMBEDDING_MODEL_DOCS_LINK = exports.COHERE_EMBEDDING_MODEL_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#cohere-embed';
const BEDROCK_TITAN_EMBEDDING_DOCS_LINK = exports.BEDROCK_TITAN_EMBEDDING_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#amazon-bedrock-titan-text-embedding';

// Sparse Encoder Models Documentation Links
const OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = exports.OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = 'https://huggingface.co/opensearch-project/opensearch-neural-sparse-encoding-v2-distill';

// TODO: Update this with the official OpenSearch documentation URL when it's available
const SAGEMAKER_SPARSE_DEPLOY_LINK = exports.SAGEMAKER_SPARSE_DEPLOY_LINK = 'https://github.com/zhichao-aws/opensearch-neural-sparse-sample/tree/main/examples/deploy_on_sagemaker';

// ML Models setup Documentation Link
const ML_MODELS_SETUP_DOCS_LINK = exports.ML_MODELS_SETUP_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md';

/**
 * Text chunking algorithm constants
 */
let TEXT_CHUNKING_ALGORITHM = exports.TEXT_CHUNKING_ALGORITHM = /*#__PURE__*/function (TEXT_CHUNKING_ALGORITHM) {
  TEXT_CHUNKING_ALGORITHM["FIXED_TOKEN_LENGTH"] = "fixed_token_length";
  TEXT_CHUNKING_ALGORITHM["DELIMITER"] = "delimiter";
  return TEXT_CHUNKING_ALGORITHM;
}({});
const FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = exports.FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = ['token_limit', 'tokenizer', 'overlap_rate'];
const DELIMITER_OPTIONAL_FIELDS = exports.DELIMITER_OPTIONAL_FIELDS = ['delimiter'];
const SHARED_OPTIONAL_FIELDS = exports.SHARED_OPTIONAL_FIELDS = ['max_chunk_limit', 'description', 'tag'];

/**
 * DEFAULT FIELD VALUES
 */
const DEFAULT_TEXT_FIELD = exports.DEFAULT_TEXT_FIELD = 'my_text';
const DEFAULT_VECTOR_FIELD = exports.DEFAULT_VECTOR_FIELD = 'my_embedding';
const DEFAULT_IMAGE_FIELD = exports.DEFAULT_IMAGE_FIELD = 'my_image';
const DEFAULT_LLM_RESPONSE_FIELD = exports.DEFAULT_LLM_RESPONSE_FIELD = 'llm_response';

/**
 * QUERY PRESETS
 */
const VECTOR_FIELD_PATTERN = exports.VECTOR_FIELD_PATTERN = `{{vector_field}}`;
const TEXT_FIELD_PATTERN = exports.TEXT_FIELD_PATTERN = `{{text_field}}`;
const IMAGE_FIELD_PATTERN = exports.IMAGE_FIELD_PATTERN = `{{image_field}}`;
const LABEL_FIELD_PATTERN = exports.LABEL_FIELD_PATTERN = `{{label_field}}`;
const QUERY_TEXT_PATTERN = exports.QUERY_TEXT_PATTERN = `{{query_text}}`;
const QUERY_IMAGE_PATTERN = exports.QUERY_IMAGE_PATTERN = `{{query_image}}`;
const MODEL_ID_PATTERN = exports.MODEL_ID_PATTERN = `{{model_id}}`;
const VECTOR = exports.VECTOR = 'vector';
const VECTOR_PATTERN = exports.VECTOR_PATTERN = `{{${VECTOR}}}`;
const VECTOR_TEMPLATE_PLACEHOLDER = exports.VECTOR_TEMPLATE_PLACEHOLDER = `\$\{${VECTOR}\}`;
const DEFAULT_K = exports.DEFAULT_K = 10;
const DEFAULT_FETCH_SIZE = exports.DEFAULT_FETCH_SIZE = 10;

// term-level queries
const TERM_QUERY_TEXT = exports.TERM_QUERY_TEXT = {
  query: {
    term: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
const EXISTS_QUERY_TEXT = exports.EXISTS_QUERY_TEXT = {
  query: {
    exists: {
      field: TEXT_FIELD_PATTERN
    }
  }
};
const FUZZY_QUERY_TEXT = exports.FUZZY_QUERY_TEXT = {
  query: {
    fuzzy: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
const WILDCARD_QUERY_TEXT = exports.WILDCARD_QUERY_TEXT = {
  query: {
    wildcard: {
      [TEXT_FIELD_PATTERN]: {
        wildcard: QUERY_TEXT_PATTERN,
        case_insensitive: false
      }
    }
  }
};
const PREFIX_QUERY_TEXT = exports.PREFIX_QUERY_TEXT = {
  query: {
    prefix: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
// full-text queries
const MATCH_QUERY_TEXT = exports.MATCH_QUERY_TEXT = {
  query: {
    match: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_BOOLEAN_QUERY_TEXT = exports.MATCH_BOOLEAN_QUERY_TEXT = {
  query: {
    match_bool_prefix: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_PHRASE_QUERY_TEXT = exports.MATCH_PHRASE_QUERY_TEXT = {
  query: {
    match_phrase: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_PHRASE_PREFIX_QUERY_TEXT = exports.MATCH_PHRASE_PREFIX_QUERY_TEXT = {
  query: {
    match_phrase_prefix: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const QUERY_STRING_QUERY_TEXT = exports.QUERY_STRING_QUERY_TEXT = {
  query: {
    query_string: {
      query: QUERY_TEXT_PATTERN
    }
  }
};
// misc / other queries
const FETCH_ALL_QUERY = exports.FETCH_ALL_QUERY = {
  query: {
    match_all: {}
  },
  size: DEFAULT_FETCH_SIZE
};
const FETCH_ALL_QUERY_LARGE = exports.FETCH_ALL_QUERY_LARGE = {
  query: {
    match_all: {}
  },
  size: 1000
};
const KNN_QUERY = exports.KNN_QUERY = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    knn: {
      [VECTOR_FIELD_PATTERN]: {
        vector: VECTOR_PATTERN,
        k: DEFAULT_K
      }
    }
  },
  size: 10
};
const SEMANTIC_SEARCH_QUERY_NEURAL = exports.SEMANTIC_SEARCH_QUERY_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural: {
      [VECTOR_FIELD_PATTERN]: {
        query_text: QUERY_TEXT_PATTERN,
        model_id: MODEL_ID_PATTERN,
        k: DEFAULT_K
      }
    }
  }
};
const SEMANTIC_SEARCH_TEMPLATE_QUERY = exports.SEMANTIC_SEARCH_TEMPLATE_QUERY = {
  query: {
    template: {
      knn: {
        [VECTOR_FIELD_PATTERN]: {
          vector: VECTOR_PATTERN,
          k: 2
        }
      }
    }
  },
  ext: {
    ml_inference: {
      text: QUERY_TEXT_PATTERN
    }
  }
};
const MULTIMODAL_SEARCH_QUERY_NEURAL = exports.MULTIMODAL_SEARCH_QUERY_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural: {
      [VECTOR_FIELD_PATTERN]: {
        query_text: QUERY_TEXT_PATTERN,
        query_image: QUERY_IMAGE_PATTERN,
        model_id: MODEL_ID_PATTERN,
        k: DEFAULT_K
      }
    }
  }
};
const MULTIMODAL_SEARCH_QUERY_BOOL = exports.MULTIMODAL_SEARCH_QUERY_BOOL = {
  query: {
    bool: {
      must: [{
        match: {
          [TEXT_FIELD_PATTERN]: QUERY_TEXT_PATTERN
        }
      }, {
        match: {
          [IMAGE_FIELD_PATTERN]: QUERY_IMAGE_PATTERN
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_KNN = exports.HYBRID_SEARCH_QUERY_MATCH_KNN = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        knn: {
          [VECTOR_FIELD_PATTERN]: {
            vector: VECTOR_PATTERN,
            k: DEFAULT_K
          }
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_NEURAL = exports.HYBRID_SEARCH_QUERY_MATCH_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        neural: {
          [VECTOR_FIELD_PATTERN]: {
            query_text: QUERY_TEXT_PATTERN,
            model_id: MODEL_ID_PATTERN,
            k: DEFAULT_K
          }
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_TERM = exports.HYBRID_SEARCH_QUERY_MATCH_TERM = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        term: {
          [TEXT_FIELD_PATTERN]: {
            value: QUERY_TEXT_PATTERN
          }
        }
      }]
    }
  }
};
const NEURAL_SPARSE_SEARCH_QUERY = exports.NEURAL_SPARSE_SEARCH_QUERY = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural_sparse: {
      [VECTOR_FIELD_PATTERN]: {
        query_tokens: VECTOR_PATTERN
      }
    }
  }
};
const QUERY_PRESETS = exports.QUERY_PRESETS = [{
  name: 'Fetch all',
  query: (0, _utils.customStringify)(FETCH_ALL_QUERY)
}, {
  name: 'Term',
  query: (0, _utils.customStringify)(TERM_QUERY_TEXT)
}, {
  name: 'Match',
  query: (0, _utils.customStringify)(MATCH_QUERY_TEXT)
}, {
  name: 'Exists',
  query: (0, _utils.customStringify)(EXISTS_QUERY_TEXT)
}, {
  name: 'Fuzzy',
  query: (0, _utils.customStringify)(FUZZY_QUERY_TEXT)
}, {
  name: 'Wildcard',
  query: (0, _utils.customStringify)(WILDCARD_QUERY_TEXT)
}, {
  name: 'Prefix',
  query: (0, _utils.customStringify)(PREFIX_QUERY_TEXT)
}, {
  name: 'Match boolean',
  query: (0, _utils.customStringify)(MATCH_BOOLEAN_QUERY_TEXT)
}, {
  name: 'Match phrase',
  query: (0, _utils.customStringify)(MATCH_PHRASE_QUERY_TEXT)
}, {
  name: 'Match phrase prefix',
  query: (0, _utils.customStringify)(MATCH_PHRASE_PREFIX_QUERY_TEXT)
}, {
  name: 'Query string',
  query: (0, _utils.customStringify)(QUERY_STRING_QUERY_TEXT)
}, {
  name: 'Basic k-NN',
  query: (0, _utils.customStringify)(KNN_QUERY)
}, {
  name: WORKFLOW_TYPE.MULTIMODAL_SEARCH,
  query: (0, _utils.customStringify)(MULTIMODAL_SEARCH_QUERY_BOOL)
}, {
  name: 'Neural Sparse Search Query',
  query: (0, _utils.customStringify)(NEURAL_SPARSE_SEARCH_QUERY)
}, {
  name: 'Semantic search (neural query)',
  query: (0, _utils.customStringify)(SEMANTIC_SEARCH_QUERY_NEURAL)
}, {
  name: 'Semantic search (template query)',
  query: (0, _utils.customStringify)(SEMANTIC_SEARCH_TEMPLATE_QUERY)
}, {
  name: `Hybrid search (match & k-NN queries)`,
  query: (0, _utils.customStringify)(HYBRID_SEARCH_QUERY_MATCH_KNN)
}, {
  name: `Hybrid search (match & term queries)`,
  query: (0, _utils.customStringify)(HYBRID_SEARCH_QUERY_MATCH_TERM)
}];

/**
 * DEFAULT TEMPLATE VAR NAMES
 */
const DEFAULT_PROMPT_RESULTS_FIELD = exports.DEFAULT_PROMPT_RESULTS_FIELD = 'results';
const DEFAULT_PROMPT_QUESTION_FIELD = exports.DEFAULT_PROMPT_QUESTION_FIELD = 'question';
const DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = exports.DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = 'textCategory';
const DEFAULT_PROMPT_ROLE_FIELD = exports.DEFAULT_PROMPT_ROLE_FIELD = 'role';

/**
 * PROMPT PRESETS. Based off of https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-templates-and-examples.html
 */
const GENERAL_SUMMARIZE_PROMPT = exports.GENERAL_SUMMARIZE_PROMPT = 'Read the following text: \
\n\n${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()} \
\n\nSummarize the text in one sentence.';
const GENERAL_QA_WITH_CONTEXT_PROMPT = exports.GENERAL_QA_WITH_CONTEXT_PROMPT = 'Read the following text, and answer the question at the end: \
\n\n${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()} \
\n\n${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}';
const GENERAL_QA_NO_CONTEXT_PROMPT = exports.GENERAL_QA_NO_CONTEXT_PROMPT = 'Answer the following question: \
${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}';
const GENERAL_TEXT_GENERATION_PROMPT = exports.GENERAL_TEXT_GENERATION_PROMPT = 'Please write a ${parameters.' + DEFAULT_PROMPT_TEXT_CATEGORY_FIELD + '.toString()} in the voice of ${parameters.' + DEFAULT_PROMPT_ROLE_FIELD + '.toString()}';
const CLAUDE_SUMMARIZE_PROMPT = exports.CLAUDE_SUMMARIZE_PROMPT = 'Human: read the following results inside the <text></text> XML tags:\n\n<text>\n\
${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + ".toString()}\n</text>\n\n\
Summarize the above results in one sentence. If you don't know the answer, just \
say I don't know.\
\n\nAssistant:";
const CLAUDE_QA_WITH_CONTEXT_PROMPT = exports.CLAUDE_QA_WITH_CONTEXT_PROMPT = 'Human: read the following results inside the <text></text> XML tags, and then answer the question:\
\n\n<text>\n\
${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()}\n\
</text>\n\n' + '${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}\n\nAssistant:';
const PROMPT_PRESETS = exports.PROMPT_PRESETS = [{
  name: 'Summarize text',
  prompt: GENERAL_SUMMARIZE_PROMPT
}, {
  name: 'Question-answer, with context',
  prompt: GENERAL_QA_WITH_CONTEXT_PROMPT
}, {
  name: 'Question-answer, without context',
  prompt: GENERAL_QA_NO_CONTEXT_PROMPT
}, {
  name: 'Text generation',
  prompt: GENERAL_TEXT_GENERATION_PROMPT
}, {
  name: 'Summarize text (Claude)',
  prompt: CLAUDE_SUMMARIZE_PROMPT
}, {
  name: 'Question-answer, with context (Claude)',
  prompt: CLAUDE_QA_WITH_CONTEXT_PROMPT
}];

/**
 * MISCELLANEOUS
 */
let PROCESSOR_CONTEXT = exports.PROCESSOR_CONTEXT = /*#__PURE__*/function (PROCESSOR_CONTEXT) {
  PROCESSOR_CONTEXT["INGEST"] = "ingest";
  PROCESSOR_CONTEXT["SEARCH_REQUEST"] = "search_request";
  PROCESSOR_CONTEXT["SEARCH_RESPONSE"] = "search_response";
  return PROCESSOR_CONTEXT;
}({});
const NO_TRANSFORMATION = exports.NO_TRANSFORMATION = 'No transformation';
let TRANSFORM_CONTEXT = exports.TRANSFORM_CONTEXT = /*#__PURE__*/function (TRANSFORM_CONTEXT) {
  TRANSFORM_CONTEXT["INPUT"] = "input";
  TRANSFORM_CONTEXT["OUTPUT"] = "output";
  return TRANSFORM_CONTEXT;
}({});
let TRANSFORM_TYPE = exports.TRANSFORM_TYPE = /*#__PURE__*/function (TRANSFORM_TYPE) {
  TRANSFORM_TYPE["STRING"] = "Custom string";
  TRANSFORM_TYPE["FIELD"] = "Data field";
  TRANSFORM_TYPE["EXPRESSION"] = "JSONPath expression";
  TRANSFORM_TYPE["TEMPLATE"] = "Prompt";
  return TRANSFORM_TYPE;
}({});
const INPUT_TRANSFORM_OPTIONS = exports.INPUT_TRANSFORM_OPTIONS = [{
  id: TRANSFORM_TYPE.FIELD,
  description: 'Use an existing field from your data as the model input field.'
}, {
  id: TRANSFORM_TYPE.EXPRESSION,
  description: 'Extract data from a JSON structure and map the extracted data to the model input field.'
}, {
  id: TRANSFORM_TYPE.TEMPLATE,
  description: 'Configure a prompt to map data to the model input field.'
}, {
  id: TRANSFORM_TYPE.STRING,
  description: 'Use a custom string in the model input field.'
}];
const OUTPUT_TRANSFORM_OPTIONS = exports.OUTPUT_TRANSFORM_OPTIONS = [{
  id: NO_TRANSFORMATION,
  description: ''
}, {
  id: TRANSFORM_TYPE.FIELD,
  description: 'Copy the model output into a new document field.'
}, {
  id: TRANSFORM_TYPE.EXPRESSION,
  description: 'Extract data from a JSON structure and map the extracted data to a new document field.'
}];
const DEFAULT_NEW_WORKFLOW_NAME = exports.DEFAULT_NEW_WORKFLOW_NAME = 'new_workflow';
const DEFAULT_NEW_WORKFLOW_DESCRIPTION = exports.DEFAULT_NEW_WORKFLOW_DESCRIPTION = 'My new workflow';
const DEFAULT_NEW_WORKFLOW_STATE_TYPE = exports.DEFAULT_NEW_WORKFLOW_STATE_TYPE = 'NOT_STARTED';
const DATE_FORMAT_PATTERN = exports.DATE_FORMAT_PATTERN = 'MM/DD/YY hh:mm A';
const EMPTY_FIELD_STRING = exports.EMPTY_FIELD_STRING = '--';
const OMIT_SYSTEM_INDEX_PATTERN = exports.OMIT_SYSTEM_INDEX_PATTERN = '*,-.*';
const INDEX_NOT_FOUND_EXCEPTION = exports.INDEX_NOT_FOUND_EXCEPTION = 'index_not_found_exception';
const ERROR_GETTING_WORKFLOW_MSG = exports.ERROR_GETTING_WORKFLOW_MSG = 'Failed to retrieve template';
const INVALID_DATASOURCE_MSG = exports.INVALID_DATASOURCE_MSG = 'No Living connections';
const NO_TEMPLATES_FOUND_MSG = exports.NO_TEMPLATES_FOUND_MSG = 'There are no templates';
const NO_MODIFICATIONS_FOUND_TEXT = exports.NO_MODIFICATIONS_FOUND_TEXT = 'Template does not contain any modifications';
const JSONPATH_ROOT_SELECTOR = exports.JSONPATH_ROOT_SELECTOR = '$';
const REQUEST_PREFIX = exports.REQUEST_PREFIX = '_request.';
const REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = exports.REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = '$._request.';
const WORKFLOW_NAME_RESTRICTIONS = exports.WORKFLOW_NAME_RESTRICTIONS = 'Invalid workflow name. Valid characters are a-z, A-Z, 0-9, -(hyphen), _(underscore).';
let SORT_ORDER = exports.SORT_ORDER = /*#__PURE__*/function (SORT_ORDER) {
  SORT_ORDER["ASC"] = "asc";
  SORT_ORDER["DESC"] = "desc";
  return SORT_ORDER;
}({});
const MAX_DOCS = exports.MAX_DOCS = 1000;
const MAX_DOCS_TO_IMPORT = exports.MAX_DOCS_TO_IMPORT = 100;
const MAX_STRING_LENGTH = exports.MAX_STRING_LENGTH = 100;
const MAX_DESCRIPTION_LENGTH = exports.MAX_DESCRIPTION_LENGTH = 1000;
const MAX_JSON_STRING_LENGTH = exports.MAX_JSON_STRING_LENGTH = 10000;
const MAX_TEMPLATE_STRING_LENGTH = exports.MAX_TEMPLATE_STRING_LENGTH = 10000;
const MAX_BYTES = exports.MAX_BYTES = 1048576; // OSD REST request payload size limit
const MAX_BYTES_FORMATTED = exports.MAX_BYTES_FORMATTED = '1,048,576';
const MAX_WORKFLOW_NAME_TO_DISPLAY = exports.MAX_WORKFLOW_NAME_TO_DISPLAY = 40;
const WORKFLOW_NAME_REGEXP = exports.WORKFLOW_NAME_REGEXP = RegExp('^[a-zA-Z0-9_-]*$');
const INDEX_NAME_REGEXP = exports.INDEX_NAME_REGEXP = WORKFLOW_NAME_REGEXP;
const PROVISION_TIMEOUT = exports.PROVISION_TIMEOUT = '10s'; // the timeout config for synchronous provisioning. https://github.com/opensearch-project/flow-framework/pull/990
const EMPTY_MAP_ENTRY = exports.EMPTY_MAP_ENTRY = {
  key: '',
  value: ''
};
const EMPTY_INPUT_MAP_ENTRY = exports.EMPTY_INPUT_MAP_ENTRY = {
  key: '',
  value: {
    transformType: TRANSFORM_TYPE.FIELD,
    value: ''
  }
};
const EMPTY_OUTPUT_MAP_ENTRY = exports.EMPTY_OUTPUT_MAP_ENTRY = {
  ...EMPTY_INPUT_MAP_ENTRY,
  value: {
    ...EMPTY_INPUT_MAP_ENTRY.value,
    transformType: NO_TRANSFORMATION
  }
};
const MODEL_OUTPUT_SCHEMA_NESTED_PATH = exports.MODEL_OUTPUT_SCHEMA_NESTED_PATH = 'output.properties.inference_results.items.properties.output.items.properties.dataAsMap.properties';
const MODEL_OUTPUT_SCHEMA_FULL_PATH = exports.MODEL_OUTPUT_SCHEMA_FULL_PATH = 'output.properties';
let CONFIG_STEP = exports.CONFIG_STEP = /*#__PURE__*/function (CONFIG_STEP) {
  CONFIG_STEP["INGEST"] = "Ingest pipeline";
  CONFIG_STEP["SEARCH"] = "Search pipeline";
  return CONFIG_STEP;
}({});
let SOURCE_OPTIONS = exports.SOURCE_OPTIONS = /*#__PURE__*/function (SOURCE_OPTIONS) {
  SOURCE_OPTIONS["MANUAL"] = "manual";
  SOURCE_OPTIONS["UPLOAD"] = "upload";
  SOURCE_OPTIONS["EXISTING_INDEX"] = "existing_index";
  return SOURCE_OPTIONS;
}({});
let INSPECTOR_TAB_ID = exports.INSPECTOR_TAB_ID = /*#__PURE__*/function (INSPECTOR_TAB_ID) {
  INSPECTOR_TAB_ID["TEST"] = "test";
  INSPECTOR_TAB_ID["INGEST"] = "ingest";
  INSPECTOR_TAB_ID["ERRORS"] = "errors";
  INSPECTOR_TAB_ID["RESOURCES"] = "resources";
  INSPECTOR_TAB_ID["PREVIEW"] = "preview";
  return INSPECTOR_TAB_ID;
}({});
const INSPECTOR_TABS = exports.INSPECTOR_TABS = [{
  id: INSPECTOR_TAB_ID.TEST,
  name: 'Test flow',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.INGEST,
  name: 'Ingest response',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.ERRORS,
  name: 'Errors',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.RESOURCES,
  name: 'Resources',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.PREVIEW,
  name: 'Preview',
  disabled: false
}];

// component IDs for each left nav component. Some may be tied
// to the lower-level form, others are for visual flow purposes only,
// like 'retrieveFromDataSource' and 'searchResults'
let COMPONENT_ID = exports.COMPONENT_ID = /*#__PURE__*/function (COMPONENT_ID) {
  COMPONENT_ID["SOURCE_DATA"] = "ingest.docs";
  COMPONENT_ID["ENRICH_DATA"] = "ingest.enrich";
  COMPONENT_ID["INGEST_DATA"] = "ingest.index";
  COMPONENT_ID["SEARCH_REQUEST"] = "search.request";
  COMPONENT_ID["ENRICH_SEARCH_REQUEST"] = "search.enrichRequest";
  COMPONENT_ID["RUN_QUERY"] = "runQuery";
  COMPONENT_ID["ENRICH_SEARCH_RESPONSE"] = "search.enrichResponse";
  COMPONENT_ID["SEARCH_RESULTS"] = "searchResults";
  return COMPONENT_ID;
}({}); // We have to persist a standalone string to override 'style' component, as setting className does
// not override the default styles from the EuiCard component.
const LEFT_NAV_SELECTED_STYLE = exports.LEFT_NAV_SELECTED_STYLE = '2px solid rgba(128, 128, 128, 0.8)';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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