"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _constants = require("../../utils/constants");
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    transformService
  } = services;
  router.get({
    path: _constants.NODE_API.TRANSFORMS,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, transformService.getTransforms);
  router.get({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, transformService.getTransform);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}/_stop`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, transformService.stopTransform);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}/_start`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, transformService.startTransform);
  router.delete({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, transformService.deleteTransform);
  router.put({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number()),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, transformService.putTransform);
  router.post({
    path: `${_constants.NODE_API._SEARCH_SAMPLE_DATA}/{index}`,
    validate: {
      params: _configSchema.schema.object({
        index: _configSchema.schema.string({
          validate: value => {
            const invalidCharactersPattern = /[\s,:\"+\/\\|?#><]/;
            if (value !== value.toLowerCase() || value.startsWith("_") || value.startsWith("-") || invalidCharactersPattern.test(value)) {
              return "Invalid index name.";
            }
            return undefined;
          }
        })
      }),
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string({
            maxLength: 100000
          })
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, transformService.searchSampleData);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/_preview`,
    validate: {
      body: _configSchema.schema.object({
        transform: _configSchema.schema.object({
          source_index: _configSchema.schema.string({
            validate: value => {
              const invalidCharactersPattern = /[\s,:\"+\/\\|?#><]/;
              if (value !== value.toLowerCase() || value.startsWith("_") || value.startsWith("-") || invalidCharactersPattern.test(value)) {
                return "Invalid index name.";
              }
              return undefined;
            }
          }),
          target_index: _configSchema.schema.string({
            validate: value => {
              const invalidCharactersPattern = /[\s,:\"*+\/\\|?#><]/;
              if (value !== value.toLowerCase() || value.startsWith("_") || value.startsWith("-") || invalidCharactersPattern.test(value)) {
                return "Invalid index name.";
              }
              return undefined;
            }
          })
        }, {
          unknowns: "allow"
        })
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string({
            maxLength: 100000
          })
        } : {})
      })
    }
  }, transformService.previewTransform);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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