"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("core-js/modules/es.regexp.flags.js");
require("core-js/modules/es.typed-array.set.js");
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class QueryService {
  constructor(_client, dataSourceEnabled, logger) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "describeQueryPostInternal", async (request, format, responseFormat, body, context) => {
      try {
        const params = {
          body: JSON.stringify(body)
        };
        let client = this.client;
        let queryResponse;
        const {
          dataSourceMDSId
        } = request.query;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format, params);
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryPostInternal');
        this.logger.info(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body,
            statusCode: err.statusCode || 400
          }
        };
      }
    });
    _defineProperty(this, "describeQueryJobIdInternal", async (request, format, jobId, responseFormat, context, dataSourceMDSId) => {
      try {
        let client = this.client;
        let queryResponse;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format, {
            jobId: jobId
          });
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, {
            jobId: jobId
          });
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info(err);
        this.logger.info(request.query);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body,
            statusCode: err.statusCode || 400
          }
        };
      }
    });
    _defineProperty(this, "describeQueryGetInternalSync", async (request, format, responseFormat, context) => {
      try {
        let client = this.client;
        let queryResponse;
        const dataSourceMDSId = request.params.dataSourceMDSId;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format);
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format);
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryGetInternalSync');
        this.logger.info(err);
        this.logger.info(request.query);
        console.log(err, request.query);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body,
            statusCode: err.statusCode || 400
          }
        };
      }
    });
    _defineProperty(this, "describeSQLQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlQuery', 'json', request.body, context);
    });
    _defineProperty(this, "describePPLQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplQuery', 'json', request.body, context);
    });
    _defineProperty(this, "describeSQLCsv", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlCsv', null, request.body, context);
    });
    _defineProperty(this, "describePPLCsv", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplCsv', null, request.body, context);
    });
    _defineProperty(this, "describeSQLText", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlText', null, request.body, context);
    });
    _defineProperty(this, "describePPLText", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplText', null, request.body, context);
    });
    _defineProperty(this, "describeSQLAsyncQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sparkSqlQuery', null, request.body, context);
    });
    _defineProperty(this, "describeSQLAsyncGetQuery", async (context, request, jobId, dataSourceMDSId) => {
      return this.describeQueryJobIdInternal(request, 'sql.sparkSqlGetQuery', jobId, null, context, dataSourceMDSId);
    });
    _defineProperty(this, "describeSyncQueryDataSources", async (context, request) => {
      return this.describeQueryGetInternalSync(request, 'sql.datasourcesGetQuery', null, context);
    });
    _defineProperty(this, "describeAsyncDeleteQuery", async (context, request, jobId, dataSourceMDSId) => {
      return this.describeQueryJobIdInternal(request, 'sql.asyncDeleteQuery', jobId, null, context, dataSourceMDSId);
    });
    this.client = _client;
    this.dataSourceEnabled = dataSourceEnabled;
    this.logger = logger;
  }
}
exports.default = QueryService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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