"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupLogTypeRoutes = setupLogTypeRoutes;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupLogTypeRoutes(services, router) {
  const {
    logTypeService
  } = services;
  router.post({
    path: _constants.API.LOGTYPE_BASE,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, logTypeService.createLogType);
  router.post({
    path: `${_constants.API.LOGTYPE_BASE}/_search`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, logTypeService.searchLogTypes);
  router.put({
    path: `${_constants.API.LOGTYPE_BASE}/{logTypeId}`,
    validate: {
      params: _configSchema.schema.object({
        logTypeId: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, logTypeService.updateLogType);
  router.delete({
    path: `${_constants.API.LOGTYPE_BASE}/{logTypeId}`,
    validate: {
      params: _configSchema.schema.object({
        logTypeId: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, logTypeService.deleteLogType);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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