"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class IndexService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getIndexFields", async (context, request, response) => {
      try {
        var _indexResponse$index;
        const {
          index
        } = request.body;
        const client = this.getClient(request, context);
        const indexResponse = await client('indices.getFieldMapping', {
          index,
          fields: ['*']
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: Object.keys(((_indexResponse$index = indexResponse[index]) === null || _indexResponse$index === void 0 ? void 0 : _indexResponse$index.mappings) || {})
          }
        });
      } catch (error) {
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getIndices", async (context, request, response) => {
      try {
        const client = this.getClient(request, context);
        const params = {
          format: 'json'
        };
        const getIndicesResponse = await client('cat.indices', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              indices: getIndicesResponse
            }
          }
        });
      } catch (error) {
        console.error('Security Analytics - IndexService - getIndices:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getAliases", async (context, request, response) => {
      try {
        const client = this.getClient(request, context);
        const aliases = await client('cat.aliases', {
          format: 'json',
          h: 'alias,index'
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              aliases
            }
          }
        });
      } catch (err) {
        console.error('Security Analytcis - IndexService - getAliases:', err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "updateAliases", async (context, request, response) => {
      try {
        const actions = request.body;
        const params = {
          body: actions
        };
        const client = this.getClient(request, context);
        await client('indices.updateAliases', params);
        return response.custom({
          statusCode: 200
        });
      } catch (error) {
        console.error('Security Analytics - IndexService - createAliases:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }
}
exports.default = IndexService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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