'''OpenGL extension NV.transform_feedback

This module customises the behaviour of the 
OpenGL.raw.GL.NV.transform_feedback to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a new mode to the GL, called transform feedback,
	which records vertex attributes of the primitives processed by the GL.
	The selected attributes are written into buffer objects, and can be
	written with each attribute in a separate buffer object or with all
	attributes interleaved into a single buffer object.  If a geometry program
	or shader is active, the primitives recorded are those emitted by the
	geometry program.  Otherwise, transform feedback captures primitives whose
	vertex are transformed by a vertex program or shader, or by fixed-function
	vertex processing.  In either case, the primitives captured are those
	generated prior to clipping.  Transform feedback mode is capable of
	capturing transformed vertex data generated by fixed-function vertex
	processing, outputs from assembly vertex or geometry programs, or varying
	variables emitted from GLSL vertex or geometry shaders.
	
	The vertex data recorded in transform feedback mode is stored into buffer
	objects as an array of vertex attributes.  The regular representation and
	the use of buffer objects allows the recorded data to be processed
	directly by the GL without requiring CPU intervention to copy data.  In
	particular, transform feedback data can be used for vertex arrays (via
	vertex buffer objects), as the source for pixel data (via pixel buffer
	objects), as program constant data (via the NV_parameter_buffer_object or
	EXT_bindable_uniform extension), or via any other extension that makes use
	of buffer objects.
	
	This extension introduces new query object support to allow transform
	feedback mode to operate asynchronously.  Query objects allow applications
	to determine when transform feedback results are complete, as well as the
	number of primitives processed and written back to buffer objects while in
	transform feedback mode.  This extension also provides a new rasterizer
	discard enable, which allows applications to use transform feedback to
	capture vertex attributes without rendering anything.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/transform_feedback.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.transform_feedback import *
from OpenGL.raw.GL.NV.transform_feedback import _EXTENSION_NAME

def glInitTransformFeedbackNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glTransformFeedbackAttribsNV.attribs size not checked against 'count'
glTransformFeedbackAttribsNV=wrapper.wrapper(glTransformFeedbackAttribsNV).setInputArraySize(
    'attribs', None
)
# INPUT glTransformFeedbackVaryingsNV.locations size not checked against count
glTransformFeedbackVaryingsNV=wrapper.wrapper(glTransformFeedbackVaryingsNV).setInputArraySize(
    'locations', None
)
# INPUT glActiveVaryingNV.name size not checked against 'name'
glActiveVaryingNV=wrapper.wrapper(glActiveVaryingNV).setInputArraySize(
    'name', None
)
# INPUT glGetVaryingLocationNV.name size not checked against 'name'
glGetVaryingLocationNV=wrapper.wrapper(glGetVaryingLocationNV).setInputArraySize(
    'name', None
)
glGetActiveVaryingNV=wrapper.wrapper(glGetActiveVaryingNV).setOutput(
    'length',size=(1,),orPassIn=True
).setOutput(
    'name',size=lambda x:(x,),pnameArg='bufSize',orPassIn=True
).setOutput(
    'size',size=(1,),orPassIn=True
).setOutput(
    'type',size=(1,),orPassIn=True
)
glGetTransformFeedbackVaryingNV=wrapper.wrapper(glGetTransformFeedbackVaryingNV).setOutput(
    'location',size=(1,),orPassIn=True
)
# INPUT glTransformFeedbackStreamAttribsNV.attribs size not checked against count
# INPUT glTransformFeedbackStreamAttribsNV.bufstreams size not checked against nbuffers
glTransformFeedbackStreamAttribsNV=wrapper.wrapper(glTransformFeedbackStreamAttribsNV).setInputArraySize(
    'attribs', None
).setInputArraySize(
    'bufstreams', None
)
### END AUTOGENERATED SECTION