/* Copyright (c) 2016, Google Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. */

#include <stdio.h>
#include <string.h>

#include <gtest/gtest.h>

#include <openssl/rand.h>

#include "abi_test.h"
#include "gtest_main.h"
#include "../internal.h"
#include "../ube/vm_ube_detect.h"


int main(int argc, char **argv) {
#if defined(OPENSSL_LINUX) && defined(AWSLC_VM_UBE_TESTING)
  if (1 != HAZMAT_init_sysgenid_file()) {
    abort();
  }
#endif

  testing::InitGoogleTest(&argc, argv);
  bssl::SetupGoogleTest();
  bool unwind_tests = true;
  for (int i = 1; i < argc; i++) {
    if (strcmp(argv[i], "--no_unwind_tests") == 0) {
      unwind_tests = false;
    }
  }

  if (unwind_tests) {
    abi_test::EnableUnwindTests();
  }

  return RUN_ALL_TESTS();
}
