/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class UlbotechFrameDecoder
extends BaseFrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 2) {
            return null;
        }
        if (buf.getUnsignedByte(buf.readerIndex()) == 248) {
            int index = buf.indexOf(buf.readerIndex() + 1, buf.writerIndex(), (byte)-8);
            if (index != -1) {
                ByteBuf result = Unpooled.buffer((int)(index + 1 - buf.readerIndex()));
                while (buf.readerIndex() <= index) {
                    short b = buf.readUnsignedByte();
                    if (b == 247) {
                        short ext = buf.readUnsignedByte();
                        if (ext == 0) {
                            result.writeByte(247);
                            continue;
                        }
                        if (ext != 15) continue;
                        result.writeByte(248);
                        continue;
                    }
                    result.writeByte((int)b);
                }
                return result;
            }
        } else {
            int index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)35);
            if (index != -1) {
                return buf.readRetainedSlice(index + 1 - buf.readerIndex());
            }
        }
        return null;
    }
}

