/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.access;

import java.io.IOException;
import java.util.Map;
import net.i2p.data.Base32;
import net.i2p.data.Hash;
import net.i2p.i2ptunnel.access.DestTracker;
import net.i2p.i2ptunnel.access.InvalidDefinitionException;
import net.i2p.i2ptunnel.access.Threshold;

abstract class FilterDefinitionElement {
    protected final Threshold threshold;

    FilterDefinitionElement(Threshold threshold) {
        this.threshold = threshold;
    }

    abstract void update(Map<Hash, DestTracker> var1) throws IOException;

    Threshold getThreshold() {
        return this.threshold;
    }

    protected static Hash fromBase32(String b32) throws InvalidDefinitionException {
        if (b32.length() != 60) {
            throw new InvalidDefinitionException("Invalid b32 " + b32);
        }
        if (!b32.endsWith(".b32.i2p")) {
            throw new InvalidDefinitionException("Invalid b32 " + b32);
        }
        String s = b32.substring(0, 52);
        byte[] b = Base32.decode(s);
        if (b == null) {
            throw new InvalidDefinitionException("Invalid b32 " + b32);
        }
        return Hash.create(b);
    }
}

