/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.vue.editor.lexer;

import java.util.Collection;
import java.util.EnumSet;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;

public enum VueTokenId implements TokenId
{
    HTML("html"),
    CSS("css"),
    STYLE_SCSS("css"),
    STYLE_LESS("css"),
    JAVASCRIPT_ATTR("javascript"),
    JAVASCRIPT("javascript"),
    JAVASCRIPT_PUG("javascript"),
    JAVASCRIPT_INTERP("javascript"),
    QUOTE_ATTR("attr_quote"),
    VUE_DIRECTIVE("vue_directive"),
    VAR_TAG("var_tag");

    private final String primaryCategory;

    private VueTokenId(String category) {
        this.primaryCategory = category;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static abstract class VueLanguageHierarchy
    extends LanguageHierarchy<VueTokenId> {
        static Language<?> JADE_LANGUAGE = Language.find((String)"text/jade");
        static Language<?> LESS_LANGUAGE = Language.find((String)"text/less");
        static Language<?> SCSS_LANGUAGE = Language.find((String)"text/scss");

        protected Collection<VueTokenId> createTokenIds() {
            return EnumSet.allOf(VueTokenId.class);
        }

        protected LanguageEmbedding<? extends TokenId> embedding(Token<VueTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
            return switch ((VueTokenId)token.id()) {
                case JAVASCRIPT_INTERP -> LanguageEmbedding.create((Language)JsTokenId.javascriptLanguage(), (int)0, (int)0, (boolean)false);
                case JAVASCRIPT, JAVASCRIPT_ATTR -> LanguageEmbedding.create((Language)JsTokenId.javascriptLanguage(), (int)0, (int)0, (boolean)false);
                case JAVASCRIPT_PUG -> LanguageEmbedding.create(JADE_LANGUAGE, (int)0, (int)0, (boolean)true);
                case HTML -> LanguageEmbedding.create((Language)HTMLTokenId.language(), (int)0, (int)0, (boolean)true);
                case CSS -> LanguageEmbedding.create((Language)CssTokenId.language(), (int)0, (int)0, (boolean)true);
                case STYLE_LESS -> LanguageEmbedding.create(LESS_LANGUAGE, (int)0, (int)0, (boolean)true);
                case STYLE_SCSS -> LanguageEmbedding.create(SCSS_LANGUAGE, (int)0, (int)0, (boolean)true);
                default -> null;
            };
        }
    }
}

