/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.build2;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.FutureTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerImage;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerSupport;
import org.netbeans.modules.docker.ui.build2.BuildContextPanel;
import org.netbeans.modules.docker.ui.build2.BuildInstancePanel;
import org.netbeans.modules.docker.ui.build2.BuildOptionsPanel;
import org.netbeans.modules.docker.ui.build2.BuildTask;
import org.netbeans.modules.docker.ui.build2.Bundle;
import org.netbeans.modules.docker.ui.build2.InputOutputCache;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class BuildImageWizard {
    public static final String INSTANCE_PROPERTY = "instance";
    public static final String BUILD_CONTEXT_PROPERTY = "buildContext";
    public static final String REPOSITORY_PROPERTY = "repository";
    public static final String TAG_PROPERTY = "tag";
    public static final String DOCKERFILE_PROPERTY = "dockerfile";
    public static final String FILESYSTEM_PROPERTY = "filesystem";
    public static final String PULL_PROPERTY = "pull";
    public static final String NO_CACHE_PROPERTY = "noCache";
    public static final String BUILD_ARGUMENTS_PROPERTY = "buildArguments";
    public static final boolean PULL_DEFAULT = false;
    public static final boolean NO_CACHE_DEFAULT = false;
    private final RequestProcessor requestProcessor = new RequestProcessor(BuildImageWizard.class);
    private DockerInstance instance;
    private FileObject dockerfile;
    private FileSystem fileSystem;

    public DockerInstance getInstance() {
        return this.instance;
    }

    public void setInstance(DockerInstance instance) {
        try {
            this.instance = instance;
            File tmpFile = File.createTempFile("test", "test");
            this.fileSystem = FileUtil.toFileObject((File)tmpFile).getFileSystem();
            tmpFile.delete();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public FileObject getDockerfile() {
        return this.dockerfile;
    }

    public void setDockerfile(FileObject dockerfile) {
        this.dockerfile = dockerfile;
        try {
            this.fileSystem = dockerfile.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void show() {
        ArrayList<WizardDescriptor.Panel<WizardDescriptor>> panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        if (this.instance == null) {
            panels.add(new BuildInstancePanel());
        }
        panels.add(new BuildContextPanel(this.fileSystem));
        panels.add(new BuildOptionsPanel());
        String[] steps = new String[panels.size()];
        for (int i = 0; i < panels.size(); ++i) {
            JComponent c = (JComponent)((WizardDescriptor.Panel)panels.get(i)).getComponent();
            steps[i] = c.getName();
            c.putClientProperty("WizardPanel_contentSelectedIndex", i);
            c.putClientProperty("WizardPanel_contentData", steps);
            c.putClientProperty("WizardPanel_autoWizardStyle", true);
            c.putClientProperty("WizardPanel_contentDisplayed", true);
            c.putClientProperty("WizardPanel_contentNumbered", true);
        }
        WizardDescriptor wiz = new WizardDescriptor((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(panels));
        wiz.setTitleFormat(new MessageFormat("{0}"));
        wiz.setTitle(Bundle.LBL_BuildImage());
        if (this.instance != null) {
            wiz.putProperty(INSTANCE_PROPERTY, (Object)this.instance);
        }
        if (this.dockerfile != null && this.dockerfile.isData()) {
            wiz.putProperty(BUILD_CONTEXT_PROPERTY, (Object)this.dockerfile.getParent().getPath());
            wiz.putProperty(DOCKERFILE_PROPERTY, (Object)this.dockerfile.getName());
        }
        wiz.putProperty(FILESYSTEM_PROPERTY, (Object)this.fileSystem);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)wiz) == WizardDescriptor.FINISH_OPTION) {
            Boolean pull = (Boolean)wiz.getProperty(PULL_PROPERTY);
            Boolean noCache = (Boolean)wiz.getProperty(NO_CACHE_PROPERTY);
            this.build((DockerInstance)wiz.getProperty(INSTANCE_PROPERTY), (String)wiz.getProperty(BUILD_CONTEXT_PROPERTY), (String)wiz.getProperty(DOCKERFILE_PROPERTY), (Map)wiz.getProperty(BUILD_ARGUMENTS_PROPERTY), (String)wiz.getProperty(REPOSITORY_PROPERTY), (String)wiz.getProperty(TAG_PROPERTY), pull != null ? pull : false, noCache != null ? noCache : false);
        }
    }

    static boolean isFinishable(FileSystem fs, String buildContext, String dockerfile) {
        if (buildContext == null) {
            return false;
        }
        String realDockerfile = dockerfile == null ? buildContext + "/" + "Dockerfile" : buildContext + "/" + dockerfile;
        FileObject build = fs.getRoot().getFileObject(buildContext);
        FileObject fo = fs.getRoot().getFileObject(realDockerfile);
        if (fo == null || !fo.isData() || !realDockerfile.endsWith(fo.getNameExt())) {
            return false;
        }
        if (build == null) {
            return false;
        }
        return FileUtil.isParentOf((FileObject)build, (FileObject)fo);
    }

    private void build(final DockerInstance instance, final String buildContext, final String dockerfile, final Map<String, String> buildargs, final String repository, final String tag, final boolean pull, final boolean noCache) {
        assert (SwingUtilities.isEventDispatchThread());
        RerunAction r = new RerunAction(this.requestProcessor);
        StopAction s = new StopAction();
        ArrayList<Action> actions = new ArrayList<Action>(2);
        Collections.addAll(actions, r, s);
        final InputOutputCache.CachedInputOutput ioData = InputOutputCache.get(Bundle.MSG_Building(buildContext), actions);
        r = (RerunAction)ioData.getActions().get(0);
        s = (StopAction)ioData.getActions().get(1);
        final InputOutput io = ioData.getInputOutput();
        final RerunAction rerun = r;
        final StopAction stop = s;
        stop.setEnabled(false);
        rerun.setEnabled(false);
        this.requestProcessor.post(new Runnable(){

            @Override
            public void run() {
                String file = dockerfile != null ? buildContext + "/" + dockerfile : buildContext + "/" + "Dockerfile";
                BuildTask.Hook hook = new BuildTask.Hook(){

                    @Override
                    public void onStart(FutureTask<DockerImage> task) {
                        stop.configure(task);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                stop.setEnabled(true);
                            }
                        });
                    }

                    @Override
                    public void onFinish() {
                        InputOutputCache.release(ioData);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                stop.setEnabled(false);
                                if (rerun.isAvailable()) {
                                    rerun.setEnabled(true);
                                }
                            }
                        });
                    }
                };
                BuildTask task = new BuildTask(instance, io, hook, BuildImageWizard.this.fileSystem.getRoot().getFileObject(buildContext), BuildImageWizard.this.fileSystem.getRoot().getFileObject(file), buildargs, repository, tag, pull, noCache);
                rerun.configure(task);
                task.run();
            }
        });
    }

    private static class RerunAction
    extends AbstractAction {
        private final RequestProcessor requestProcessor;
        private BuildTask buildTask;
        private ActionStateListener listener;
        private boolean available = true;

        public RerunAction(RequestProcessor requestProcessor) {
            this.requestProcessor = requestProcessor;
            this.setEnabled(false);
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/docker/ui/resources/action_rerun.png", (boolean)false));
            this.putValue("ShortDescription", Bundle.LBL_Rerun());
        }

        public synchronized boolean isAvailable() {
            return this.available;
        }

        public synchronized void configure(BuildTask buildTask) {
            this.detach();
            this.buildTask = buildTask;
            this.available = true;
            this.attach(buildTask);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InputOutputCache.CachedInputOutput ioData;
            this.setEnabled(false);
            InputOutput io = (InputOutput)this.buildTask.getInputOutput().get();
            if (io != null && (ioData = InputOutputCache.get(io)) != null) {
                this.requestProcessor.post((Runnable)this.buildTask);
            }
        }

        public synchronized void attach(BuildTask buildTask) {
            FileObject fo = buildTask.getDockerfile();
            this.buildTask = buildTask;
            this.listener = new ActionStateListener(this, buildTask.getInstance(), fo);
            fo.addFileChangeListener((FileChangeListener)this.listener);
            DockerSupport.getDefault().addChangeListener((ChangeListener)this.listener);
            this.listener.refresh();
        }

        public synchronized void detach() {
            if (this.buildTask == null) {
                return;
            }
            FileObject fo = this.listener.getFileObject();
            fo.removeFileChangeListener((FileChangeListener)this.listener);
            DockerSupport.getDefault().removeChangeListener((ChangeListener)this.listener);
            this.buildTask = null;
            this.listener = null;
            this.available = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.setEnabled(false);
                }
            });
        }
    }

    private static class StopAction
    extends AbstractAction {
        private FutureTask<DockerImage> task;

        public StopAction() {
            this.setEnabled(false);
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/docker/ui/resources/action_stop.png", (boolean)false));
            this.putValue("ShortDescription", Bundle.LBL_Stop());
        }

        public synchronized void configure(FutureTask<DockerImage> task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            FutureTask<DockerImage> actionTask;
            this.setEnabled(false);
            StopAction stopAction = this;
            synchronized (stopAction) {
                actionTask = this.task;
            }
            if (actionTask != null) {
                actionTask.cancel(true);
            }
        }
    }

    private static class ActionStateListener
    implements ChangeListener,
    FileChangeListener {
        private final RerunAction action;
        private final WeakReference<DockerInstance> instance;
        private final FileObject fo;

        public ActionStateListener(RerunAction action, WeakReference<DockerInstance> instance, FileObject fo) {
            this.action = action;
            this.instance = instance;
            this.fo = fo;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh();
        }

        public void fileDeleted(FileEvent fe) {
            this.refresh();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.refresh();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        private void refresh() {
            if (this.fo == null || !this.fo.isValid()) {
                this.action.detach();
            }
            DockerInstance inst = (DockerInstance)this.instance.get();
            DockerSupport integration = DockerSupport.getDefault();
            if (inst == null || !integration.getInstances().contains(inst)) {
                this.action.detach();
            }
        }
    }
}

