/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.conditionapi;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.declarative.APIAccessor;
import org.netbeans.modules.java.hints.declarative.conditionapi.Variable;
import org.netbeans.modules.java.hints.spiimpl.Hacks;
import org.netbeans.spi.java.hints.HintContext;

public class Context {
    final HintContext ctx;
    final Deque<Map<String, TreePath>> variables = new LinkedList<Map<String, TreePath>>();
    final Deque<Map<String, Collection<? extends TreePath>>> multiVariables = new LinkedList<Map<String, Collection<? extends TreePath>>>();
    final Deque<Map<String, String>> variableNames = new LinkedList<Map<String, String>>();
    private final AtomicInteger auxiliaryVariableCounter = new AtomicInteger();

    public Context(HintContext ctx) {
        this.ctx = ctx;
        this.variables.add(Collections.unmodifiableMap(ctx.getVariables()));
        this.multiVariables.add(Collections.unmodifiableMap(ctx.getMultiVariables()));
        this.variableNames.add(Collections.unmodifiableMap(ctx.getVariableNames()));
    }

    @NonNull
    public SourceVersion sourceVersion() {
        return this.ctx.getInfo().getSourceVersion();
    }

    @NonNull
    public Set<Modifier> modifiers(@NonNull Variable variable) {
        Element e = this.ctx.getInfo().getTrees().getElement(this.getSingleVariable(variable));
        if (e == null) {
            return Collections.unmodifiableSet(EnumSet.noneOf(Modifier.class));
        }
        return Collections.unmodifiableSet(e.getModifiers());
    }

    @CheckForNull
    public ElementKind elementKind(@NonNull Variable variable) {
        Element e = this.ctx.getInfo().getTrees().getElement(this.getSingleVariable(variable));
        if (e == null) {
            return null;
        }
        return e.getKind();
    }

    @CheckForNull
    public TypeKind typeKind(@NonNull Variable variable) {
        TypeMirror tm = this.ctx.getInfo().getTrees().getTypeMirror(this.getSingleVariable(variable));
        if (tm == null) {
            return null;
        }
        return tm.getKind();
    }

    @CheckForNull
    public String name(@NonNull Variable variable) {
        Element e = this.ctx.getInfo().getTrees().getElement(this.getSingleVariable(variable));
        if (e == null) {
            return null;
        }
        return e.getSimpleName().toString();
    }

    @CheckForNull
    public Variable parent(@NonNull Variable variable) {
        TreePath tp = this.getSingleVariable(variable);
        if (tp.getParentPath() == null) {
            return null;
        }
        return this.enterAuxiliaryVariable(tp.getParentPath());
    }

    private Variable enterAuxiliaryVariable(TreePath path) {
        String output = "*" + this.auxiliaryVariableCounter.getAndIncrement();
        this.variables.getFirst().put(output, path);
        return new Variable(output);
    }

    @NonNull
    public Variable variableForName(@NonNull String variableName) {
        Variable result = new Variable(variableName);
        if (this.getSingleVariable(result) == null) {
            throw new IllegalStateException("Unknown variable");
        }
        return result;
    }

    public void createRenamed(@NonNull Variable from, @NonNull Variable to, @NonNull String newName) {
        this.variableNames.getFirst().put(to.variableName, newName);
        TreePath origVariablePath = this.getSingleVariable(from);
        TreePath newVariablePath = new TreePath(origVariablePath.getParentPath(), Hacks.createRenameTree((Tree)origVariablePath.getLeaf(), (String)newName));
        this.variables.getFirst().put(to.variableName, newVariablePath);
    }

    public boolean isNullLiteral(@NonNull Variable var) {
        TreePath varPath = this.getSingleVariable(var);
        return varPath.getLeaf().getKind() == Tree.Kind.NULL_LITERAL;
    }

    @NonNull
    public Iterable<? extends Variable> getIndexedVariables(@NonNull Variable multiVariable) {
        Collection<? extends TreePath> paths = this.getMultiVariable(multiVariable);
        if (paths == null) {
            throw new IllegalArgumentException("TODO: explanation");
        }
        ArrayDeque<Variable> result = new ArrayDeque<Variable>();
        int index = 0;
        for (TreePath treePath : paths) {
            result.add(new Variable(multiVariable.variableName, index++));
        }
        return result;
    }

    public void enterScope() {
        this.variables.addFirst(new HashMap());
        this.multiVariables.addFirst(new HashMap());
        this.variableNames.addFirst(new HashMap());
    }

    public void leaveScope() {
        this.variables.removeFirst();
        this.multiVariables.removeFirst();
        this.variableNames.removeFirst();
    }

    Iterable<? extends TreePath> getVariable(Variable v) {
        if (Context.isMultistatementWildcard(v.variableName) && v.index == -1) {
            return this.getMultiVariable(v);
        }
        return Collections.singletonList(this.getSingleVariable(v));
    }

    private static boolean isMultistatementWildcard(CharSequence name) {
        return name.charAt(name.length() - 1) == '$';
    }

    TreePath getSingleVariable(Variable v) {
        if (v.index == -1) {
            for (Map<String, TreePath> map : this.variables) {
                TreePath var = map.get(v.variableName);
                if (var == null) continue;
                return var;
            }
            return null;
        }
        return new ArrayList<TreePath>(this.getMultiVariable(v)).get(v.index);
    }

    private Collection<? extends TreePath> getMultiVariable(Variable v) {
        for (Map<String, Collection<? extends TreePath>> multi : this.multiVariables) {
            Collection<? extends TreePath> vars = multi.get(v.variableName);
            if (vars == null) continue;
            return vars;
        }
        return null;
    }

    @NonNull
    public Iterable<? extends String> enclosingClasses(Variable forVariable) {
        ArrayList<String> result = new ArrayList<String>();
        for (TreePath path = this.getSingleVariable(forVariable); path != null; path = path.getParentPath()) {
            Element e;
            TreePath current = path;
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)current.getLeaf().getKind()) || (e = this.ctx.getInfo().getTrees().getElement(current)) == null || !e.getKind().isClass() && !e.getKind().isInterface()) continue;
            result.add(((TypeElement)e).getQualifiedName().toString());
        }
        return result;
    }

    @NonNull
    public String enclosingPackage() {
        return Objects.toString(this.ctx.getInfo().getCompilationUnit().getPackageName(), "");
    }

    public boolean isAvailable(@NonNull String description) {
        return this.ctx.getInfo().getElementUtilities().findElement(description) != null;
    }

    static {
        APIAccessor.IMPL = new APIAccessorImpl();
    }

    static final class APIAccessorImpl
    extends APIAccessor {
        APIAccessorImpl() {
        }

        @Override
        public TreePath getSingleVariable(Context ctx, Variable var) {
            return ctx.getSingleVariable(var);
        }

        @Override
        public HintContext getHintContext(Context ctx) {
            return ctx.ctx;
        }

        @Override
        public Map<String, TreePath> getVariables(Context ctx) {
            HashMap<String, TreePath> result = new HashMap<String, TreePath>();
            Iterator<Map<String, TreePath>> iter = ctx.variables.descendingIterator();
            while (iter.hasNext()) {
                result.putAll(iter.next());
            }
            return result;
        }

        @Override
        public Map<String, Collection<? extends TreePath>> getMultiVariables(Context ctx) {
            HashMap<String, Collection<? extends TreePath>> result = new HashMap<String, Collection<? extends TreePath>>();
            Iterator<Map<String, Collection<? extends TreePath>>> iter = ctx.multiVariables.descendingIterator();
            while (iter.hasNext()) {
                result.putAll(iter.next());
            }
            return result;
        }

        @Override
        public Map<String, String> getVariableNames(Context ctx) {
            HashMap<String, String> result = new HashMap<String, String>();
            Iterator<Map<String, String>> iter = ctx.variableNames.descendingIterator();
            while (iter.hasNext()) {
                result.putAll(iter.next());
            }
            return result;
        }

        @Override
        public Variable enterAuxiliaryVariable(Context ctx, TreePath source) {
            return ctx.enterAuxiliaryVariable(source);
        }
    }
}

