/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.lib;

import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class Util {
    public static final Util THIS = new Util();
    private static File lastDirectory;

    private Util() {
    }

    public static Customizer getProviderCustomizer(Class clazz) {
        try {
            Class<?> customizer = Introspector.getBeanInfo(clazz).getBeanDescriptor().getCustomizerClass();
            return (Customizer)customizer.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IntrospectionException | ReflectiveOperationException ex) {
            return null;
        }
    }

    public static Object createProvider(Class clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            return null;
        }
    }

    public static File selectCatalogFile(String extensions) {
        return Util.selectFile(extensions, NbBundle.getMessage(Util.class, (String)"TITLE_select_catalog"), NbBundle.getMessage(Util.class, (String)"PROP_catalog_mask"));
    }

    public static File selectFile(final String extensions, String dialogTitle, final String maskTitle) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                StringTokenizer token = new StringTokenizer(extensions, " ");
                while (token.hasMoreElements()) {
                    if (!f.getName().endsWith(token.nextToken())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return maskTitle;
            }
        });
        if (lastDirectory != null) {
            chooser.setCurrentDirectory(lastDirectory);
        }
        chooser.setDialogTitle(dialogTitle);
        while (chooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(Util.class, (String)"PROP_select_button")) == 0) {
            File f = chooser.getSelectedFile();
            lastDirectory = chooser.getCurrentDirectory();
            if (f != null && f.isFile()) {
                StringTokenizer token = new StringTokenizer(extensions, " ");
                while (token.hasMoreElements()) {
                    if (!f.getName().endsWith(token.nextToken())) continue;
                    return f;
                }
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(Util.class, (String)"MSG_inValidFile"), 2));
        }
        return null;
    }
}

