/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.ColorsASTEvaluator;
import org.netbeans.modules.languages.features.ContextASTEvaluator;
import org.netbeans.modules.languages.features.DeclarationASTEvaluator;
import org.netbeans.modules.languages.features.UsagesASTEvaluator;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;

class SemanticHighlightsLayer
extends AbstractHighlightsContainer {
    private static Map<Document, List<WeakReference<SemanticHighlightsLayer>>> cache = new WeakHashMap<Document, List<WeakReference<SemanticHighlightsLayer>>>();
    private Document document;
    private OffsetsBag offsetsBag;
    private OffsetsBag offsetsBag1;
    private Map<String, Set<ASTEvaluator>> evaluators;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void addHighlight(Document document, int startOffset, int endOffset, AttributeSet attributeSet) {
        List<WeakReference<SemanticHighlightsLayer>> layers = cache.get(document);
        ArrayList<WeakReference<SemanticHighlightsLayer>> newLayers = new ArrayList<WeakReference<SemanticHighlightsLayer>>();
        boolean remove = true;
        if (layers != null) {
            for (WeakReference<SemanticHighlightsLayer> weakReference : layers) {
                SemanticHighlightsLayer layer = (SemanticHighlightsLayer)((Object)weakReference.get());
                if (layer == null) continue;
                remove = false;
                SemanticHighlightsLayer semanticHighlightsLayer = layer;
                synchronized (semanticHighlightsLayer) {
                    if (layer.offsetsBag1 == null) {
                        layer.offsetsBag1 = new OffsetsBag(document);
                    }
                    layer.offsetsBag1.addHighlight(startOffset, endOffset, attributeSet);
                }
                newLayers.add(weakReference);
            }
        }
        if (remove) {
            cache.remove(document);
            ColorsASTEvaluator.unregister(document);
            DeclarationASTEvaluator.unregister(document);
            ContextASTEvaluator.unregister(document);
            UsagesASTEvaluator.unregister(document);
        } else {
            cache.put(document, newLayers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void update(Document document) {
        List<WeakReference<SemanticHighlightsLayer>> layers = cache.get(document);
        boolean remove = true;
        if (layers != null) {
            for (WeakReference<SemanticHighlightsLayer> weakReference : layers) {
                SemanticHighlightsLayer layer = (SemanticHighlightsLayer)((Object)weakReference.get());
                if (layer == null) continue;
                remove = false;
                SemanticHighlightsLayer semanticHighlightsLayer = layer;
                synchronized (semanticHighlightsLayer) {
                    layer.offsetsBag = layer.offsetsBag1;
                    layer.offsetsBag1 = null;
                    if (layer.offsetsBag == null) {
                        layer.offsetsBag = new OffsetsBag(document);
                    }
                }
                layer.fireHighlightsChange(0, document.getLength());
            }
        }
        if (remove) {
            cache.remove(document);
            ColorsASTEvaluator.unregister(document);
            DeclarationASTEvaluator.unregister(document);
            ContextASTEvaluator.unregister(document);
            UsagesASTEvaluator.unregister(document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SemanticHighlightsLayer(Document document) {
        this.document = document;
        ColorsASTEvaluator.register(document);
        DeclarationASTEvaluator.register(document);
        ContextASTEvaluator.register(document);
        UsagesASTEvaluator.register(document);
        Class<SemanticHighlightsLayer> clazz = SemanticHighlightsLayer.class;
        synchronized (SemanticHighlightsLayer.class) {
            List<WeakReference<SemanticHighlightsLayer>> layers = cache.get(document);
            if (layers == null) {
                layers = new ArrayList<WeakReference<SemanticHighlightsLayer>>();
                cache.put(document, layers);
            }
            layers.add(new WeakReference<SemanticHighlightsLayer>(this));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized HighlightsSequence getHighlights(int startOffset, int endOffset) {
        if (this.offsetsBag == null) {
            this.offsetsBag = new OffsetsBag(this.document);
            this.refresh();
        }
        return this.offsetsBag.getHighlights(startOffset, endOffset);
    }

    private void refresh() {
        ParserManagerImpl parserManager = ParserManagerImpl.getImpl(this.document);
        ASTNode root = parserManager.getAST();
        if (root == null) {
            return;
        }
        parserManager.fire(parserManager.getState(), null, this.getEvaluators(), root);
    }

    private Map<String, Set<ASTEvaluator>> getEvaluators() {
        if (this.evaluators == null) {
            ContextASTEvaluator contextASTEvaluator;
            DeclarationASTEvaluator declarationASTEvaluator;
            UsagesASTEvaluator usagesASTEvaluator;
            this.evaluators = new HashMap<String, Set<ASTEvaluator>>();
            ColorsASTEvaluator colorsASTEvaluator = ColorsASTEvaluator.get(this.document);
            if (colorsASTEvaluator != null) {
                this.evaluators.put(colorsASTEvaluator.getFeatureName(), Collections.singleton(colorsASTEvaluator));
            }
            if ((usagesASTEvaluator = UsagesASTEvaluator.get(this.document)) != null) {
                this.evaluators.put(usagesASTEvaluator.getFeatureName(), Collections.singleton(usagesASTEvaluator));
            }
            if ((declarationASTEvaluator = DeclarationASTEvaluator.get(this.document)) != null) {
                this.evaluators.put(declarationASTEvaluator.getFeatureName(), Collections.singleton(declarationASTEvaluator));
            }
            if ((contextASTEvaluator = ContextASTEvaluator.get(this.document)) != null) {
                this.evaluators.put(contextASTEvaluator.getFeatureName(), Collections.singleton(contextASTEvaluator));
            }
        }
        return this.evaluators;
    }
}

