/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.android;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.modules.cordova.platforms.android.AVD;
import org.netbeans.modules.cordova.platforms.android.AndroidDevice;
import org.netbeans.modules.cordova.platforms.android.Target;
import org.netbeans.modules.cordova.platforms.api.PlatformManager;
import org.netbeans.modules.cordova.platforms.api.ProcessUtilities;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.cordova.platforms.spi.MobilePlatform;
import org.netbeans.modules.cordova.platforms.spi.ProvisioningProfile;
import org.netbeans.modules.cordova.platforms.spi.SDK;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class AndroidPlatform
implements MobilePlatform {
    private static String ANDROID_SDK_ROOT_PREF = "android.sdk.home";
    public static int DEFAULT_TIMEOUT = 30000;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final HashSet<String> targets = new HashSet<String>(Arrays.asList("android-14", "android-15", "android-16", "android-17", "android-18", "android-19", "android-20", "android-21", "android-22"));

    public static AndroidPlatform getDefault() {
        return (AndroidPlatform)PlatformManager.getPlatform((String)"android");
    }

    public Collection<Device> getVirtualDevices() throws IOException {
        assert (!SwingUtilities.isEventDispatchThread());
        String avdString = ProcessUtilities.callProcess((String)this.getAndroidCommand(), (boolean)true, (int)DEFAULT_TIMEOUT, (String[])new String[]{"list", "avd"});
        return AVD.parse(avdString);
    }

    private String getAndroidCommand() {
        if (Utilities.isWindows()) {
            return this.getSdkLocation() + "\\tools\\android.bat";
        }
        return this.getSdkLocation() + "/tools/android";
    }

    String getAdbCommand() {
        if (Utilities.isWindows()) {
            return this.getSdkLocation() + "\\platform-tools\\adb.exe";
        }
        return this.getSdkLocation() + "/platform-tools/adb";
    }

    public Collection<SDK> getSDKs() throws IOException {
        String avdString = ProcessUtilities.callProcess((String)this.getAndroidCommand(), (boolean)true, (int)30000, (String[])new String[]{"list", "target"});
        return Target.parse(avdString);
    }

    public SDK getPrefferedTarget() {
        try {
            Collection<SDK> targets1 = this.getSDKs();
            for (SDK t : targets1) {
                if (!this.targets.contains(t.getName())) continue;
                return t;
            }
            if (targets1.iterator().hasNext()) {
                return targets1.iterator().next();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public Collection<Device> getConnectedDevices() throws IOException {
        String avdString = ProcessUtilities.callProcess((String)this.getAdbCommand(), (boolean)true, (int)DEFAULT_TIMEOUT, (String[])new String[]{"devices"});
        Collection<Device> devices = AndroidDevice.parse(avdString);
        if (devices.isEmpty()) {
            try {
                ProcessUtilities.callProcess((String)this.getAdbCommand(), (boolean)true, (int)DEFAULT_TIMEOUT, (String[])new String[]{"kill-server"});
                ProcessUtilities.callProcess((String)this.getAdbCommand(), (boolean)true, (int)DEFAULT_TIMEOUT, (String[])new String[]{"start-server"});
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        avdString = ProcessUtilities.callProcess((String)this.getAdbCommand(), (boolean)true, (int)DEFAULT_TIMEOUT, (String[])new String[]{"devices"});
        devices = AndroidDevice.parse(avdString);
        return devices;
    }

    public ExecutorTask buildProject(File dir, String ... targets) throws IOException {
        File build = new File(dir.getAbsolutePath() + File.separator + "build.xml");
        FileObject buildFo = FileUtil.toFileObject((File)build);
        return ActionUtils.runTarget((FileObject)buildFo, (String[])targets, null);
    }

    public void cleanProject(File dir) throws IOException {
        FileUtil.toFileObject((File)dir).delete();
    }

    public String getSdkLocation() {
        String sdkLocation = NbPreferences.forModule(AndroidPlatform.class).get(ANDROID_SDK_ROOT_PREF, null);
        if (sdkLocation != null && !sdkLocation.isEmpty()) {
            return sdkLocation;
        }
        return this.getSdkFromAndroidHome();
    }

    public void setSdkLocation(String sdkLocation) {
        NbPreferences.forModule(AndroidPlatform.class).put(ANDROID_SDK_ROOT_PREF, sdkLocation);
        this.propertyChangeSupport.firePropertyChange("SDK", null, sdkLocation);
    }

    public boolean waitEmulatorReady(int timeout) {
        try {
            return (Boolean)RequestProcessor.getDefault().invokeAny(Collections.singleton(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AndroidPlatform.this.waitEmulatorReady();
                }
            }), (long)timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return false;
    }

    private boolean waitEmulatorReady() {
        try {
            while (true) {
                String value;
                if ("stopped".equals((value = ProcessUtilities.callProcess((String)this.getAdbCommand(), (boolean)true, (int)-1, (String[])new String[]{"-e", "wait-for-device", "shell", "getprop", "init.svc.bootanim"})).trim())) {
                    return true;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    public void manageDevices() {
        assert (!SwingUtilities.isEventDispatchThread());
        try {
            ProcessUtilities.callProcess((String)this.getAndroidCommand(), (boolean)true, (int)-1, (String[])new String[]{"avd"});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean isReady() {
        return this.getSdkLocation() != null && !this.getSdkLocation().isEmpty();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String getType() {
        return "android";
    }

    public String getSimulatorPath() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Device getDevice(String name, EditableProperties props) {
        return AndroidDevice.get(name, props);
    }

    public String getCodeSignIdentity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getProvisioningProfilePath() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCodeSignIdentity(String identity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setProvisioningProfilePath(String path) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<? extends ProvisioningProfile> getProvisioningProfiles() {
        return Collections.emptyList();
    }

    public String getProcessIdByName(String appName) {
        try {
            String line;
            String result = ProcessUtilities.callProcess((String)this.getAdbCommand(), (boolean)true, (int)DEFAULT_TIMEOUT, (String[])new String[]{"shell", "ps"});
            BufferedReader r = new BufferedReader(new StringReader(result));
            while ((line = r.readLine()) != null) {
                Pattern column;
                Matcher matcher;
                if (!line.trim().endsWith(appName) || !(matcher = (column = Pattern.compile("(\\S+)(\\s+)(\\S+)(\\s+)(.+)")).matcher(line)).matches()) continue;
                return matcher.group(3);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    boolean isWebViewDebugSupported(boolean emulator) {
        try {
            String version = ProcessUtilities.callProcess((String)this.getAdbCommand(), (boolean)true, (int)-1, (String[])new String[]{emulator ? "-e" : "-d", "wait-for-device", "shell", "getprop", "ro.build.version.release"});
            return version.compareTo("4.4") >= 0;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private String getSdkFromAndroidHome() {
        String androidHomeValue = System.getenv("ANDROID_HOME");
        if (androidHomeValue != null && !androidHomeValue.isEmpty()) {
            boolean validSdk;
            File androidLoc = new File(androidHomeValue);
            File androidTools = new File(androidLoc, "platform-tools");
            boolean bl = validSdk = androidLoc.exists() && androidLoc.isDirectory() && androidTools.exists() && androidTools.isDirectory();
            if (validSdk) {
                NbPreferences.forModule(AndroidPlatform.class).put(ANDROID_SDK_ROOT_PREF, androidHomeValue);
                return androidHomeValue;
            }
        }
        return null;
    }

    boolean adbCommandExists() {
        return Files.exists(Paths.get(this.getAdbCommand(), new String[0]), new LinkOption[0]);
    }
}

