/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.NewFileWizard;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.Bundle;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class NewFile
extends ProjectAction
implements PropertyChangeListener,
Presenter.Popup {
    private static final RequestProcessor RP = new RequestProcessor(NewFile.class);
    private static final RequestProcessor INSTANTIATE_RP = new RequestProcessor(NewFile.class.getName() + ".INSTANTIATE_RP", 5);
    private static final Logger LOG = Logger.getLogger(NewFile.class.getName());
    private JMenu subMenu;
    private static final String TEMPLATE_PROPERTY = "org.netbeans.modules.project.ui.actions.NewFile.Template";
    private static final String IN_PROJECT_PROPERTY = "org.netbeans.modules.project.ui.actions.NewFile.InProject";

    public NewFile() {
        this((Lookup)null);
    }

    public NewFile(Lookup context) {
        super((String)null, Bundle.LBL_NewFileAction_Name(), null, context);
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/newFile.png");
        this.putValue("ShortDescription", Bundle.LBL_NewFileAction_Tooltip());
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        this.refresh(this.getLookup(), true);
    }

    @Override
    protected void refresh(Lookup context, boolean immediate) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                NewFile.this.setDisplayName(Bundle.LBL_NewFileAction_Name());
            }
        });
    }

    @Override
    public JMenuItem getPopupPresenter() {
        JMenuItem menu = new JMenuItem(this);
        menu.setIcon(null);
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)((String)this.getValue("Name")));
        return menu;
    }

    @Override
    protected void actionPerformed(Lookup context) {
        this.doPerform(context, null, true);
    }

    private void doPerform(Lookup context, final DataObject template, boolean includeTemplatesWithProjects) {
        if (context == null) {
            context = this.getLookup();
        }
        final NewFileWizard wd = new NewFileWizard(this.preselectedProject(context, includeTemplatesWithProjects), includeTemplatesWithProjects);
        DataFolder preselectedFolder = this.preselectedFolder(context);
        if (preselectedFolder != null) {
            wd.setTargetFolder(preselectedFolder);
        }
        INSTANTIATE_RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Set resultSet;
                    Set set = resultSet = template == null ? wd.instantiate() : wd.instantiate(template);
                    if (resultSet == null || resultSet.isEmpty()) {
                        return;
                    }
                    for (Object obj : resultSet) {
                        DataObject newDO = null;
                        if (obj instanceof DataObject) {
                            newDO = (DataObject)obj;
                        } else if (obj instanceof FileObject) {
                            try {
                                newDO = DataObject.find((FileObject)((FileObject)obj));
                            }
                            catch (DataObjectNotFoundException x) {
                                assert (false) : obj;
                            }
                        } else assert (false) : obj;
                        if (newDO == null) continue;
                        ProjectUtilities.openAndSelectNewObject(newDO);
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                FileObject foTemplate = Templates.getTemplate((WizardDescriptor)wd);
                OpenProjectList.getDefault().updateTemplatesLRU(foTemplate);
            }
        });
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new NewFile(actionContext);
    }

    public JMenuItem getSubmenuPopupPresenter() {
        if (this.subMenu == null) {
            this.subMenu = new JMenu(Bundle.LBL_NewFileAction_PopupName());
        }
        return this.subMenu;
    }

    protected void fillSubMenu() {
        this.fillSubMenu(this.subMenu, this.getLookup());
    }

    @CheckForNull
    private Project preselectedProject(Lookup context, boolean inProject) {
        Project preselectedProject = Arrays.stream(ActionsUtil.getProjectsFromLookup(context, null)).findFirst().orElse(null);
        if (preselectedProject != null && !NewFile.isImportant(preselectedProject)) {
            Project p = null;
            for (FileObject dir = preselectedProject.getProjectDirectory().getParent(); !(dir == null || (p = FileOwnerQuery.getOwner((FileObject)dir)) != null && NewFile.isImportant(p)); dir = dir.getParent()) {
                p = null;
            }
            if (p != null) {
                preselectedProject = p;
            }
        }
        if (preselectedProject == null && inProject && (preselectedProject = OpenProjectList.getDefault().getMainProject()) == null && OpenProjectList.getDefault().getOpenProjects().length > 0) {
            preselectedProject = OpenProjectList.getDefault().getOpenProjects()[0];
        }
        return preselectedProject;
    }

    private static boolean isImportant(@NonNull Project p) {
        if (!ProjectConvertors.isConvertorProject((Project)p)) {
            return true;
        }
        RecommendedTemplates pt = (RecommendedTemplates)p.getLookup().lookup(RecommendedTemplates.class);
        if (pt == null) {
            return false;
        }
        Project rOwner = ProjectConvertors.getNonConvertorOwner((FileObject)p.getProjectDirectory());
        RecommendedTemplates rot = rOwner == null ? null : (RecommendedTemplates)p.getLookup().lookup(RecommendedTemplates.class);
        return pt != rot;
    }

    private DataFolder preselectedFolder(Lookup context) {
        DataFolder preselectedFolder = null;
        preselectedFolder = (DataFolder)context.lookup(DataFolder.class);
        if (preselectedFolder == null) {
            DataObject dobj = (DataObject)context.lookup(DataObject.class);
            if (dobj != null) {
                preselectedFolder = dobj.getFolder();
            } else {
                FileObject fo = (FileObject)context.lookup(FileObject.class);
                if (fo != null) {
                    if (fo.isFolder()) {
                        preselectedFolder = DataFolder.findFolder((FileObject)fo);
                    } else if (fo.getParent() != null) {
                        preselectedFolder = DataFolder.findFolder((FileObject)fo.getParent());
                    }
                }
            }
        }
        LOG.log(Level.FINE, "#210919: found preselected folder {0} for {1}", new Object[]{preselectedFolder, context});
        return preselectedFolder;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh(Lookup.EMPTY, false);
    }

    private void fillSubMenu(final JMenu menuItem, Lookup lookup) {
        menuItem.removeAll();
        JMenuItem wait = new JMenuItem(Bundle.NewFile_please_wait());
        wait.setEnabled(false);
        menuItem.add(wait);
        final Pair<List<Project>, List<FileObject>> data = ActionsUtil.mineFromLookup(lookup);
        RP.post(new Runnable(){

            @Override
            public void run() {
                Project[] projects = ActionsUtil.getProjects((Pair<List<Project>, List<FileObject>>)data);
                final Project project = projects.length > 0 ? projects[0] : null;
                final List<OpenProjectList.TemplateItem> items = OpenProjectList.prepareTemplates(project, NewFile.this.getLookup());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        menuItem.removeAll();
                        PopupListener menuListener = new PopupListener();
                        for (OpenProjectList.TemplateItem i : items) {
                            JMenuItem item = new JMenuItem(Bundle.LBL_NewFileAction_Template_PopupName(i.displayName), i.icon);
                            item.addActionListener(menuListener);
                            item.putClientProperty(NewFile.TEMPLATE_PROPERTY, i.template);
                            item.putClientProperty(NewFile.IN_PROJECT_PROPERTY, project != null);
                            menuItem.add(item);
                        }
                        if (!items.isEmpty()) {
                            menuItem.add(new JPopupMenu.Separator());
                        }
                        JMenuItem fileItem = new JMenuItem(Bundle.LBL_NewFileAction_File_PopupName(), (Icon)NewFile.this.getValue("SmallIcon"));
                        fileItem.addActionListener(menuListener);
                        fileItem.putClientProperty(NewFile.TEMPLATE_PROPERTY, null);
                        fileItem.putClientProperty(NewFile.IN_PROJECT_PROPERTY, project != null);
                        menuItem.add(fileItem);
                        menuItem.getPopupMenu().pack();
                    }
                });
            }
        });
    }

    public static final class WithSubMenu
    extends NewFile {
        public WithSubMenu() {
        }

        private WithSubMenu(Lookup actionContext) {
            super(actionContext);
        }

        @Override
        public JMenuItem getPopupPresenter() {
            return new DynaMenu(Bundle.LBL_NewFileAction_PopupName());
        }

        @Override
        public Action createContextAwareInstance(Lookup actionContext) {
            return new WithSubMenu(actionContext);
        }

        private final class DynaMenu
        extends JMenu
        implements DynamicMenuContent {
            public DynaMenu(String a) {
                super(a);
            }

            public JComponent[] getMenuPresenters() {
                JMenuItem jc = WithSubMenu.this.getSubmenuPopupPresenter();
                WithSubMenu.this.fillSubMenu();
                return new JComponent[]{jc};
            }

            public JComponent[] synchMenuPresenters(JComponent[] items) {
                JMenuItem jc = WithSubMenu.this.getSubmenuPopupPresenter();
                WithSubMenu.this.fillSubMenu();
                return new JComponent[]{jc};
            }
        }
    }

    private class PopupListener
    implements ActionListener {
        private PopupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            Boolean inProject = (Boolean)source.getClientProperty(NewFile.IN_PROJECT_PROPERTY);
            DataObject template = (DataObject)source.getClientProperty(NewFile.TEMPLATE_PROPERTY);
            if (inProject != null && inProject == Boolean.FALSE) {
                NewFile.this.doPerform(null, template, false);
            } else {
                NewFile.this.doPerform(null, template, true);
            }
        }
    }
}

