/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.zip;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.project.ui.ProjectCellRenderer;
import org.netbeans.modules.project.ui.zip.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ExportZIP
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(ExportZIP.class);
    private static final Logger LOG = Logger.getLogger(ExportZIP.class.getName());
    private static final int BUFFER_SIZE = 1024;
    private boolean zipFieldDefault = true;
    private JButton otherButton;
    private JTextField otherField;
    private JRadioButton otherRadio;
    private JComboBox projectCombo;
    private JRadioButton projectRadio;
    private ButtonGroup rootGroup;
    private JButton zipButton;
    private JTextField zipField;
    private JLabel zipLabel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OS_OPEN_STREAM"})
    private static boolean build(File root, File zip) throws IOException {
        final AtomicBoolean canceled = new AtomicBoolean();
        ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.MSG_building(zip.getName()), (Cancellable)new Cancellable(){

            public boolean cancel() {
                return canceled.compareAndSet(false, true);
            }
        });
        handle.start();
        try {
            ArrayList<String> files = new ArrayList<String>();
            ExportZIP.scanForFiles(root, files, "", handle, canceled, true);
            if (canceled.get()) {
                boolean bl = false;
                return bl;
            }
            handle.switchToDeterminate(files.size());
            try (FileOutputStream os = new FileOutputStream(zip);){
                ZipOutputStream zos = new ZipOutputStream(os);
                HashSet<String> written = new HashSet<String>();
                String prefix = root.getName() + "/";
                for (int i = 0; i < files.size(); ++i) {
                    if (canceled.get()) {
                        boolean bl = false;
                        return bl;
                    }
                    String name = (String)files.get(i);
                    ExportZIP.writeEntry(prefix + name, written, zos, new File(root, name));
                    handle.progress(Bundle.MSG_packed(name), i);
                }
                zos.finish();
                zos.close();
            }
        }
        finally {
            handle.finish();
        }
        return true;
    }

    private static boolean scanForFiles(File root, List<String> files, String prefix, ProgressHandle handle, AtomicBoolean canceled, boolean mixedSharability) throws IOException {
        Object[] kids = root.listFiles();
        if (kids == null) {
            throw new IOException("could not list " + root);
        }
        Arrays.sort(kids);
        boolean atLeastOneIncluded = false;
        block4: for (Object kid : kids) {
            boolean kidMixed;
            if (canceled.get()) {
                return false;
            }
            if (!VisibilityQuery.getDefault().isVisible((File)kid)) continue;
            if (mixedSharability) {
                switch (SharabilityQuery.getSharability((URI)Utilities.toURI((File)kid))) {
                    case SHARABLE: {
                        kidMixed = false;
                        break;
                    }
                    case NOT_SHARABLE: {
                        continue block4;
                    }
                    default: {
                        kidMixed = true;
                        break;
                    }
                }
            } else {
                kidMixed = false;
            }
            String n = ((File)kid).getName();
            String prefixN = prefix + n;
            if (((File)kid).isFile()) {
                files.add(prefixN);
                atLeastOneIncluded = true;
                continue;
            }
            if (!((File)kid).isDirectory()) continue;
            handle.progress(Bundle.MSG_searching(prefixN));
            atLeastOneIncluded = ExportZIP.scanForFiles((File)kid, files, prefixN + "/", handle, canceled, kidMixed);
        }
        if (!atLeastOneIncluded && prefix.endsWith("/")) {
            files.add(prefix);
            atLeastOneIncluded = true;
        }
        return atLeastOneIncluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEntry(String name, Set<String> written, ZipOutputStream zos, File f) throws IOException, FileNotFoundException {
        if (!written.add(name)) {
            return;
        }
        int idx = name.lastIndexOf(47, name.length() - 2);
        if (idx != -1) {
            ExportZIP.writeEntry(name.substring(0, idx + 1), written, zos, f.getParentFile());
        }
        ZipEntry ze = new ZipEntry(name);
        ze.setTime(f.lastModified());
        if (name.endsWith("/")) {
            ze.setMethod(0);
            ze.setSize(0L);
            ze.setCrc(0L);
            zos.putNextEntry(ze);
        } else {
            FileInputStream is = new FileInputStream(f);
            ze.setMethod(8);
            ze.setSize(f.length());
            CRC32 crc = new CRC32();
            try {
                ExportZIP.copyStreams(is, null, crc);
            }
            finally {
                ((InputStream)is).close();
            }
            ze.setCrc(crc.getValue());
            zos.putNextEntry(ze);
            try (FileInputStream zis = new FileInputStream(f);){
                ExportZIP.copyStreams(zis, zos, null);
            }
        }
    }

    private boolean check(NotificationLineSupport notifications) {
        String t;
        notifications.clearMessages();
        if (this.projectRadio.isSelected() && this.projectCombo.getSelectedIndex() == -1) {
            notifications.setInformationMessage(Bundle.ERR_no_proj());
            return false;
        }
        if (this.otherRadio.isSelected()) {
            t = this.otherField.getText();
            if (t.isEmpty()) {
                notifications.setInformationMessage(Bundle.ERR_no_root());
                return false;
            }
            if (!new File(t).isDirectory()) {
                notifications.setErrorMessage(Bundle.ERR_no_dir(t));
                return false;
            }
        }
        if ((t = this.zipField.getText()).isEmpty()) {
            notifications.setInformationMessage(Bundle.ERR_no_zip());
            return false;
        }
        if (new File(t).exists()) {
            notifications.setWarningMessage(Bundle.WRN_exists(t));
        } else {
            if (new File(t).getParentFile() == null) {
                notifications.setErrorMessage(Bundle.ERR_no_dir(new File(t)));
                return false;
            }
            if (!new File(t).getParentFile().isDirectory()) {
                notifications.setErrorMessage(Bundle.ERR_no_dir(new File(t).getParent()));
                return false;
            }
        }
        if (new File(this.root(), ".hg/store").isDirectory()) {
            notifications.setInformationMessage(Bundle.ERR_hg());
        }
        return true;
    }

    private void onRadioButtonChange() {
        this.otherButton.setEnabled(this.otherRadio.isSelected());
    }

    private ExportZIP() {
        this.initComponents();
        this.projectCombo.setRenderer(new ProjectCellRenderer());
        this.projectCombo.setModel(new DefaultComboBoxModel<Project>(OpenProjects.getDefault().getOpenProjects()));
        Collection selectedProjects = Utilities.actionsGlobalContext().lookupAll(Project.class);
        if (selectedProjects.size() == 1) {
            this.projectCombo.setSelectedItem(selectedProjects.iterator().next());
        } else {
            Project p;
            Collection selectedFiles = Utilities.actionsGlobalContext().lookupAll(FileObject.class);
            if (selectedFiles.size() == 1 && (p = FileOwnerQuery.getOwner((FileObject)((FileObject)selectedFiles.iterator().next()))) != null) {
                this.projectCombo.setSelectedItem(p);
            }
        }
        this.zipField.getDocument().addDocumentListener(new DocumentListener(){

            private void edited() {
                ExportZIP.this.firePropertyChange("validity", null, null);
                ExportZIP.this.zipFieldDefault = false;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.edited();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.edited();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.onRadioButtonChange();
    }

    private File root() {
        if (this.projectRadio.isSelected()) {
            Project p = (Project)this.projectCombo.getSelectedItem();
            if (p != null) {
                return FileUtil.toFile((FileObject)p.getProjectDirectory());
            }
            return null;
        }
        return new File(this.otherField.getText());
    }

    private void defaultZipField() {
        File root;
        if (this.zipFieldDefault && (root = this.root()) != null) {
            this.zipField.setText(FileUtil.normalizeFile((File)new File(System.getProperty("java.io.tmpdir"), root.getName() + ".zip")).getAbsolutePath());
            this.zipFieldDefault = true;
        }
        this.firePropertyChange("validity", null, null);
    }

    private static void copyStreams(InputStream in, OutputStream out, CRC32 crc32) {
        if (out == null && crc32 == null) {
            return;
        }
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = in.read(buffer)) != -1) {
                if (out != null) {
                    out.write(buffer, 0, read);
                    continue;
                }
                crc32.update(buffer, 0, read);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.rootGroup = new ButtonGroup();
        this.projectRadio = new JRadioButton();
        this.projectCombo = new JComboBox();
        this.otherRadio = new JRadioButton();
        this.otherField = new JTextField();
        this.otherButton = new JButton();
        this.zipLabel = new JLabel();
        this.zipField = new JTextField();
        this.zipButton = new JButton();
        this.rootGroup.add(this.projectRadio);
        this.projectRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.projectRadio, (String)NbBundle.getMessage(ExportZIP.class, (String)"ExportZIP.projectRadio.text"));
        this.projectRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportZIP.this.projectRadioActionPerformed(evt);
            }
        });
        this.projectCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportZIP.this.projectComboActionPerformed(evt);
            }
        });
        this.rootGroup.add(this.otherRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.otherRadio, (String)NbBundle.getMessage(ExportZIP.class, (String)"ExportZIP.otherRadio.text"));
        this.otherRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportZIP.this.otherRadioActionPerformed(evt);
            }
        });
        this.otherField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.otherButton, (String)NbBundle.getMessage(ExportZIP.class, (String)"ExportZIP.otherButton.text"));
        this.otherButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportZIP.this.otherButtonActionPerformed(evt);
            }
        });
        this.zipLabel.setLabelFor(this.zipField);
        Mnemonics.setLocalizedText((JLabel)this.zipLabel, (String)NbBundle.getMessage(ExportZIP.class, (String)"ExportZIP.zipLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.zipButton, (String)NbBundle.getMessage(ExportZIP.class, (String)"ExportZIP.zipButton.text"));
        this.zipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportZIP.this.zipButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.zipLabel).addComponent(this.projectRadio).addComponent(this.otherRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.otherField, -1, 552, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.otherButton)).addComponent(this.projectCombo, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.zipField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.zipButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectRadio).addComponent(this.projectCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.otherRadio).addComponent(this.otherField, -2, -1, -2).addComponent(this.otherButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.zipLabel).addComponent(this.zipField, -2, -1, -2).addComponent(this.zipButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void zipButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        if (fc.showSaveDialog(this) == 0) {
            this.zipField.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void otherButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(this) == 0) {
            this.otherField.setText(fc.getSelectedFile().getAbsolutePath());
            this.otherRadio.setSelected(true);
            this.defaultZipField();
        }
    }

    private void projectComboActionPerformed(ActionEvent evt) {
        this.projectRadio.setSelected(true);
        this.defaultZipField();
    }

    private void projectRadioActionPerformed(ActionEvent evt) {
        this.defaultZipField();
        this.onRadioButtonChange();
    }

    private void otherRadioActionPerformed(ActionEvent evt) {
        this.defaultZipField();
        this.onRadioButtonChange();
    }

    public static final class ExportZIPAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            final ExportZIP panel = new ExportZIP();
            final JButton ok = new JButton(Bundle.LBL_export());
            NotifyDescriptor d = new NotifyDescriptor((Object)panel, Bundle.TITLE_export(), 2, -1, new Object[]{ok, NotifyDescriptor.CANCEL_OPTION}, null);
            final NotificationLineSupport notifications = d.createNotificationLineSupport();
            panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ok.setEnabled(panel.check(notifications));
                }
            });
            panel.projectComboActionPerformed(null);
            if (DialogDisplayer.getDefault().notify(d) == ok) {
                final File root = panel.root();
                final File zip = new File(panel.zipField.getText());
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!ExportZIP.build(root, zip)) {
                                Files.delete(zip.toPath());
                                return;
                            }
                        }
                        catch (IOException x) {
                            LOG.log(Level.WARNING, null, x);
                            return;
                        }
                        StatusDisplayer.getDefault().setStatusText(Bundle.MSG_created(zip));
                        try {
                            Desktop.getDesktop().open(zip);
                        }
                        catch (Exception x) {
                            LOG.log(Level.FINE, null, x);
                        }
                    }
                });
            }
        }
    }
}

