/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;

public class SortedListModel
extends AbstractListModel {
    public static final Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    };
    private List elements;
    private Comparator comp = DEFAULT_COMPARATOR;

    public SortedListModel() {
        this.elements = new ArrayList();
    }

    public SortedListModel(Collection c) {
        this.elements = new ArrayList(c);
        this.elements.sort(this.comp);
    }

    public SortedListModel(int initialCapacity) {
        this.elements = new ArrayList(initialCapacity);
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.elements.get(index);
    }

    public Comparator getComparator() {
        return this.comp;
    }

    public void setComparator(Comparator newComp) {
        if (this.comp == newComp) {
            return;
        }
        this.comp = newComp;
        this.elements.sort(this.comp);
        int last = this.elements.size() - 1;
        if (last >= 0) {
            super.fireContentsChanged(this, 0, last);
        }
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean contains(Object o) {
        return Collections.binarySearch(this.elements, o, this.getComparator()) >= 0;
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.elements.toArray(a);
    }

    public int add(Object o) {
        int index = Collections.binarySearch(this.elements, o, this.getComparator());
        if (index < 0) {
            index = -index - 1;
        }
        this.elements.add(index, o);
        this.fireIntervalAdded(this, index, index);
        return index;
    }

    public int indexOf(Object o) {
        return Collections.binarySearch(this.elements, o, this.getComparator());
    }

    public int remove(Object o) {
        int index = Collections.binarySearch(this.elements, o, this.getComparator());
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    public boolean remove(int index) {
        this.elements.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return true;
    }

    public void clear() {
        int last = this.elements.size() - 1;
        if (last >= 0) {
            this.elements.clear();
            this.fireIntervalRemoved(this, 0, last);
        }
    }

    public String toString() {
        return this.elements.toString();
    }
}

