/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListDbSystemComputePerformancesRequest
extends BmcRequest<Void> {
    private String dbSystemShape;
    private String opcRequestId;

    public String getDbSystemShape() {
        return this.dbSystemShape;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().dbSystemShape(this.dbSystemShape).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbSystemShape=").append(String.valueOf(this.dbSystemShape));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDbSystemComputePerformancesRequest)) {
            return false;
        }
        ListDbSystemComputePerformancesRequest other = (ListDbSystemComputePerformancesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbSystemShape, other.dbSystemShape) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbSystemShape == null ? 43 : this.dbSystemShape.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbSystemComputePerformancesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbSystemShape = null;
        private String opcRequestId = null;

        public Builder dbSystemShape(String dbSystemShape) {
            this.dbSystemShape = dbSystemShape;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbSystemComputePerformancesRequest o) {
            this.dbSystemShape(o.getDbSystemShape());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbSystemComputePerformancesRequest build() {
            ListDbSystemComputePerformancesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDbSystemComputePerformancesRequest buildWithoutInvocationCallback() {
            ListDbSystemComputePerformancesRequest request = new ListDbSystemComputePerformancesRequest();
            request.dbSystemShape = this.dbSystemShape;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

