/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.ui.nodes.WebPagesNode;
import org.netbeans.modules.maven.spi.nodes.AbstractMavenNodeList;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;

public class WebPagesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        return new WebRootNodeList(project);
    }

    private static class WebRootNodeList
    extends AbstractMavenNodeList<String>
    implements PropertyChangeListener {
        private final Project project;

        private WebRootNodeList(Project project) {
            this.project = project;
        }

        public List<String> keys() {
            ArrayList<String> keys = new ArrayList<String>();
            for (FileObject webRoot : this.getWebRoots()) {
                String webRootPath = webRoot.getPath();
                if (webRootPath.endsWith("/")) {
                    webRootPath = webRootPath.substring(0, webRootPath.length() - 1);
                }
                keys.add(webRootPath);
            }
            return keys;
        }

        public Node node(String key) {
            for (FileObject webRoot : this.getWebRoots()) {
                if (!key.equals(webRoot.getPath())) continue;
                DataFolder fold = DataFolder.findFolder((FileObject)webRoot);
                File webAppFolder = FileUtil.toFile((FileObject)webRoot);
                if (fold == null) continue;
                return new WebPagesNode(this.project, fold.getNodeDelegate().cloneNode(), webAppFolder);
            }
            return null;
        }

        private Collection<FileObject> getWebRoots() {
            ProjectWebRootProvider webRootProvider = (ProjectWebRootProvider)this.project.getLookup().lookup(ProjectWebRootProvider.class);
            if (webRootProvider != null) {
                return webRootProvider.getWebRoots();
            }
            return Collections.emptyList();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.fireChange();
            }
        }

        public void addNotify() {
            NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        }

        public void removeNotify() {
            NbMavenProject.removePropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        }
    }
}

