/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project.ui;

import com.sun.source.tree.DirectiveTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.Tree;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.project.ui.Bundle;
import org.netbeans.modules.java.project.ui.ExtensionAndImplementationWizardPanel;
import org.netbeans.modules.java.project.ui.JavaTargetChooserPanel;
import org.netbeans.spi.java.project.support.ui.templates.JavaFileWizardIteratorFactory;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class NewJavaFileWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    private static final String SOURCE_TYPE_GROOVY = "groovy";
    private static final String SUPERCLASS = "superclass";
    private static final String INTERFACES = "interfaces";
    static final String FOLDER = "Classes";
    static final String JDK_5 = "jdk5";
    static final String JDK_9 = "jdk9";
    static final String JDK_14 = "jdk14";
    private static final long serialVersionUID = 1L;
    private final Type type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private transient WizardDescriptor.Iterator<WizardDescriptor> projectSpecificIterator;
    private final transient Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public NewJavaFileWizardIterator() {
        this(Type.FILE);
    }

    private NewJavaFileWizardIterator(Type type) {
        this.type = type;
    }

    public static NewJavaFileWizardIterator packageWizard() {
        return new NewJavaFileWizardIterator(Type.PACKAGE);
    }

    public static NewJavaFileWizardIterator packageInfoWizard() {
        return new NewJavaFileWizardIterator(Type.PKG_INFO);
    }

    public static NewJavaFileWizardIterator moduleInfoWizard() {
        return new NewJavaFileWizardIterator(Type.MODULE_INFO);
    }

    private WizardDescriptor.Panel[] createPanels(@NonNull WizardDescriptor wizardDescriptor, @NonNull WizardDescriptor.Iterator<WizardDescriptor> it) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        if (project == null) {
            throw new NullPointerException("No project found for: " + wizardDescriptor);
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        assert (groups != null) : "Cannot return null from Sources.getSourceGroups: " + sources;
        if ((groups = NewJavaFileWizardIterator.checkNotNull(groups, sources)).length == 0) {
            groups = sources.getSourceGroups("generic");
            groups = NewJavaFileWizardIterator.checkNotNull(groups, sources);
            return new WizardDescriptor.Panel[]{Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])groups).create()};
        }
        ArrayList<Object> panels = new ArrayList<Object>();
        if (this.type == Type.FILE) {
            panels.add(JavaTemplates.createPackageChooser(project, groups, new ExtensionAndImplementationWizardPanel(wizardDescriptor)));
        } else if (this.type == Type.PKG_INFO) {
            panels.add(new JavaTargetChooserPanel(project, groups, null, Type.PKG_INFO, true));
        } else if (this.type == Type.MODULE_INFO) {
            panels.add(new JavaTargetChooserPanel(project, groups, null, Type.MODULE_INFO, false));
        } else {
            assert (this.type == Type.PACKAGE);
            SourceGroup[] groovySourceGroups = sources.getSourceGroups(SOURCE_TYPE_GROOVY);
            if (groovySourceGroups.length > 0) {
                ArrayList<SourceGroup> all = new ArrayList<SourceGroup>();
                all.addAll(Arrays.asList(groups));
                all.addAll(Arrays.asList(groovySourceGroups));
                groups = all.toArray(new SourceGroup[0]);
            }
            SourceGroup[] resources = sources.getSourceGroups("resources");
            assert (resources != null);
            if (resources.length > 0) {
                ArrayList<SourceGroup> all = new ArrayList<SourceGroup>();
                all.addAll(Arrays.asList(groups));
                all.addAll(Arrays.asList(resources));
                groups = all.toArray(new SourceGroup[0]);
            }
            panels.add(new JavaTargetChooserPanel(project, groups, null, Type.PACKAGE, false));
        }
        if (it != null) {
            if (it.current() != null) {
                panels.add(it.current());
            }
            while (it.hasNext()) {
                it.nextPanel();
                panels.add(it.current());
            }
        }
        return panels.toArray(new WizardDescriptor.Panel[0]);
    }

    private static SourceGroup[] checkNotNull(SourceGroup[] groups, Sources sources) {
        ArrayList<SourceGroup> sourceGroups = new ArrayList<SourceGroup>();
        for (SourceGroup sourceGroup : groups) {
            if (sourceGroup == null) {
                Exceptions.printStackTrace((Throwable)new NullPointerException(sources + " returns null SourceGroup!"));
                continue;
            }
            sourceGroups.add(sourceGroup);
        }
        return sourceGroups.toArray(new SourceGroup[0]);
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        assert (panels != null);
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    private void addRequires(FileObject createdFile, String createdModuleName, Set<String> requiredModuleNames) throws IOException {
        JavaSource src;
        if (requiredModuleNames == null) {
            requiredModuleNames = new LinkedHashSet<String>();
            ClassPath modulePath = ClassPath.getClassPath((FileObject)createdFile, (String)"modules/compile");
            for (FileObject root : modulePath.getRoots()) {
                String name = SourceUtils.getModuleName((URL)root.toURL(), (boolean)true);
                if (name == null) continue;
                requiredModuleNames.add(name);
            }
        }
        if (createdModuleName != null) {
            requiredModuleNames.remove(createdModuleName);
        }
        if (!requiredModuleNames.isEmpty() && (src = JavaSource.forFileObject((FileObject)createdFile)) != null) {
            Set<String> mNames = requiredModuleNames;
            src.runModificationTask((Task)new AddRequiresDirective(mNames)).commit();
        }
    }

    public Set<FileObject> instantiate() throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wiz);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject createdFile = null;
        String createdModuleName = null;
        LinkedHashSet<String> requiredModuleNames = null;
        if (this.type == Type.PACKAGE) {
            targetName = targetName.replace('.', '/');
            createdFile = FileUtil.createFolder((FileObject)dir, (String)targetName);
        } else if (this.type == Type.MODULE_INFO) {
            int index;
            String path;
            ClassPath msp;
            Project project = Templates.getProject((WizardDescriptor)this.wiz);
            URL[] srcs = UnitTestForSourceQuery.findSources((FileObject)dir);
            if (srcs.length > 0) {
                requiredModuleNames = new LinkedHashSet<String>();
                for (int i = 0; i < srcs.length; ++i) {
                    for (URL root : BinaryForSourceQuery.findBinaryRoots((URL)srcs[i]).getRoots()) {
                        String mName = SourceUtils.getModuleName((URL)root, (boolean)true);
                        if (mName == null) continue;
                        requiredModuleNames.add(mName);
                    }
                }
            }
            String moduleName = (msp = ClassPath.getClassPath((FileObject)dir, (String)"modules/source")) == null ? NewJavaFileWizardIterator.createModuleName(ProjectUtils.getInformation((Project)project).getDisplayName(), srcs.length > 0) : ((path = msp.getResourceName(dir)) == null ? null : ((index = path.indexOf(47)) < 0 ? path : path.substring(0, index)));
            DataObject dTemplate = DataObject.find((FileObject)template);
            DataObject dobj = dTemplate.createFromTemplate(df, targetName, Collections.singletonMap("moduleName", moduleName));
            createdFile = dobj.getPrimaryFile();
            createdModuleName = moduleName;
        } else {
            DataObject dTemplate = DataObject.find((FileObject)template);
            Object superclassProperty = this.wiz.getProperty(SUPERCLASS);
            String superclass = superclassProperty != null ? (String)superclassProperty : "";
            Object interfacesProperty = this.wiz.getProperty(INTERFACES);
            String interfaces = interfacesProperty != null ? (String)interfacesProperty : "";
            HashMap<String, String> parameters = new HashMap<String, String>(2);
            if (!superclass.isEmpty()) {
                parameters.put(SUPERCLASS, superclass);
            }
            if (!interfaces.isEmpty()) {
                parameters.put(INTERFACES, interfaces);
            }
            DataObject dobj = dTemplate.createFromTemplate(df, targetName, parameters);
            createdFile = dobj.getPrimaryFile();
        }
        HashSet<FileObject> res = new HashSet<FileObject>();
        res.add(createdFile);
        NewJavaFileWizardIterator.asInstantiatingIterator(this.projectSpecificIterator).map(it -> {
            try {
                return it.instantiate();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                return null;
            }
        }).ifPresent(res::addAll);
        if (this.type == Type.MODULE_INFO) {
            this.addRequires(createdFile, createdModuleName, requiredModuleNames);
        }
        return Collections.unmodifiableSet(res);
    }

    private static String createModuleName(String projectName, boolean isTest) {
        String part;
        StringBuilder name = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        boolean needsEscape = false;
        for (int i = 0; i < projectName.length(); ++i) {
            char c = projectName.charAt(i);
            if (first) {
                if (!Character.isJavaIdentifierStart(c)) {
                    if (!Character.isJavaIdentifierPart(c)) continue;
                    needsEscape = true;
                    sb.append(c);
                    first = false;
                    continue;
                }
                sb.append(c);
                first = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            if (sb.length() <= 0) continue;
            part = sb.toString();
            if (!needsEscape || name.length() > 0) {
                name.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
            sb = new StringBuilder();
            first = true;
            needsEscape = false;
        }
        if (sb.length() > 0) {
            part = sb.toString();
            if (!needsEscape || name.length() > 0) {
                name.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
        }
        if (isTest) {
            name.append(Bundle.TXT_Test());
        }
        return name.toString();
    }

    @NonNull
    private static Optional<WizardDescriptor.InstantiatingIterator<WizardDescriptor>> asInstantiatingIterator(@NullAllowed WizardDescriptor.Iterator<WizardDescriptor> it) {
        return Optional.ofNullable(it).map(p -> p instanceof WizardDescriptor.InstantiatingIterator ? (WizardDescriptor.InstantiatingIterator)p : null);
    }

    public void initialize(WizardDescriptor wiz) {
        JavaFileWizardIteratorFactory templateProvider;
        this.wiz = wiz;
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        JavaFileWizardIteratorFactory javaFileWizardIteratorFactory = templateProvider = project != null ? (JavaFileWizardIteratorFactory)project.getLookup().lookup(JavaFileWizardIteratorFactory.class) : null;
        if (templateProvider != null) {
            this.projectSpecificIterator = templateProvider.createIterator(Templates.getTemplate((WizardDescriptor)wiz));
            NewJavaFileWizardIterator.asInstantiatingIterator(this.projectSpecificIterator).ifPresent(it -> it.initialize(wiz));
        }
        this.panels = this.createPanels(wiz, this.projectSpecificIterator);
        String[] beforeSteps = null;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        NewJavaFileWizardIterator.asInstantiatingIterator(this.projectSpecificIterator).ifPresent(it -> it.uninitialize(wiz));
        this.wiz = null;
        this.panels = null;
        this.projectSpecificIterator = null;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        ChangeListener[] ls;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            ls = this.listeners.toArray(new ChangeListener[0]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener l : ls) {
            l.stateChanged(ev);
        }
    }

    public static enum Type {
        FILE,
        PACKAGE,
        PKG_INFO,
        MODULE_INFO;

    }

    private class AddRequiresDirective
    implements Task<WorkingCopy> {
        final Set<String> mNames;

        public AddRequiresDirective(Set<String> mNames) {
            this.mNames = mNames;
        }

        public void run(WorkingCopy copy) throws Exception {
            ModuleTree modle;
            copy.toPhase(JavaSource.Phase.RESOLVED);
            TreeMaker tm = copy.getTreeMaker();
            ModuleTree newModle = modle = copy.getCompilationUnit().getModule();
            for (String mName : this.mNames) {
                newModle = tm.addModuleDirective(newModle, (DirectiveTree)tm.Requires(false, false, tm.QualIdent(mName)));
            }
            copy.rewrite((Tree)modle, (Tree)newModle);
        }
    }
}

