/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core;

import java.io.File;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.versioning.core.APIAccessor;
import org.netbeans.modules.versioning.core.SPIAccessor;
import org.netbeans.modules.versioning.core.VersioningManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.core.spi.VCSForbiddenFolderProvider;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.modules.Places;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public class Utils {
    private static final RequestProcessor vcsBlockingRequestProcessor = new RequestProcessor("Versioning long tasks", 1, false, false);
    private static FileSystem filesystem;
    private static String[] unversionedFolders;
    private static final Set<String> forbiddenFolders;
    private static final RequestProcessor vcsParallelRequestProcessor;

    public static VCSContext contextForLookup(Lookup lookup) {
        Lookup.Result result = lookup.lookup(new Lookup.Template(Node.class));
        Collection nodes = result.allInstances();
        return VCSContext.forNodes(nodes.toArray(new Node[0]));
    }

    public static VCSContext contextForFileObjects(Set<? extends FileObject> files) {
        HashSet<VCSFileProxy> roots = new HashSet<VCSFileProxy>(files.size());
        if (files instanceof NonRecursiveFolder) {
            FileObject folder = ((NonRecursiveFolder)files).getFolder();
            VCSFileProxy vCSFileProxy = Utils.createFlatFileProxy(folder);
            if (vCSFileProxy != null) {
                roots.add(vCSFileProxy);
            }
        } else {
            for (FileObject fileObject : files) {
                VCSFileProxy file = VCSFileProxy.createFileProxy(fileObject);
                if (file == null) continue;
                roots.add(file);
            }
        }
        return SPIAccessor.IMPL.createContextForFiles(roots, files);
    }

    public static VCSFileProxy createFlatFileProxy(FileObject fo) {
        return APIAccessor.IMPL.createFlatFileProxy(fo);
    }

    public static boolean isAncestorOrEqual(VCSFileProxy ancestor, VCSFileProxy file) {
        if (APIAccessor.IMPL.isFlat(ancestor)) {
            return ancestor.equals(file) || ancestor.equals(file.getParentFile()) && !file.isDirectory();
        }
        return Utils.isAncestorOrEqual(ancestor, ancestor.getPath(), file);
    }

    public static boolean isAncestorOrEqual(String ancestorPath, VCSFileProxy file) {
        return Utils.isAncestorOrEqual(null, ancestorPath, file);
    }

    private static boolean isAncestorOrEqual(VCSFileProxy ancestor, String ancestorPath, VCSFileProxy file) {
        if (ancestorPath == null) {
            assert (ancestor != null);
            ancestorPath = ancestor.getPath();
        }
        String filePath = file.getPath();
        if (Utilities.isWindows() ? filePath.indexOf("~") < 0 && ancestorPath.indexOf("~") < 0 && filePath.length() < ancestorPath.length() : (Utilities.isMac() ? filePath.length() < ancestorPath.length() : !filePath.startsWith(ancestorPath))) {
            return false;
        }
        while (file != null) {
            if (ancestor == null && APIAccessor.IMPL.isLocalFile(file)) {
                ancestor = APIAccessor.IMPL.createFileProxy(ancestorPath);
            }
            if (ancestor == null ? file.getPath().equals(ancestorPath) : file.equals(ancestor)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static JMenuItem toMenuItem(Action action) {
        JMenuItem item;
        if (action instanceof Presenter.Menu) {
            item = ((Presenter.Menu)action).getMenuPresenter();
        } else if (action instanceof Presenter.Popup) {
            item = ((Presenter.Popup)action).getPopupPresenter();
        } else {
            item = new JMenuItem();
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
        }
        return item;
    }

    public static RequestProcessor.Task createTask(Runnable runnable) {
        return vcsBlockingRequestProcessor.create(runnable);
    }

    public static void postParallel(Runnable runnable) {
        vcsParallelRequestProcessor.post(runnable);
    }

    public static JSeparator createJSeparator() {
        JMenu menu = new JMenu();
        menu.addSeparator();
        return (JSeparator)menu.getPopupMenu().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFile(VCSFileProxy file) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = file.isFile();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - startTime, "Utils.isFile: java.io.File.isFile takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(VCSFileProxy file) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = file.exists();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - startTime, "Utils.exists: java.io.File.exists takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(VCSFileProxy file) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = file.canWrite();
            return bl;
        }
        finally {
            Utils.logLasting(file, System.currentTimeMillis() - startTime, "Utils.canWrite: java.io.File.canWrite takes too much time ({0} ms): {1}, stacktrace:");
        }
    }

    public static String[] getUnversionedFolders() {
        if (unversionedFolders == null) {
            String[] files;
            try {
                String uf = VersioningSupport.getPreferences().get("unversionedFolders", "");
                String ufProp = System.getProperty("versioning.unversionedFolders", "");
                StringBuilder sb = new StringBuilder(uf);
                File nbUserdir = Places.getUserDirectory();
                if (nbUserdir != null && !Utils.isVersionUserdir()) {
                    if (sb.length() > 0) {
                        sb.append(';');
                    }
                    sb.append(nbUserdir.getAbsolutePath());
                }
                if (!ufProp.isEmpty()) {
                    if (sb.length() > 0) {
                        sb.append(';');
                    }
                    sb.append(ufProp);
                }
                if (sb.length() == 0) {
                    files = new String[]{};
                } else {
                    String[] paths = sb.toString().split("\\;");
                    files = new String[paths.length];
                    int idx = 0;
                    for (String path : paths) {
                        files[idx++] = path;
                    }
                }
            }
            catch (Exception e) {
                files = new String[]{};
                Logger.getLogger(Utils.class.getName()).log(Level.INFO, e.getMessage(), e);
            }
            unversionedFolders = files;
        }
        return unversionedFolders;
    }

    public static boolean isForbiddenFolder(VCSFileProxy folder) {
        Collection forbiddenFolderProviders = Lookup.getDefault().lookupAll(VCSForbiddenFolderProvider.class);
        for (VCSForbiddenFolderProvider provider : forbiddenFolderProviders) {
            if (!provider.isForbiddenFolder(folder)) continue;
            return true;
        }
        return forbiddenFolders.contains(folder.getPath());
    }

    static boolean isVersionUserdir() {
        return "true".equals(System.getProperty("versioning.netbeans.user.versioned", "false"));
    }

    public static List<String> getStringList(Preferences prefs, String key) {
        ArrayList<CallSite> retval = new ArrayList<CallSite>();
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith(key)) continue;
                int n = Integer.parseInt(k.substring(k.lastIndexOf(46) + 1));
                retval.add((CallSite)((Object)(n + "." + prefs.get(k, null))));
            }
            ArrayList<String> rv = new ArrayList<String>(retval.size());
            rv.addAll(retval);
            for (String string : retval) {
                int pos = string.indexOf(46);
                int index = Integer.parseInt(string.substring(0, pos));
                rv.set(index, string.substring(pos + 1));
            }
            return rv;
        }
        catch (Exception ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, null, ex);
            return new ArrayList<String>(0);
        }
    }

    public static void put(Preferences prefs, String key, List<String> value) {
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith(key + ".")) continue;
                prefs.remove(k);
            }
            int idx = 0;
            for (String s : value) {
                prefs.put(key + "." + idx++, s);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, null, ex);
        }
    }

    private static void logLasting(VCSFileProxy file, long last, String message) {
        boolean allowed = false;
        if (!$assertionsDisabled) {
            allowed = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (allowed && last > 1500L) {
            StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (StackTraceElement e : stElements) {
                if (i++ <= 1) continue;
                if (i == 8) {
                    sb.append("...\n");
                    break;
                }
                sb.append(e.toString()).append("\n");
            }
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, message, new String[]{Long.toString(last), file.getPath()});
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, sb.toString());
        }
    }

    static String getSystemMenuName(VCSSystemProvider.VersioningSystem system) {
        if (VersioningManager.getInstance().isLocalHistory(system)) {
            return NbBundle.getMessage(Utils.class, (String)"CTL_LocalHistoryMenuName");
        }
        return system.getDisplayName();
    }

    public static VCSFileProxy toFileProxy(URI uri) {
        FileObject fo = Utils.toFileObject(uri);
        return fo != null ? VCSFileProxy.createFileProxy(fo) : null;
    }

    public static FileObject toFileObject(URI uri) {
        FileObject fo = null;
        try {
            fo = URLMapper.findFileObject((URL)uri.toURL());
        }
        catch (MalformedURLException ex) {
            VersioningManager.LOG.log(Level.WARNING, uri != null ? uri.toString() : null, ex);
        }
        if (fo == null) {
            String path = uri.getPath();
            try {
                URI parent = path.endsWith("/") ? uri.resolve("..") : new URI(uri + "/").resolve("..");
                path = parent.getPath();
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException ex) {
                VersioningManager.LOG.log(Level.WARNING, path, ex);
                return null;
            }
            fo = Utils.toFileObject(uri);
        }
        return fo;
    }

    static {
        HashSet<String> files = new HashSet<String>();
        try {
            String forbidden = System.getProperty("versioning.forbiddenFolders", "");
            files.addAll(Arrays.asList(forbidden.split("\\;")));
            files.remove("");
        }
        catch (Exception e) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, e.getMessage(), e);
        }
        forbiddenFolders = files;
        vcsParallelRequestProcessor = new RequestProcessor("Versioning parallel tasks", 10, false, true);
    }
}

