/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.netbeans.lib.uihandler.Decorable;
import org.netbeans.lib.uihandler.LogRecords;
import org.netbeans.modules.uihandler.VisualData;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

final class UINode
extends AbstractNode
implements VisualData,
Decorable {
    private static final SimpleFormatter FORMATTER = new SimpleFormatter();
    private LogRecord log;
    private String htmlKey;

    private UINode(LogRecord r, Children ch) {
        super(ch, Lookups.fixed((Object[])new Object[]{r}));
        this.log = r;
        LogRecords.decorate((LogRecord)r, (Decorable)this);
    }

    @Override
    public long getMillis() {
        return this.log.getMillis();
    }

    @Override
    public String getLoggerName() {
        return this.log.getLoggerName();
    }

    @Override
    public String getMessage() {
        return FORMATTER.format(this.log);
    }

    public String getHtmlDisplayName() {
        if (this.htmlKey == null) {
            return null;
        }
        return NbBundle.getMessage(UINode.class, (String)this.htmlKey, (Object)this.getDisplayName());
    }

    static String getParam(LogRecord r, int index) {
        Object[] arr = r.getParameters();
        if (arr == null || arr.length <= index || !(arr[index] instanceof String)) {
            return "";
        }
        return (String)arr[index];
    }

    static Node create(LogRecord r) {
        Children.Keys ch = r.getThrown() != null ? new StackTraceChildren(r.getThrown()) : ("UI_ENABLED_MODULES".equals(r.getMessage()) || "UI_DISABLED_MODULES".equals(r.getMessage()) ? new ModulesChildren(r.getParameters()) : Children.LEAF);
        return new UINode(r, (Children)ch);
    }

    private static String afterLastDot(String s) {
        int index = s.lastIndexOf(46);
        if (index == -1) {
            return s;
        }
        return s.substring(index + 1);
    }

    private static <T> T getParam(LogRecord r, int index, Class<T> type) {
        if (r == null || r.getParameters() == null || r.getParameters().length <= index) {
            return null;
        }
        Object o = r.getParameters()[index];
        return type.isInstance(o) ? (T)type.cast(o) : null;
    }

    private static final class StackTraceChildren
    extends Children.Keys<StackTraceElement> {
        private Throwable throwable;

        public StackTraceChildren(Throwable t) {
            this.throwable = t;
        }

        protected void addNotify() {
            this.setKeys(this.throwable.getStackTrace());
        }

        protected Node[] createNodes(StackTraceElement key) {
            AbstractNode an = new AbstractNode(Children.LEAF);
            an.setName(key.getClassName() + "." + key.getMethodName());
            an.setDisplayName(NbBundle.getMessage(UINode.class, (String)"MSG_StackTraceElement", (Object[])new Object[]{key.getFileName(), key.getClassName(), key.getMethodName(), key.getLineNumber(), UINode.afterLastDot(key.getClassName())}));
            an.setIconBaseWithExtension("org/netbeans/modules/uihandler/stackframe.gif");
            return new Node[]{an};
        }
    }

    private static final class ModulesChildren
    extends Children.Keys<Object> {
        private Object[] modules;

        public ModulesChildren(Object[] m) {
            this.modules = m;
        }

        protected void addNotify() {
            this.setKeys(this.modules);
        }

        protected Node[] createNodes(Object key) {
            AbstractNode an = new AbstractNode(Children.LEAF);
            an.setName((String)key);
            an.setIconBaseWithExtension("org/netbeans/lib/uihandler/module.gif");
            return new Node[]{an};
        }
    }
}

