/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl;

import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.model.impl.StyleSheetI;

public class Utils {
    private static final String IMPLEMENTATIONS_PACKAGE = StyleSheetI.class.getPackage().getName();
    private static final char IMPLEMENTATIONS_SUFFIX = 'I';

    static String getImplementingClassNameForNodeType(NodeType nodeType) {
        return Utils.getImplementingClassNameForNodeType(nodeType.name());
    }

    static String getImplementingClassNameForNodeType(String typeName) {
        StringBuilder sb = new StringBuilder();
        sb.append(IMPLEMENTATIONS_PACKAGE);
        sb.append('.');
        sb.append(Utils.getInterfaceForNodeType(typeName));
        sb.append('I');
        return sb.toString();
    }

    static String getInterfaceForNodeType(String typeName) {
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toUpperCase(typeName.charAt(0)));
        for (int i = 1; i < typeName.length(); ++i) {
            char c = typeName.charAt(i);
            if (c == '_') {
                assert (i < typeName.length() - 1) : String.format("NodeType name %s cannot end with underscore!", typeName);
                c = typeName.charAt(++i);
                assert (c != '_') : String.format("No two underscores in row can be preset in the NodeType %s name!", typeName);
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

