/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.eecommon.api.config;

import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.payara.eecommon.api.config.AppClientVersion;
import org.netbeans.modules.payara.eecommon.api.config.ApplicationVersion;
import org.netbeans.modules.payara.eecommon.api.config.EjbJarVersion;
import org.netbeans.modules.payara.eecommon.api.config.ServletVersion;

public abstract class J2EEBaseVersion
implements Comparable {
    private final String j2eeModuleVersion;
    private final int numericModuleVersion;
    private final int numericSpecVersion;

    protected J2EEBaseVersion(String moduleVersion, int nv, String specVersion, int nsv) {
        this.j2eeModuleVersion = moduleVersion;
        this.numericModuleVersion = nv;
        this.numericSpecVersion = nsv;
    }

    public String toString() {
        return this.j2eeModuleVersion;
    }

    public int compareSpecification(J2EEBaseVersion target) {
        if (this.numericSpecVersion < target.numericSpecVersion) {
            return -1;
        }
        if (this.numericSpecVersion > target.numericSpecVersion) {
            return 1;
        }
        return 0;
    }

    protected int numericCompare(J2EEBaseVersion target) {
        if (this.numericModuleVersion < target.numericModuleVersion) {
            return -1;
        }
        if (this.numericModuleVersion > target.numericModuleVersion) {
            return 1;
        }
        return 0;
    }

    public static J2EEBaseVersion getVersion(J2eeModule.Type moduleType, String moduleVersion) {
        J2EEBaseVersion version = null;
        if (J2eeModule.Type.WAR.equals(moduleType)) {
            version = ServletVersion.getServletVersion(moduleVersion);
        } else if (J2eeModule.Type.EJB.equals(moduleType)) {
            version = EjbJarVersion.getEjbJarVersion(moduleVersion);
        } else if (J2eeModule.Type.EAR.equals(moduleType)) {
            version = ApplicationVersion.getApplicationVersion(moduleVersion);
        } else if (J2eeModule.Type.CAR.equals(moduleType)) {
            version = AppClientVersion.getAppClientVersion(moduleVersion);
        }
        return version;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this.getClass().isInstance(obj)) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.numericSpecVersion;
    }
}

