/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.anttasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.Move;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class SignJarsTask
extends Task {
    public static final String JNLP_COMPONENT_NAME = "jnlpcomponent";
    public static final String EXTERNAL_JARS_PROP = "jar.files.to.include.through.external.jnlp";
    public static final String EXTERNAL_JNLPS_PROP = "external.jnlp.component.names";
    public static final String EXTERNAL_PROP_DELIMITER = ";";
    private static final String SIG_START = "META-INF/";
    private static final String SIG_END = ".SF";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String UTF_8 = "UTF-8";
    private static final String ATTR_CODEBASE = "Codebase";
    private static final String ATTR_PERMISSIONS = "Permissions";
    private static final String ATTR_APPLICATION_NAME = "Application-Name";
    private int compIndex = 1;
    private String keystore;
    private String storepass;
    private String keypass;
    private String alias;
    private File mainJar;
    private File destDir;
    private String codebase;
    private String compProp;
    private String signedJarsProp;
    private List<FileSet> filesets = new LinkedList<FileSet>();

    public void setKeystore(String s) {
        this.keystore = s;
    }

    public void setStorepass(String s) {
        this.storepass = s;
    }

    public void setKeypass(String s) {
        this.keypass = s;
    }

    public void setAlias(String s) {
        this.alias = s;
    }

    public void setMainjar(File f) {
        this.mainJar = f;
    }

    public void setDestdir(File f) {
        this.destDir = f;
    }

    public void setCodebase(String s) {
        this.codebase = s;
    }

    public void setComponentsprop(String s) {
        this.compProp = s;
    }

    public void setSignedjarsprop(String s) {
        this.signedJarsProp = s;
    }

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        HashMap signersMap = new HashMap();
        ArrayList<File> files2sign = new ArrayList<File>();
        ArrayList<File> alreadySigned = new ArrayList<File>();
        for (FileSet fileSet : this.filesets) {
            String[] files;
            File dir = fileSet.getDir(this.getProject());
            if (!dir.exists()) continue;
            this.log("Processing FileSet: " + fileSet, 3);
            DirectoryScanner ds = fileSet.getDirectoryScanner(this.getProject());
            File basedir = ds.getBasedir();
            for (String f : files = ds.getIncludedFiles()) {
                try {
                    File fl = new File(basedir, f);
                    Set<String> sgs = SignJarsTask.getSignatures(fl);
                    if (sgs.isEmpty()) {
                        files2sign.add(fl);
                        continue;
                    }
                    if (sgs.size() == 1 && sgs.contains(this.alias.toUpperCase())) {
                        alreadySigned.add(fl);
                        continue;
                    }
                    List lst = (List)signersMap.get(sgs);
                    if (lst != null) {
                        lst.add(fl);
                        continue;
                    }
                    ArrayList<File> nlst = new ArrayList<File>();
                    nlst.add(fl);
                    signersMap.put(sgs, nlst);
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex, this.getLocation());
                }
            }
        }
        this.log("Files to be signed: " + this.mainJar.toString() + ", " + ((Object)files2sign).toString(), 3);
        this.log("Files already signed by requested alias: " + ((Object)alreadySigned).toString(), 3);
        try {
            SignJarsTask.extendLibrariesManifests(this.getProject(), this.mainJar, files2sign);
            for (File signedLib : alreadySigned) {
                this.getProject().log(String.format("Not adding security attributes into library: %s the library is already signed.", SignJarsTask.safeRelativePath(this.getProject().getBaseDir(), signedLib)), 1);
            }
        }
        catch (IOException iOException) {
            this.getProject().log("Failed to extend libraries manifests: " + iOException.getMessage(), 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        SignJar signJar = (SignJar)this.getProject().createTask("signjar");
        signJar.setLocation(this.getLocation());
        signJar.setKeystore(this.keystore);
        signJar.setStorepass(this.storepass);
        signJar.setKeypass(this.keypass);
        signJar.setAlias(this.alias);
        signJar.init();
        this.log("Signing main jar file: " + this.mainJar, 3);
        signJar.setJar(this.mainJar);
        signJar.execute();
        if (files2sign.size() > 0) {
            for (File f : files2sign) {
                this.log("Signing file: " + f, 3);
                signJar.setJar(f);
                signJar.execute();
                stringBuilder.append("\n        <jar href=\"lib/" + f.getName() + "\" download=\"eager\"/>");
            }
        }
        if (alreadySigned.size() > 0) {
            for (File f : alreadySigned) {
                this.log("Adding signed file: " + f, 3);
                stringBuilder.append("\n        <jar href=\"lib/" + f.getName() + "\" download=\"eager\"/>");
            }
        }
        this.getProject().setProperty(this.signedJarsProp, stringBuilder.toString());
        StringBuilder compsBuilder = new StringBuilder();
        StringBuilder extJarsBuilder = new StringBuilder();
        StringBuilder extJnlpsBuilder = new StringBuilder();
        for (Map.Entry entry : signersMap.entrySet()) {
            this.log("Already signed: keystore aliases = " + entry.getKey() + " -> signed jars = " + entry.getValue(), 3);
            String compName = JNLP_COMPONENT_NAME + this.compIndex++;
            this.createJNLPComponentFile((Set)entry.getKey(), (List)entry.getValue(), compName);
            compsBuilder.append("\n        <extension name=\"" + compName + "\" href=\"" + compName + ".jnlp\"/>");
            for (File jarFile : (List)entry.getValue()) {
                extJarsBuilder.append(jarFile.getName() + EXTERNAL_PROP_DELIMITER);
            }
            extJnlpsBuilder.append(compName + ".jnlp" + EXTERNAL_PROP_DELIMITER);
        }
        String extPropString = compsBuilder.toString();
        this.getProject().setProperty(this.compProp, extPropString);
        String extJarsPropString = extJarsBuilder.toString();
        this.getProject().setProperty(EXTERNAL_JARS_PROP, extJarsPropString);
        String extJnlpsPropString = extJnlpsBuilder.toString();
        this.getProject().setProperty(EXTERNAL_JNLPS_PROP, extJnlpsPropString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getSignatures(File f) throws IOException {
        HashSet<String> signatures = new HashSet<String>(3);
        try (java.util.zip.ZipFile jarFile = null;){
            jarFile = new java.util.zip.ZipFile(f);
            Enumeration<? extends java.util.zip.ZipEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                java.util.zip.ZipEntry je = en.nextElement();
                if (je.isDirectory() || !je.getName().startsWith(SIG_START) || !je.getName().endsWith(SIG_END)) continue;
                String sigName = je.getName().substring(SIG_START.length(), je.getName().indexOf(SIG_END));
                signatures.add(sigName);
            }
        }
        return signatures;
    }

    private String createJNLPComponentFile(Set<String> aliases, List<File> jars, String compName) {
        File f = new File(this.destDir, compName + ".jnlp");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(f);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe, this.getLocation());
        }
        String codebaseTypeProp = this.getProject().getProperty("jnlp.codebase.type");
        String codebaseProp = null;
        if (codebaseTypeProp.equals("local")) {
            codebaseProp = this.getProject().getProperty("jnlp.local.codebase.url");
        } else if (codebaseTypeProp.equals("web")) {
            codebaseProp = this.getProject().getProperty("jnlp.codebase.url");
        } else if (codebaseTypeProp.equals("user")) {
            codebaseProp = this.getProject().getProperty("jnlp.codebase.user");
        }
        this.log("jnlp.codebase.url = " + codebaseProp, 3);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (this.codebase == null || this.codebase.startsWith("${")) {
            if (codebaseTypeProp == null || codebaseTypeProp.equals("no.codebase") || codebaseProp == null) {
                writer.println("<jnlp href=\"" + compName + ".jnlp\" spec=\"1.0+\">");
            } else if (codebaseProp != null) {
                writer.println("<jnlp codebase=\"" + codebaseProp + "\" href=\"" + compName + ".jnlp\" spec=\"1.0+\">");
            }
        } else {
            writer.println("<jnlp codebase=\"" + this.codebase + "\" href=\"" + compName + ".jnlp\" spec=\"1.0+\">");
        }
        writer.println("    <information>");
        writer.println("        <title>" + compName + "</title>");
        writer.println("        <vendor>" + this.concatSet(aliases) + "</vendor>");
        writer.println("    </information>");
        writer.println("    <security>");
        writer.println("        <all-permissions/>");
        writer.println("    </security>");
        writer.println("    <resources>");
        Iterator<File> iter = jars.iterator();
        while (iter.hasNext()) {
            writer.println("        <jar href=\"" + this.getPath(this.destDir.getAbsolutePath(), iter.next().getAbsolutePath()) + "\" download=\"eager\"/>");
        }
        writer.println("    </resources>");
        writer.println("    <component-desc/>");
        writer.println("</jnlp>");
        writer.flush();
        writer.close();
        return f.getAbsolutePath();
    }

    private String getPath(String dirPath, String filePath) {
        String retVal = null;
        if (filePath.indexOf(dirPath) != -1) {
            retVal = filePath.substring(dirPath.length() + 1).replace('\\', '/');
        }
        return retVal;
    }

    private String concatSet(Set<String> s) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Iterator<String> iter = s.iterator();
        while (iter.hasNext()) {
            if (first) {
                sb.append((Object)iter.next());
                continue;
            }
            sb.append(", " + iter.next());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extendLibrariesManifests(Project prj, File mainJar, List<? extends File> libraries) throws IOException {
        String codebase = null;
        String permissions = null;
        String appName = null;
        try (JarFile jf = new JarFile(mainJar);){
            Manifest mf = jf.getManifest();
            if (mf != null) {
                Attributes attributes = mf.getMainAttributes();
                codebase = attributes.getValue(ATTR_CODEBASE);
                permissions = attributes.getValue(ATTR_PERMISSIONS);
                appName = attributes.getValue(ATTR_APPLICATION_NAME);
            }
        }
        prj.log(String.format("Application: %s manifest: Codebase: %s, Permissions: %s, Application-Name: %s", SignJarsTask.safeRelativePath(prj.getBaseDir(), mainJar), codebase, permissions, appName), 3);
        if (codebase != null || permissions != null || appName != null) {
            for (File file : libraries) {
                try {
                    SignJarsTask.extendLibraryManifest(prj, file, codebase, permissions, appName);
                }
                catch (ManifestException mex) {
                    throw new IOException(mex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extendLibraryManifest(Project prj, File library, String codebase, String permissions, String appName) throws IOException, ManifestException {
        block25: {
            org.apache.tools.ant.taskdefs.Manifest manifest = null;
            Move mv = new Move();
            File tmpFile = new File(String.format("%s.tmp", library.getAbsolutePath()));
            mv.setFile(library);
            mv.setTofile(tmpFile);
            mv.execute();
            boolean success = false;
            try {
                HashMap<String, String> extendedAttrs = new HashMap<String, String>();
                try (ZipFile zf = new ZipFile(tmpFile);){
                    Manifest.Section mainSection;
                    String attr;
                    ZipEntry manifestEntry = zf.getEntry(MANIFEST);
                    if (manifestEntry != null) {
                        try (InputStreamReader in = new InputStreamReader(zf.getInputStream(manifestEntry), Charset.forName(UTF_8));){
                            manifest = new org.apache.tools.ant.taskdefs.Manifest((Reader)in);
                        }
                    } else {
                        manifest = new org.apache.tools.ant.taskdefs.Manifest();
                    }
                    if ((attr = (mainSection = manifest.getMainSection()).getAttributeValue(ATTR_CODEBASE)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_CODEBASE, codebase));
                        extendedAttrs.put(ATTR_CODEBASE, codebase);
                    }
                    if ((attr = mainSection.getAttributeValue(ATTR_PERMISSIONS)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_PERMISSIONS, permissions));
                        extendedAttrs.put(ATTR_PERMISSIONS, permissions);
                    }
                    if ((attr = mainSection.getAttributeValue(ATTR_APPLICATION_NAME)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_APPLICATION_NAME, appName));
                        extendedAttrs.put(ATTR_APPLICATION_NAME, appName);
                    }
                    if (extendedAttrs.isEmpty()) break block25;
                    Enumeration zent = zf.getEntries();
                    try (ZipOutputStream out = new ZipOutputStream(library);){
                        while (zent.hasMoreElements()) {
                            ZipEntry entry = (ZipEntry)zent.nextElement();
                            try (InputStream in = zf.getInputStream(entry);){
                                out.putNextEntry(entry);
                                if (MANIFEST.equals(entry.getName())) {
                                    PrintWriter manifestOut = new PrintWriter(new OutputStreamWriter((OutputStream)out, Charset.forName(UTF_8)));
                                    manifest.write(manifestOut);
                                    manifestOut.flush();
                                    continue;
                                }
                                SignJarsTask.copy(in, (OutputStream)out);
                            }
                        }
                    }
                    success = true;
                    StringBuilder message = new StringBuilder("Updating library ").append(SignJarsTask.safeRelativePath(prj.getBaseDir(), library)).append(" manifest");
                    for (Map.Entry e : extendedAttrs.entrySet()) {
                        message.append(String.format(" %s: %s,", e.getKey(), e.getValue()));
                    }
                    message.deleteCharAt(message.length() - 1);
                    prj.log(message.toString(), 3);
                }
            }
            finally {
                if (success) {
                    Delete del = new Delete();
                    del.setFile(tmpFile);
                    del.execute();
                } else {
                    Delete rm = new Delete();
                    rm.setFile(library);
                    rm.setQuiet(true);
                    rm.execute();
                    mv = new Move();
                    mv.setFile(tmpFile);
                    mv.setTofile(library);
                    mv.execute();
                }
            }
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] BUFFER = new byte[4096];
        int len;
        while ((len = in.read(BUFFER)) != -1) {
            out.write(BUFFER, 0, len);
        }
        return;
    }

    private static String safeRelativePath(File from, File to) {
        try {
            return FileUtils.getRelativePath((File)from, (File)to);
        }
        catch (Exception ex) {
            return to.getAbsolutePath();
        }
    }
}

