/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.MacsecProperties;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CrossConnect
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="crossConnectGroupId")
    private final String crossConnectGroupId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="locationName")
    private final String locationName;
    @JsonProperty(value="portName")
    private final String portName;
    @JsonProperty(value="portSpeedShapeName")
    private final String portSpeedShapeName;
    @JsonProperty(value="customerReferenceName")
    private final String customerReferenceName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="macsecProperties")
    private final MacsecProperties macsecProperties;
    @JsonProperty(value="ociPhysicalDeviceName")
    private final String ociPhysicalDeviceName;
    @JsonProperty(value="ociLogicalDeviceName")
    private final String ociLogicalDeviceName;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "crossConnectGroupId", "definedTags", "displayName", "freeformTags", "id", "lifecycleState", "locationName", "portName", "portSpeedShapeName", "customerReferenceName", "timeCreated", "macsecProperties", "ociPhysicalDeviceName", "ociLogicalDeviceName"})
    public CrossConnect(String compartmentId, String crossConnectGroupId, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, String id, LifecycleState lifecycleState, String locationName, String portName, String portSpeedShapeName, String customerReferenceName, Date timeCreated, MacsecProperties macsecProperties, String ociPhysicalDeviceName, String ociLogicalDeviceName) {
        this.compartmentId = compartmentId;
        this.crossConnectGroupId = crossConnectGroupId;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.id = id;
        this.lifecycleState = lifecycleState;
        this.locationName = locationName;
        this.portName = portName;
        this.portSpeedShapeName = portSpeedShapeName;
        this.customerReferenceName = customerReferenceName;
        this.timeCreated = timeCreated;
        this.macsecProperties = macsecProperties;
        this.ociPhysicalDeviceName = ociPhysicalDeviceName;
        this.ociLogicalDeviceName = ociLogicalDeviceName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCrossConnectGroupId() {
        return this.crossConnectGroupId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getPortSpeedShapeName() {
        return this.portSpeedShapeName;
    }

    public String getCustomerReferenceName() {
        return this.customerReferenceName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public MacsecProperties getMacsecProperties() {
        return this.macsecProperties;
    }

    public String getOciPhysicalDeviceName() {
        return this.ociPhysicalDeviceName;
    }

    public String getOciLogicalDeviceName() {
        return this.ociLogicalDeviceName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CrossConnect(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", crossConnectGroupId=").append(String.valueOf(this.crossConnectGroupId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", locationName=").append(String.valueOf(this.locationName));
        sb.append(", portName=").append(String.valueOf(this.portName));
        sb.append(", portSpeedShapeName=").append(String.valueOf(this.portSpeedShapeName));
        sb.append(", customerReferenceName=").append(String.valueOf(this.customerReferenceName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", macsecProperties=").append(String.valueOf((Object)this.macsecProperties));
        sb.append(", ociPhysicalDeviceName=").append(String.valueOf(this.ociPhysicalDeviceName));
        sb.append(", ociLogicalDeviceName=").append(String.valueOf(this.ociLogicalDeviceName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CrossConnect)) {
            return false;
        }
        CrossConnect other = (CrossConnect)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.crossConnectGroupId, other.crossConnectGroupId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.locationName, other.locationName) && Objects.equals(this.portName, other.portName) && Objects.equals(this.portSpeedShapeName, other.portSpeedShapeName) && Objects.equals(this.customerReferenceName, other.customerReferenceName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.macsecProperties, (Object)other.macsecProperties) && Objects.equals(this.ociPhysicalDeviceName, other.ociPhysicalDeviceName) && Objects.equals(this.ociLogicalDeviceName, other.ociLogicalDeviceName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.crossConnectGroupId == null ? 43 : this.crossConnectGroupId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.locationName == null ? 43 : this.locationName.hashCode());
        result = result * 59 + (this.portName == null ? 43 : this.portName.hashCode());
        result = result * 59 + (this.portSpeedShapeName == null ? 43 : this.portSpeedShapeName.hashCode());
        result = result * 59 + (this.customerReferenceName == null ? 43 : this.customerReferenceName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.macsecProperties == null ? 43 : this.macsecProperties.hashCode());
        result = result * 59 + (this.ociPhysicalDeviceName == null ? 43 : this.ociPhysicalDeviceName.hashCode());
        result = result * 59 + (this.ociLogicalDeviceName == null ? 43 : this.ociLogicalDeviceName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        PendingCustomer("PENDING_CUSTOMER"),
        Provisioning("PROVISIONING"),
        Provisioned("PROVISIONED"),
        Inactive("INACTIVE"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="crossConnectGroupId")
        private String crossConnectGroupId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="locationName")
        private String locationName;
        @JsonProperty(value="portName")
        private String portName;
        @JsonProperty(value="portSpeedShapeName")
        private String portSpeedShapeName;
        @JsonProperty(value="customerReferenceName")
        private String customerReferenceName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="macsecProperties")
        private MacsecProperties macsecProperties;
        @JsonProperty(value="ociPhysicalDeviceName")
        private String ociPhysicalDeviceName;
        @JsonProperty(value="ociLogicalDeviceName")
        private String ociLogicalDeviceName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder crossConnectGroupId(String crossConnectGroupId) {
            this.crossConnectGroupId = crossConnectGroupId;
            this.__explicitlySet__.add("crossConnectGroupId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder locationName(String locationName) {
            this.locationName = locationName;
            this.__explicitlySet__.add("locationName");
            return this;
        }

        public Builder portName(String portName) {
            this.portName = portName;
            this.__explicitlySet__.add("portName");
            return this;
        }

        public Builder portSpeedShapeName(String portSpeedShapeName) {
            this.portSpeedShapeName = portSpeedShapeName;
            this.__explicitlySet__.add("portSpeedShapeName");
            return this;
        }

        public Builder customerReferenceName(String customerReferenceName) {
            this.customerReferenceName = customerReferenceName;
            this.__explicitlySet__.add("customerReferenceName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder macsecProperties(MacsecProperties macsecProperties) {
            this.macsecProperties = macsecProperties;
            this.__explicitlySet__.add("macsecProperties");
            return this;
        }

        public Builder ociPhysicalDeviceName(String ociPhysicalDeviceName) {
            this.ociPhysicalDeviceName = ociPhysicalDeviceName;
            this.__explicitlySet__.add("ociPhysicalDeviceName");
            return this;
        }

        public Builder ociLogicalDeviceName(String ociLogicalDeviceName) {
            this.ociLogicalDeviceName = ociLogicalDeviceName;
            this.__explicitlySet__.add("ociLogicalDeviceName");
            return this;
        }

        public CrossConnect build() {
            CrossConnect model = new CrossConnect(this.compartmentId, this.crossConnectGroupId, this.definedTags, this.displayName, this.freeformTags, this.id, this.lifecycleState, this.locationName, this.portName, this.portSpeedShapeName, this.customerReferenceName, this.timeCreated, this.macsecProperties, this.ociPhysicalDeviceName, this.ociLogicalDeviceName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CrossConnect model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("crossConnectGroupId")) {
                this.crossConnectGroupId(model.getCrossConnectGroupId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("locationName")) {
                this.locationName(model.getLocationName());
            }
            if (model.wasPropertyExplicitlySet("portName")) {
                this.portName(model.getPortName());
            }
            if (model.wasPropertyExplicitlySet("portSpeedShapeName")) {
                this.portSpeedShapeName(model.getPortSpeedShapeName());
            }
            if (model.wasPropertyExplicitlySet("customerReferenceName")) {
                this.customerReferenceName(model.getCustomerReferenceName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("macsecProperties")) {
                this.macsecProperties(model.getMacsecProperties());
            }
            if (model.wasPropertyExplicitlySet("ociPhysicalDeviceName")) {
                this.ociPhysicalDeviceName(model.getOciPhysicalDeviceName());
            }
            if (model.wasPropertyExplicitlySet("ociLogicalDeviceName")) {
                this.ociLogicalDeviceName(model.getOciLogicalDeviceName());
            }
            return this;
        }
    }
}

