/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InstanceAgentFeatures;
import com.oracle.bmc.core.model.LaunchOptions;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Image
extends ExplicitlySetBmcModel {
    @JsonProperty(value="baseImageId")
    private final String baseImageId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="createImageAllowed")
    private final Boolean createImageAllowed;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="launchMode")
    private final LaunchMode launchMode;
    @JsonProperty(value="launchOptions")
    private final LaunchOptions launchOptions;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="operatingSystem")
    private final String operatingSystem;
    @JsonProperty(value="operatingSystemVersion")
    private final String operatingSystemVersion;
    @JsonProperty(value="agentFeatures")
    private final InstanceAgentFeatures agentFeatures;
    @JsonProperty(value="listingType")
    private final ListingType listingType;
    @JsonProperty(value="sizeInMBs")
    private final Long sizeInMBs;
    @JsonProperty(value="billableSizeInGBs")
    private final Long billableSizeInGBs;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"baseImageId", "compartmentId", "createImageAllowed", "definedTags", "displayName", "freeformTags", "id", "launchMode", "launchOptions", "lifecycleState", "operatingSystem", "operatingSystemVersion", "agentFeatures", "listingType", "sizeInMBs", "billableSizeInGBs", "timeCreated"})
    public Image(String baseImageId, String compartmentId, Boolean createImageAllowed, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, String id, LaunchMode launchMode, LaunchOptions launchOptions, LifecycleState lifecycleState, String operatingSystem, String operatingSystemVersion, InstanceAgentFeatures agentFeatures, ListingType listingType, Long sizeInMBs, Long billableSizeInGBs, Date timeCreated) {
        this.baseImageId = baseImageId;
        this.compartmentId = compartmentId;
        this.createImageAllowed = createImageAllowed;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.id = id;
        this.launchMode = launchMode;
        this.launchOptions = launchOptions;
        this.lifecycleState = lifecycleState;
        this.operatingSystem = operatingSystem;
        this.operatingSystemVersion = operatingSystemVersion;
        this.agentFeatures = agentFeatures;
        this.listingType = listingType;
        this.sizeInMBs = sizeInMBs;
        this.billableSizeInGBs = billableSizeInGBs;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBaseImageId() {
        return this.baseImageId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCreateImageAllowed() {
        return this.createImageAllowed;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public LaunchMode getLaunchMode() {
        return this.launchMode;
    }

    public LaunchOptions getLaunchOptions() {
        return this.launchOptions;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public InstanceAgentFeatures getAgentFeatures() {
        return this.agentFeatures;
    }

    public ListingType getListingType() {
        return this.listingType;
    }

    public Long getSizeInMBs() {
        return this.sizeInMBs;
    }

    public Long getBillableSizeInGBs() {
        return this.billableSizeInGBs;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Image(");
        sb.append("super=").append(super.toString());
        sb.append("baseImageId=").append(String.valueOf(this.baseImageId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", createImageAllowed=").append(String.valueOf(this.createImageAllowed));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", launchMode=").append(String.valueOf((Object)this.launchMode));
        sb.append(", launchOptions=").append(String.valueOf((Object)this.launchOptions));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", operatingSystem=").append(String.valueOf(this.operatingSystem));
        sb.append(", operatingSystemVersion=").append(String.valueOf(this.operatingSystemVersion));
        sb.append(", agentFeatures=").append(String.valueOf((Object)this.agentFeatures));
        sb.append(", listingType=").append(String.valueOf((Object)this.listingType));
        sb.append(", sizeInMBs=").append(String.valueOf(this.sizeInMBs));
        sb.append(", billableSizeInGBs=").append(String.valueOf(this.billableSizeInGBs));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image other = (Image)((Object)o);
        return Objects.equals(this.baseImageId, other.baseImageId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.createImageAllowed, other.createImageAllowed) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.launchMode, (Object)other.launchMode) && Objects.equals((Object)this.launchOptions, (Object)other.launchOptions) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.operatingSystem, other.operatingSystem) && Objects.equals(this.operatingSystemVersion, other.operatingSystemVersion) && Objects.equals((Object)this.agentFeatures, (Object)other.agentFeatures) && Objects.equals((Object)this.listingType, (Object)other.listingType) && Objects.equals(this.sizeInMBs, other.sizeInMBs) && Objects.equals(this.billableSizeInGBs, other.billableSizeInGBs) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.baseImageId == null ? 43 : this.baseImageId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.createImageAllowed == null ? 43 : this.createImageAllowed.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.launchMode == null ? 43 : this.launchMode.hashCode());
        result = result * 59 + (this.launchOptions == null ? 43 : this.launchOptions.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = result * 59 + (this.operatingSystemVersion == null ? 43 : this.operatingSystemVersion.hashCode());
        result = result * 59 + (this.agentFeatures == null ? 43 : this.agentFeatures.hashCode());
        result = result * 59 + (this.listingType == null ? 43 : this.listingType.hashCode());
        result = result * 59 + (this.sizeInMBs == null ? 43 : this.sizeInMBs.hashCode());
        result = result * 59 + (this.billableSizeInGBs == null ? 43 : this.billableSizeInGBs.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ListingType implements BmcEnum
    {
        Community("COMMUNITY"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ListingType> map;

        private ListingType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ListingType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ListingType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ListingType.class);
            map = new HashMap<String, ListingType>();
            for (ListingType v : ListingType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Importing("IMPORTING"),
        Available("AVAILABLE"),
        Exporting("EXPORTING"),
        Disabled("DISABLED"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LaunchMode implements BmcEnum
    {
        Native("NATIVE"),
        Emulated("EMULATED"),
        Paravirtualized("PARAVIRTUALIZED"),
        Custom("CUSTOM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LaunchMode> map;

        private LaunchMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LaunchMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LaunchMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LaunchMode.class);
            map = new HashMap<String, LaunchMode>();
            for (LaunchMode v : LaunchMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="baseImageId")
        private String baseImageId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="createImageAllowed")
        private Boolean createImageAllowed;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="launchMode")
        private LaunchMode launchMode;
        @JsonProperty(value="launchOptions")
        private LaunchOptions launchOptions;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="operatingSystem")
        private String operatingSystem;
        @JsonProperty(value="operatingSystemVersion")
        private String operatingSystemVersion;
        @JsonProperty(value="agentFeatures")
        private InstanceAgentFeatures agentFeatures;
        @JsonProperty(value="listingType")
        private ListingType listingType;
        @JsonProperty(value="sizeInMBs")
        private Long sizeInMBs;
        @JsonProperty(value="billableSizeInGBs")
        private Long billableSizeInGBs;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder baseImageId(String baseImageId) {
            this.baseImageId = baseImageId;
            this.__explicitlySet__.add("baseImageId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder createImageAllowed(Boolean createImageAllowed) {
            this.createImageAllowed = createImageAllowed;
            this.__explicitlySet__.add("createImageAllowed");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder launchMode(LaunchMode launchMode) {
            this.launchMode = launchMode;
            this.__explicitlySet__.add("launchMode");
            return this;
        }

        public Builder launchOptions(LaunchOptions launchOptions) {
            this.launchOptions = launchOptions;
            this.__explicitlySet__.add("launchOptions");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            this.__explicitlySet__.add("operatingSystemVersion");
            return this;
        }

        public Builder agentFeatures(InstanceAgentFeatures agentFeatures) {
            this.agentFeatures = agentFeatures;
            this.__explicitlySet__.add("agentFeatures");
            return this;
        }

        public Builder listingType(ListingType listingType) {
            this.listingType = listingType;
            this.__explicitlySet__.add("listingType");
            return this;
        }

        public Builder sizeInMBs(Long sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            this.__explicitlySet__.add("sizeInMBs");
            return this;
        }

        public Builder billableSizeInGBs(Long billableSizeInGBs) {
            this.billableSizeInGBs = billableSizeInGBs;
            this.__explicitlySet__.add("billableSizeInGBs");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Image build() {
            Image model = new Image(this.baseImageId, this.compartmentId, this.createImageAllowed, this.definedTags, this.displayName, this.freeformTags, this.id, this.launchMode, this.launchOptions, this.lifecycleState, this.operatingSystem, this.operatingSystemVersion, this.agentFeatures, this.listingType, this.sizeInMBs, this.billableSizeInGBs, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Image model) {
            if (model.wasPropertyExplicitlySet("baseImageId")) {
                this.baseImageId(model.getBaseImageId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("createImageAllowed")) {
                this.createImageAllowed(model.getCreateImageAllowed());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("launchMode")) {
                this.launchMode(model.getLaunchMode());
            }
            if (model.wasPropertyExplicitlySet("launchOptions")) {
                this.launchOptions(model.getLaunchOptions());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("operatingSystemVersion")) {
                this.operatingSystemVersion(model.getOperatingSystemVersion());
            }
            if (model.wasPropertyExplicitlySet("agentFeatures")) {
                this.agentFeatures(model.getAgentFeatures());
            }
            if (model.wasPropertyExplicitlySet("listingType")) {
                this.listingType(model.getListingType());
            }
            if (model.wasPropertyExplicitlySet("sizeInMBs")) {
                this.sizeInMBs(model.getSizeInMBs());
            }
            if (model.wasPropertyExplicitlySet("billableSizeInGBs")) {
                this.billableSizeInGBs(model.getBillableSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

