/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteRouteTableRequest
extends BmcRequest<Void> {
    private String rtId;
    private String ifMatch;

    public String getRtId() {
        return this.rtId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().rtId(this.rtId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",rtId=").append(String.valueOf(this.rtId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteRouteTableRequest)) {
            return false;
        }
        DeleteRouteTableRequest other = (DeleteRouteTableRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.rtId, other.rtId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.rtId == null ? 43 : this.rtId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteRouteTableRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String rtId = null;
        private String ifMatch = null;

        public Builder rtId(String rtId) {
            this.rtId = rtId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteRouteTableRequest o) {
            this.rtId(o.getRtId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteRouteTableRequest build() {
            DeleteRouteTableRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteRouteTableRequest buildWithoutInvocationCallback() {
            DeleteRouteTableRequest request = new DeleteRouteTableRequest();
            request.rtId = this.rtId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

