/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.platform;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.java.j2seembedded.platform.ConnectionMethod;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatform;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatformProbe;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardValidationException;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;

final class RemotePlatformNode
extends AbstractNode {
    public RemotePlatformNode(@NonNull RemotePlatform platform, @NonNull XMLDataObject store) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{platform, store}));
        Parameters.notNull((CharSequence)"platform", (Object)((Object)platform));
        Parameters.notNull((CharSequence)"store", (Object)store);
        this.setDisplayName(platform.getDisplayName());
        this.setIconBaseWithExtension("org/netbeans/modules/java/j2seembedded/resources/platform.gif");
    }

    protected Sheet createSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set setConnection = Sheet.createPropertiesSet();
        setConnection.setName(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_ConnectionProperties"));
        setConnection.setDisplayName(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_ConnectionProperties"));
        Object property = new PropertySupport.ReadOnly<String>(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_DisplayName"), String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_DisplayName"), NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_DisplayNameDesc")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return RemotePlatformNode.this.getPlatform().getDisplayName();
            }
        };
        setConnection.put((Node.Property)property);
        property = new PropertySupport.ReadWrite<String>(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Host"), String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Host"), NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_HostDesc")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return RemotePlatformNode.this.getPlatform().getConnectionMethod().getHost();
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (val == null) {
                    return;
                }
                RemotePlatformNode.this.updateConnectionMethod(val, null, null, null, null, null);
            }
        };
        setConnection.put((Node.Property)property);
        property = new PropertySupport.ReadWrite<Integer>(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Port"), Integer.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Port"), NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_PortDesc")){

            public Integer getValue() throws IllegalAccessException, InvocationTargetException {
                return RemotePlatformNode.this.getPlatform().getConnectionMethod().getPort();
            }

            public void setValue(Integer val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (val == null || val <= 0) {
                    return;
                }
                RemotePlatformNode.this.updateConnectionMethod(null, val, null, null, null, null);
            }

            public Class<Integer> getValueType() {
                return Integer.class;
            }
        };
        setConnection.put((Node.Property)property);
        property = new PropertySupport.ReadWrite<String>(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Username"), String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Username"), NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_UsernameDesc")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return RemotePlatformNode.this.getPlatform().getConnectionMethod().getAuthentification().getUserName();
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (val == null || val.isEmpty()) {
                    return;
                }
                RemotePlatformNode.this.updateConnectionMethod(null, null, val, null, null, null);
            }
        };
        setConnection.put((Node.Property)property);
        if (this.getPlatform().getConnectionMethod().getAuthentification().getKind() == ConnectionMethod.Authentification.Kind.PASSWORD) {
            property = new PropertySupport.ReadWrite<String>(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Password"), String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Password"), NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_PasswordDesc")){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return ((ConnectionMethod.Authentification.Password)RemotePlatformNode.this.getPlatform().getConnectionMethod().getAuthentification()).getPassword();
                }

                public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    if (val == null || val.isEmpty()) {
                        return;
                    }
                    RemotePlatformNode.this.updateConnectionMethod(null, null, null, val, null, null);
                }

                public PropertyEditor getPropertyEditor() {
                    return new PasswordPropertyEditor();
                }
            };
            setConnection.put((Node.Property)property);
        } else if (this.getPlatform().getConnectionMethod().getAuthentification().getKind() == ConnectionMethod.Authentification.Kind.KEY) {
            property = new PropertySupport.ReadWrite<File>(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Keyfile"), File.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Keyfile"), NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_KeyfileDesc")){

                public File getValue() throws IllegalAccessException, InvocationTargetException {
                    return ((ConnectionMethod.Authentification.Key)RemotePlatformNode.this.getPlatform().getConnectionMethod().getAuthentification()).getKeyStore();
                }

                public void setValue(File val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    if (val == null || !val.exists()) {
                        return;
                    }
                    RemotePlatformNode.this.updateConnectionMethod(null, null, null, null, val, null);
                }
            };
            setConnection.put((Node.Property)property);
            property = new PropertySupport.ReadWrite<String>(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Passphrase"), String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Passphrase"), NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_PassphraseDesc")){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return ((ConnectionMethod.Authentification.Key)RemotePlatformNode.this.getPlatform().getConnectionMethod().getAuthentification()).getPassPhrase();
                }

                public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    if (val == null) {
                        return;
                    }
                    RemotePlatformNode.this.updateConnectionMethod(null, null, null, null, null, val);
                }

                public PropertyEditor getPropertyEditor() {
                    return new PasswordPropertyEditor();
                }
            };
            setConnection.put((Node.Property)property);
        }
        sheet.put(setConnection);
        Sheet.Set setPlatform = Sheet.createPropertiesSet();
        setPlatform.setName(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_PlatformProperties"));
        setPlatform.setDisplayName(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_PlatformProperties"));
        property = new PropertySupport.ReadOnly<String>(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_InstallFolder"), String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_InstallFolder"), NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_InstallFolderDesc")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return RemotePlatformNode.this.getPlatform().getInstallFolder().getPath();
            }
        };
        setPlatform.put((Node.Property)property);
        property = new PropertySupport.ReadWrite<String>(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_ExecDecorator"), String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_ExecDecorator"), NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_ExecDecoratorDesc")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                String execDecorator = RemotePlatformNode.this.getPlatform().getExecDecorator();
                return execDecorator != null ? execDecorator : "";
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (val.isEmpty()) {
                    val = null;
                }
                RemotePlatformNode.this.getPlatform().setExecDecorator(val);
            }
        };
        setPlatform.put((Node.Property)property);
        property = new PropertySupport.ReadWrite<String>(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Workdir"), String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Workdir"), NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_WorkdirDesc")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return RemotePlatformNode.this.getPlatform().getWorkFolder().getPath();
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (val == null || val.isEmpty()) {
                    return;
                }
                URI modifiedURI = null;
                try {
                    modifiedURI = new URI(val);
                }
                catch (URISyntaxException ex) {
                    return;
                }
                RemotePlatformNode.this.getPlatform().setWorkFolder(modifiedURI);
            }
        };
        setPlatform.put((Node.Property)property);
        property = new PropertySupport.ReadOnly<String>("profile", String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_Profile"), NbBundle.getMessage(RemotePlatformNode.class, (String)"DESC_Profile")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                SourceLevelQuery.Profile profile = RemotePlatformNode.this.getPlatform().getProfile();
                return profile.getDisplayName();
            }
        };
        setPlatform.put((Node.Property)property);
        if (this.getPlatform().getExtensions() != null) {
            property = new PropertySupport.ReadOnly<String>("vm-extensions", String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_VmExtensions"), NbBundle.getMessage(RemotePlatformNode.class, (String)"DESC_VmExtensions")){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return RemotePlatformNode.this.getPlatform().getExtensions();
                }
            };
            setPlatform.put((Node.Property)property);
        }
        property = new PropertySupport.ReadOnly<Boolean>("vm-debug", Boolean.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_VmDebug"), NbBundle.getMessage(RemotePlatformNode.class, (String)"DESC_VmDebug")){

            public Boolean getValue() throws IllegalAccessException, InvocationTargetException {
                return RemotePlatformNode.this.getPlatform().canDebug();
            }
        };
        setPlatform.put((Node.Property)property);
        if (this.getPlatform().getVMType() != null) {
            property = new PropertySupport.ReadOnly<String>("vm-type", String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_VmType"), NbBundle.getMessage(RemotePlatformNode.class, (String)"DESC_VmType")){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return RemotePlatformNode.this.getPlatform().getVMType();
                }
            };
            setPlatform.put((Node.Property)property);
        }
        if (this.getPlatform().getVMTarget() != null) {
            property = new PropertySupport.ReadOnly<String>("vm-target", String.class, NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_VmTarget"), NbBundle.getMessage(RemotePlatformNode.class, (String)"DESC_VmTarget")){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return RemotePlatformNode.this.getPlatform().getVMTarget();
                }
            };
            setPlatform.put((Node.Property)property);
        }
        sheet.put(setPlatform);
        Sheet.Set setSysProperties = Sheet.createPropertiesSet();
        setSysProperties.setName(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_SysProperties"));
        setSysProperties.setDisplayName(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_SysProperties"));
        for (final Map.Entry entry : this.getPlatform().getSystemProperties().entrySet()) {
            property = new PropertySupport.ReadOnly<String>((String)entry.getKey(), String.class, (String)entry.getKey(), (String)entry.getKey()){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return (String)entry.getValue();
                }
            };
            setSysProperties.put((Node.Property)property);
        }
        sheet.put(setSysProperties);
        return sheet;
    }

    private void updateConnectionMethod(String host, Integer port, String username, String password, File keyFile, String passphrase) {
        ConnectionMethod cm = null;
        if (host == null) {
            host = this.getPlatform().getConnectionMethod().getHost();
        }
        if (port == null) {
            port = this.getPlatform().getConnectionMethod().getPort();
        }
        if (username == null) {
            username = this.getPlatform().getConnectionMethod().getAuthentification().getUserName();
        }
        if (this.getPlatform().getConnectionMethod().getAuthentification().getKind() == ConnectionMethod.Authentification.Kind.PASSWORD) {
            if (password == null) {
                password = ((ConnectionMethod.Authentification.Password)this.getPlatform().getConnectionMethod().getAuthentification()).getPassword();
            }
            cm = ConnectionMethod.sshPassword(host, port, username, password);
        } else {
            if (keyFile == null) {
                keyFile = ((ConnectionMethod.Authentification.Key)this.getPlatform().getConnectionMethod().getAuthentification()).getKeyStore();
            }
            if (passphrase == null) {
                passphrase = ((ConnectionMethod.Authentification.Key)this.getPlatform().getConnectionMethod().getAuthentification()).getPassPhrase();
            }
            cm = ConnectionMethod.sshKey(host, port, username, keyFile, passphrase);
        }
        this.getPlatform().setConnectionMethod(cm);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        JPanel customizer = new JPanel();
        customizer.setLayout(new GridBagLayout());
        PropertySheet sheet = new PropertySheet();
        sheet.setNodes(new Node[]{this});
        GridBagConstraints c = new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 6, 6, 6), 0, 0);
        customizer.add((Component)sheet, c);
        JButton test = new JButton(NbBundle.getMessage(RemotePlatformNode.class, (String)"LBL_TestPlatform"));
        test.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RemotePlatform rp = RemotePlatformNode.this.getPlatform();
                            RemotePlatformProbe.verifyPlatform(rp.getInstallFolder().toString(), rp.getExecDecorator(), rp.getWorkFolder().toString(), rp.getConnectionMethod(), null);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RemotePlatformNode.class, (String)"TXT_CorrectPlatform"), 1));
                        }
                        catch (WizardValidationException e) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 0));
                        }
                    }
                }, (String)NbBundle.getMessage(RemotePlatformNode.class, (String)"TXT_VerifyingPlatform"));
            }
        });
        c = new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 18, 0, new Insets(0, 6, 0, 6), 0, 0);
        customizer.add((Component)test, c);
        return customizer;
    }

    @NonNull
    private RemotePlatform getPlatform() {
        return (RemotePlatform)((Object)this.getLookup().lookup(RemotePlatform.class));
    }

    public static class PasswordPropertyEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor,
    InplaceEditor.Factory {
        private InplaceEditor editor;

        public void attachEnv(PropertyEnv env) {
            env.registerInplaceEditorFactory((InplaceEditor.Factory)this);
        }

        public InplaceEditor getInplaceEditor() {
            if (this.editor == null) {
                this.editor = new PasswordInplaceEditor();
            }
            return this.editor;
        }

        @Override
        public String getAsText() {
            if (this.getValue() == null) {
                return "";
            }
            String pass = (String)this.getValue();
            StringBuilder sb = new StringBuilder(pass.length());
            for (int i = 0; i < pass.length(); ++i) {
                sb.append("*");
            }
            return sb.toString();
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (text != null) {
                try {
                    this.setValue(text);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(text);
                }
            }
        }

        private class PasswordInplaceEditor
        implements InplaceEditor {
            private JPasswordField password = new JPasswordField();
            private PropertyEditor editor = null;
            private PropertyModel model;

            public PasswordInplaceEditor() {
                this.password.setEchoChar('*');
            }

            public void connect(PropertyEditor pe, PropertyEnv env) {
                this.editor = pe;
                this.reset();
            }

            public JComponent getComponent() {
                return this.password;
            }

            public void clear() {
                this.editor = null;
                this.model = null;
            }

            public Object getValue() {
                return String.valueOf(this.password.getPassword());
            }

            public void setValue(Object o) {
                if (o instanceof String) {
                    this.password.setText((String)o);
                }
            }

            public boolean supportsTextEntry() {
                return true;
            }

            public void reset() {
                String editorValue = (String)this.editor.getValue();
                if (editorValue != null) {
                    this.password.setText(editorValue);
                }
            }

            public void addActionListener(ActionListener al) {
            }

            public void removeActionListener(ActionListener al) {
            }

            public KeyStroke[] getKeyStrokes() {
                return new KeyStroke[0];
            }

            public PropertyEditor getPropertyEditor() {
                return this.editor;
            }

            public PropertyModel getPropertyModel() {
                return this.model;
            }

            public void setPropertyModel(PropertyModel pm) {
                this.model = pm;
            }

            public boolean isKnownComponent(Component c) {
                return c.equals(this.password) || this.password.isAncestorOf(c);
            }
        }
    }
}

