/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpdoc.ui.customizer;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.phpdoc.PhpDocumentorProvider;
import org.netbeans.modules.php.phpdoc.ui.PhpDocPreferences;
import org.netbeans.modules.php.phpdoc.ui.PhpDocPreferencesValidator;
import org.netbeans.modules.php.phpdoc.ui.customizer.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

final class PhpDocPanel
extends JPanel {
    private static final long serialVersionUID = -4686321547613435L;
    private final PhpModule phpModule;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton configurationBrowseButton;
    private JCheckBox configurationCheckBox;
    private JLabel configurationLabel;
    private JTextField configurationTextField;
    private JButton targetButton;
    private JLabel targetLabel;
    private JTextField targetTextField;
    private JLabel titleLabel;
    private JTextField titleTextField;

    PhpDocPanel(PhpModule phpModule) {
        assert (EventQueue.isDispatchThread());
        assert (phpModule != null);
        this.phpModule = phpModule;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.targetTextField.setText(PhpDocPreferences.getPhpDocTarget(this.phpModule, false));
        this.titleTextField.setText(PhpDocPreferences.getPhpDocTitle(this.phpModule));
        this.configurationTextField.setText(PhpDocPreferences.getPhpDocConfigurationPath(this.phpModule));
        this.configurationCheckBox.setSelected(PhpDocPreferences.isConfigurationEnabled(this.phpModule));
        this.enableComponents(this.configurationCheckBox.isSelected(), this.getConfigurationFileComponents());
        this.addListeners();
    }

    private void addListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.targetTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.titleTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.configurationTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.configurationCheckBox.addItemListener(e -> {
            this.enableComponents(e.getStateChange() == 1, this.getConfigurationFileComponents());
            this.fireChange();
        });
    }

    private JComponent[] getConfigurationFileComponents() {
        return new JComponent[]{this.configurationLabel, this.configurationTextField, this.configurationBrowseButton};
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private String getPhpDocTarget() {
        return this.targetTextField.getText().trim();
    }

    private String getPhpDocTitle() {
        return this.titleTextField.getText().trim();
    }

    private String getPhpDocConfigurationPath() {
        return this.configurationTextField.getText().trim();
    }

    private boolean isPhpDocConfigurationEnabled() {
        return this.configurationCheckBox.isSelected();
    }

    boolean isValidData() {
        ValidationResult result = this.getValidationResult();
        return !result.hasErrors();
    }

    public String getErrorMessage() {
        ValidationResult result = this.getValidationResult();
        ValidationResult.Message error = result.getFirstError();
        if (error != null) {
            return error.getMessage();
        }
        return null;
    }

    public String getWarningMessage() {
        ValidationResult result = this.getValidationResult();
        ValidationResult.Message warning = result.getFirstWarning();
        if (warning != null) {
            return warning.getMessage();
        }
        return null;
    }

    public void storeData() {
        PhpDocPreferences.setPhpDocTarget(this.phpModule, this.getPhpDocTarget());
        PhpDocPreferences.setPhpDocTitle(this.phpModule, this.getPhpDocTitle());
        PhpDocPreferences.setPhpDocConfigurationPath(this.phpModule, this.getPhpDocConfigurationPath());
        PhpDocPreferences.setConfigurationEnabled(this.phpModule, this.isPhpDocConfigurationEnabled());
    }

    private ValidationResult getValidationResult() {
        return new PhpDocPreferencesValidator().validateTarget(this.getPhpDocTarget()).validateTitle(this.getPhpDocTitle()).validateConfiguration(this.isPhpDocConfigurationEnabled(), this.getPhpDocConfigurationPath()).getResult();
    }

    void enableComponents(boolean enabled, JComponent ... components) {
        for (JComponent component : components) {
            component.setEnabled(enabled);
        }
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.targetLabel = new JLabel();
        this.targetTextField = new JTextField();
        this.targetButton = new JButton();
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.configurationCheckBox = new JCheckBox();
        this.configurationLabel = new JLabel();
        this.configurationTextField = new JTextField();
        this.configurationBrowseButton = new JButton();
        this.targetLabel.setLabelFor(this.targetTextField);
        Mnemonics.setLocalizedText((JLabel)this.targetLabel, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.targetLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.targetButton, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.targetButton.text"));
        this.targetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpDocPanel.this.targetButtonActionPerformed(evt);
            }
        });
        this.titleLabel.setLabelFor(this.titleTextField);
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.titleLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configurationCheckBox, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.configurationCheckBox.text"));
        this.configurationLabel.setLabelFor(this.configurationTextField);
        Mnemonics.setLocalizedText((JLabel)this.configurationLabel, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.configurationLabel.text"));
        this.configurationTextField.setText(NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.configurationTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configurationBrowseButton, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.configurationBrowseButton.text"));
        this.configurationBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpDocPanel.this.configurationBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.targetLabel).addComponent(this.titleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.targetTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetButton)).addComponent(this.titleTextField))).addGroup(layout.createSequentialGroup().addComponent(this.configurationCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.configurationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationBrowseButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetLabel).addComponent(this.targetTextField, -2, -1, -2).addComponent(this.targetButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.configurationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configurationLabel).addComponent(this.configurationTextField, -2, -1, -2).addComponent(this.configurationBrowseButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void targetButtonActionPerformed(ActionEvent evt) {
        File phpDocTarget = new FileChooserBuilder(PhpDocumentorProvider.class.getName() + ".phpdoc.dir" + this.phpModule.getName()).setTitle(NbBundle.getMessage(PhpDocPanel.class, (String)"LBL_SelectDocFolder")).setDirectoriesOnly(true).setFileHiding(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory())).showOpenDialog();
        if (phpDocTarget != null) {
            phpDocTarget = FileUtil.normalizeFile((File)phpDocTarget);
            this.targetTextField.setText(phpDocTarget.getAbsolutePath());
        }
    }

    private void configurationBrowseButtonActionPerformed(ActionEvent evt) {
        File configurationFile = new FileChooserBuilder(PhpDocumentorProvider.class.getName() + ".phpdoc.dir" + this.phpModule.getName()).setTitle(Bundle.PhpDocPanel_chooser_configuration()).setFilesOnly(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory())).showOpenDialog();
        if (configurationFile != null) {
            configurationFile = FileUtil.normalizeFile((File)configurationFile);
            this.configurationTextField.setText(configurationFile.getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            PhpDocPanel.this.fireChange();
        }
    }
}

