/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.impl.DefaultInstancePropertiesImpl;
import org.netbeans.modules.j2ee.deployment.impl.DeletableInstanceProperties;
import org.netbeans.modules.j2ee.deployment.impl.MemoryInstancePropertiesImpl;
import org.netbeans.modules.j2ee.deployment.impl.ProgressObjectUtil;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.deployment.plugins.spi.AntDeploymentProvider;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.j2ee.deployment.plugins.spi.FindJSPServlet;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.j2ee.deployment.plugins.spi.MessageDestinationDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerInstanceDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryManager;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.deployment.plugins.spi.TargetModuleIDResolver;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.InputOutput;

public class ServerInstance
implements Node.Cookie,
Comparable {
    public static final int STATE_WAITING = 1;
    public static final int STATE_STOPPED = 2;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_DEBUGGING = 4;
    public static final int STATE_SUSPENDED = 5;
    public static final int STATE_PROFILING = 6;
    public static final int STATE_PROFILER_BLOCKING = 7;
    public static final int STATE_PROFILER_STARTING = 8;
    private static final int RUNNING_CHECK_TIMEOUT = 10000;
    private static final int DEBUGGING_CHECK_TIMEOUT = 10000;
    private static final long DEFAULT_TIMEOUT = 1200000L;
    private static final Logger LOGGER = Logger.getLogger(ServerInstance.class.getName());
    private static final RequestProcessor REFRESH_PROCESSOR = new RequestProcessor("Java EE server registry refresh", 5);
    private static final RequestProcessor DEBUGGER_STATE_PROCESSOR = new RequestProcessor("Java EE server debugger state", 1);
    private final String url;
    private final Server server;
    private final boolean nonPeristent;
    private DeploymentManager manager;
    private DeploymentManager disconnectedManager;
    private IncrementalDeployment incrementalDeployment;
    private ServerInstanceDescriptor instanceDescriptor;
    private TargetModuleIDResolver tmidResolver;
    private J2eePlatform j2eePlatform;
    private J2eePlatformImpl j2eePlatformImpl;
    private StartServer startServer;
    private FindJSPServlet findJSPServlet;
    private ServerLibraryManager libraryManager;
    private ServerLibraryManager disconnectedLibraryManager;
    private DatasourceManager dsMgr;
    private DatasourceManager ddsMgr;
    private MessageDestinationDeployment msgDestDeploymentConnected;
    private MessageDestinationDeployment msgDestDeploymentDisconnected;
    private final Set<String> targetsStartedByIde = new HashSet<String>();
    private Map targets;
    private boolean managerStartedByIde = false;
    private ServerTarget coTarget = null;
    private final DeletableInstanceProperties instanceProperties;
    private final HashMap debugInfo = new HashMap();
    private volatile int serverState = 2;
    private final List<StateListener> stateListeners = new CopyOnWriteArrayList<StateListener>();
    private long lastCheck = 0L;
    private boolean isRunning = false;
    private final ChangeSupport managerChangeSupport = new ChangeSupport((Object)this);
    private static AtomicReference<ServerInstance> profiledServerInstance = new AtomicReference();
    private final DebuggerStateListener debuggerStateListener;

    public ServerInstance(Server server, String url, boolean nonPersistent) {
        this.server = server;
        this.url = url;
        this.nonPeristent = nonPersistent;
        this.instanceProperties = nonPersistent ? new MemoryInstancePropertiesImpl(url) : new DefaultInstancePropertiesImpl(url);
        this.debuggerStateListener = new DebuggerStateListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(LazyDebuggerManagerListener.class, (EventListener)((Object)this.debuggerStateListener), (Object)DebuggerManager.getDebuggerManager()));
    }

    public InstanceProperties getInstanceProperties() {
        return this.instanceProperties;
    }

    public String getDisplayName() {
        return this.instanceProperties.getProperty("displayName");
    }

    public void addManagerChangeListener(ChangeListener listener) {
        this.managerChangeSupport.addChangeListener(listener);
    }

    public void removeManagerChangeListener(ChangeListener listener) {
        this.managerChangeSupport.removeChangeListener(listener);
    }

    private long getTimeout(String propName, long defaultValue) {
        long returnValue = defaultValue;
        String timeout = this.instanceProperties.getProperty(propName);
        if (timeout != null) {
            try {
                returnValue = Long.parseLong(timeout) * 1000L;
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINE, "could not parse timeout property", e);
            }
        }
        return returnValue;
    }

    private long getStartupTimeout() {
        return this.getTimeout("startupTimeout", 1200000L);
    }

    private long getShutdownTimeout() {
        return this.getTimeout("shutdownTimeout", 1200000L);
    }

    long getDeploymentTimeout() {
        return this.getTimeout("deploymentTimeout", 1200000L);
    }

    public Server getServer() {
        return this.server;
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDeploymentManager() {
        DeploymentManager managerTmp = null;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            managerTmp = this.manager;
        }
        if (managerTmp != null) {
            return managerTmp;
        }
        try {
            if (this.instanceProperties.isDeleted()) {
                String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_InstanceNotExists", (Object)this.url);
                throw new IllegalStateException(msg);
            }
            String username = this.instanceProperties.getProperty("username");
            String password = this.nonPeristent ? this.instanceProperties.getProperty("password") : ServerRegistry.readPassword(this.url);
            managerTmp = this.server.getDeploymentManager(this.url, username, password);
            boolean fire = false;
            ServerInstance serverInstance2 = this;
            synchronized (serverInstance2) {
                fire = this.manager != managerTmp;
                this.manager = managerTmp;
            }
            if (fire) {
                this.firePossibleManagerChange();
            }
        }
        catch (DeploymentManagerCreationException e) {
            throw new RuntimeException(e);
        }
        return managerTmp;
    }

    public synchronized boolean isConnected() {
        return this.manager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDisconnectedDeploymentManager() throws DeploymentManagerCreationException {
        DeploymentManager disconnectedManagerTmp = null;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            disconnectedManagerTmp = this.disconnectedManager;
        }
        if (disconnectedManagerTmp != null) {
            return disconnectedManagerTmp;
        }
        if (this.instanceProperties.isDeleted()) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_InstanceNotExists", (Object)this.url);
            throw new DeploymentManagerCreationException(msg);
        }
        disconnectedManagerTmp = this.server.getDisconnectedDeploymentManager(this.url);
        boolean fire = false;
        ServerInstance serverInstance2 = this;
        synchronized (serverInstance2) {
            fire = this.manager == null && this.disconnectedManager != disconnectedManagerTmp;
            this.disconnectedManager = disconnectedManagerTmp;
        }
        if (fire) {
            this.firePossibleManagerChange();
        }
        return disconnectedManagerTmp;
    }

    public J2eePlatform getJ2eePlatform() {
        return this.j2eePlatform;
    }

    public void setJ2eePlatform(J2eePlatform aJ2eePlatform) {
        this.j2eePlatform = aJ2eePlatform;
    }

    public J2eePlatformImpl getJ2eePlatformImpl() {
        block3: {
            J2eePlatformFactory fact;
            if (this.j2eePlatformImpl == null && (fact = this.server.getJ2eePlatformFactory()) != null) {
                try {
                    this.j2eePlatformImpl = fact.getJ2eePlatformImpl(this.isConnected() ? this.getDeploymentManager() : this.getDisconnectedDeploymentManager());
                }
                catch (DeploymentManagerCreationException dmce) {
                    if (this.instanceProperties.isDeleted()) break block3;
                    Exceptions.printStackTrace((Throwable)dmce);
                }
            }
        }
        return this.j2eePlatformImpl;
    }

    public ServerDebugInfo getServerDebugInfo(Target target) {
        assert (this.debugInfo != null);
        ServerDebugInfo sdi = null;
        if (target == null) {
            sdi = (ServerDebugInfo)this.debugInfo.get(null);
        } else {
            Iterator it = this.debugInfo.keySet().iterator();
            while (sdi == null && it.hasNext()) {
                Target t = (Target)it.next();
                if (t != target && (t == null || !t.getName().equals(target.getName()))) continue;
                sdi = (ServerDebugInfo)this.debugInfo.get(t);
            }
        }
        return sdi;
    }

    public void refresh() {
        REFRESH_PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                try {
                    int oldState = ServerInstance.this.getServerState();
                    ServerInstance.this.setServerState(1);
                    if (ServerInstance.this == profiledServerInstance.get()) {
                        ServerInstance.this.updateStateFromProfiler();
                        return;
                    }
                    if (ServerInstance.this.isSuspended()) {
                        ServerInstance.this.setServerState(5);
                    } else if (ServerInstance.this.isDebuggable(null)) {
                        if (oldState != 5) {
                            ServerInstance.this.reset();
                        }
                        ServerInstance.this.initCoTarget();
                        ServerInstance.this.setServerState(4);
                    } else if (ServerInstance.this.isReallyRunning()) {
                        ServerInstance.this.reset();
                        ServerInstance.this.initCoTarget();
                        ServerInstance.this.setServerState(3);
                    } else {
                        ServerInstance.this.reset();
                        ServerInstance.this.setServerState(2);
                    }
                }
                catch (RuntimeException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
                finally {
                    if (ServerInstance.this.getServerState() == 1) {
                        ServerInstance.this.setServerState(2);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DeploymentManager managerTmp = null;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            managerTmp = this.manager;
            this.manager = null;
            this.disconnectedManager = null;
            this.incrementalDeployment = null;
            this.tmidResolver = null;
            this.startServer = null;
            this.findJSPServlet = null;
            this.coTarget = null;
            this.targets = null;
        }
        this.firePossibleManagerChange();
        if (managerTmp != null) {
            managerTmp.release();
        }
    }

    public void remove() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)this.debuggerStateListener);
        this.stopIfStartedByIde();
        if (this.getUrl() != null) {
            InputOutput io = UISupport.getServerIO(this.url);
            if (io != null && !io.isClosed()) {
                io.closeInputOutput();
            }
            ServerRegistry.getInstance().removeServerInstance(this.getUrl());
        } else {
            LOGGER.log(Level.WARNING, "Trying to remove {0}, but url is null", this.server != null ? this.server.getShortName() : null);
        }
    }

    public void stopIfStartedByIde() {
        if (this.managerStartedByIde) {
            if (this.canStopDontWait()) {
                this.stopDontWait();
            } else {
                String title = NbBundle.getMessage(ServerInstance.class, (String)"LBL_ShutDownServer", (Object)this.getDisplayName());
                final ProgressUI progressUI = new ProgressUI(title, true, null);
                progressUI.start();
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Iterator it = ServerInstance.this.targetsStartedByIde.iterator();
                            while (it.hasNext()) {
                                ServerTarget serverTarget = ServerInstance.this.getServerTarget((String)it.next());
                                if (serverTarget == null) continue;
                                try {
                                    ServerInstance.this._stop(serverTarget.getTarget(), progressUI);
                                }
                                catch (ServerException ex) {
                                    Logger.getLogger("global").log(Level.INFO, null, ex);
                                }
                            }
                            if (ServerInstance.this.isReallyRunning() || ServerInstance.this.isSuspended()) {
                                try {
                                    ServerInstance.this._stop(progressUI);
                                }
                                catch (ServerException ex) {
                                    Logger.getLogger("global").log(Level.INFO, null, ex);
                                }
                            }
                        }
                        finally {
                            progressUI.finish();
                        }
                    }
                });
                progressUI.showProgressDialog();
            }
        }
    }

    public void setServerState(int newState) {
        int oldState = this.serverState;
        this.serverState = newState;
        this.fireStateChanged(oldState, newState);
    }

    public int getServerState() {
        return this.serverState;
    }

    public boolean isRemoveForbidden() {
        String removeForbid = this.instanceProperties.getProperty("removeForbidden");
        return Boolean.valueOf(removeForbid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTarget[] getTargets() {
        Map targets = this.getTargetMap();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            return targets.values().toArray(new ServerTarget[targets.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTargetList() {
        Map targets = this.getTargetMap();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            return targets.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getTargetMap() {
        HashMap<String, ServerTarget> tmpTargets = null;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            tmpTargets = this.targets;
        }
        if (tmpTargets == null || tmpTargets.size() < 1) {
            Target[] targs = null;
            StartServer startServer = this.getStartServer();
            try {
                if (!this.isRunning() && startServer != null && startServer.needsStartForTargetList() && ProfilerSupport.getState() == 0) {
                    this.start();
                }
                do {
                    if ((targs = this.getDeploymentManager().getTargets()) != null || ProfilerSupport.getState() != 4) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                } while (targs == null && ProfilerSupport.getState() == 4);
            }
            catch (IllegalStateException e) {
                LOGGER.log(Level.INFO, null, e);
            }
            if (targs == null) {
                targs = new Target[]{};
            }
            tmpTargets = new HashMap<String, ServerTarget>();
            for (int i = 0; i < targs.length; ++i) {
                tmpTargets.put(targs[i].getName(), new ServerTarget(this, targs[i]));
            }
            ServerInstance serverInstance2 = this;
            synchronized (serverInstance2) {
                this.targets = tmpTargets;
            }
        }
        return tmpTargets;
    }

    public ServerTarget getServerTarget(String targetName) {
        return (ServerTarget)this.getTargetMap().get(targetName);
    }

    public Target getTarget(String targetName) {
        return this.getServerTarget(targetName).getTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartServer getStartServer() {
        DeploymentManager dm = null;
        try {
            dm = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException dmce) {
            Logger.getLogger(ServerInstance.class.getName()).log(Level.INFO, null, dmce);
            return null;
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.startServer == null) {
                this.startServer = this.server.getOptionalFactory().getStartServer(dm);
            }
            return this.startServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalDeployment getIncrementalDeployment() {
        DeploymentManager dm = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.incrementalDeployment == null) {
                this.incrementalDeployment = this.server.getOptionalFactory().getIncrementalDeployment(dm);
            }
            return this.incrementalDeployment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInstanceDescriptor getServerInstanceDescriptor() {
        DeploymentManager dm = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.instanceDescriptor == null) {
                this.instanceDescriptor = this.server.getOptionalFactory().getServerInstanceDescriptor(dm);
            }
            return this.instanceDescriptor;
        }
    }

    public AntDeploymentProvider getAntDeploymentProvider() {
        try {
            return this.server.getOptionalFactory().getAntDeploymentProvider(this.getDisconnectedDeploymentManager());
        }
        catch (DeploymentManagerCreationException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
            return null;
        }
    }

    public JDBCDriverDeployer getJDBCDriverDeployer() {
        try {
            return this.server.getOptionalFactory().getJDBCDriverDeployer(this.getDisconnectedDeploymentManager());
        }
        catch (DeploymentManagerCreationException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleIDResolver getTargetModuleIDResolver() {
        DeploymentManager dm = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.tmidResolver == null) {
                this.tmidResolver = this.server.getOptionalFactory().getTargetModuleIDResolver(dm);
            }
            return this.tmidResolver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FindJSPServlet getFindJSPServlet() {
        DeploymentManager dm = null;
        try {
            dm = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException dmce) {
            throw new RuntimeException(dmce);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.findJSPServlet == null) {
                this.findJSPServlet = this.server.getOptionalFactory().getFindJSPServlet(dm);
            }
            return this.findJSPServlet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasourceManager getDatasourceManager() {
        DeploymentManager dm = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.dsMgr == null) {
                this.dsMgr = this.server.getOptionalFactory().getDatasourceManager(dm);
            }
            return this.dsMgr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasourceManager getDisconnectedDatasourceManager() {
        DeploymentManager dm = null;
        try {
            dm = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException dmce) {
            throw new RuntimeException(dmce);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.ddsMgr == null) {
                this.ddsMgr = this.server.getOptionalFactory().getDatasourceManager(dm);
            }
            return this.ddsMgr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerLibraryManager getServerLibraryManager() {
        DeploymentManager dm = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.libraryManager == null) {
                this.libraryManager = this.server.getOptionalFactory().getServerLibraryManager(dm);
            }
            return this.libraryManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerLibraryManager getDisconnectedServerLibraryManager() {
        DeploymentManager dm = null;
        try {
            dm = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException dmce) {
            throw new RuntimeException(dmce);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.disconnectedLibraryManager == null) {
                this.disconnectedLibraryManager = this.server.getOptionalFactory().getServerLibraryManager(dm);
            }
            return this.disconnectedLibraryManager;
        }
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        DatasourceManager ddsMgr = this.getDisconnectedDatasourceManager();
        Set<Datasource> deployedDS = Collections.emptySet();
        if (ddsMgr != null) {
            deployedDS = ddsMgr.getDatasources();
        }
        return deployedDS;
    }

    public void deployDatasources(Set<Datasource> datasources) throws ConfigurationException, DatasourceAlreadyExistsException {
        if (datasources.isEmpty()) {
            return;
        }
        DatasourceManager dsMgr = this.getDatasourceManager();
        if (dsMgr != null) {
            dsMgr.deployDatasources(datasources);
        }
    }

    public boolean isServerLibraryManagementSupported() {
        return this.getDisconnectedServerLibraryManager() != null;
    }

    public Set<ServerLibrary> getDeployableLibraries() {
        ServerLibraryManager libraryManager = this.getDisconnectedServerLibraryManager();
        Set<ServerLibrary> libraries = Collections.emptySet();
        if (libraryManager != null) {
            libraries = libraryManager.getDeployableLibraries();
        }
        return libraries;
    }

    public Set<ServerLibrary> getDeployedLibraries() {
        ServerLibraryManager libraryManager = this.getDisconnectedServerLibraryManager();
        Set<ServerLibrary> libraries = Collections.emptySet();
        if (libraryManager != null) {
            libraries = libraryManager.getDeployedLibraries();
        }
        return libraries;
    }

    public Set<ServerLibraryDependency> getDeployableDependencies(@NonNull Set<ServerLibraryDependency> dependencies) {
        ServerLibraryManager libraryManager = this.getDisconnectedServerLibraryManager();
        Set<ServerLibraryDependency> result = Collections.emptySet();
        if (libraryManager != null) {
            result = libraryManager.getDeployableDependencies(dependencies);
        }
        return result;
    }

    public Set<ServerLibraryDependency> getMissingDependencies(@NonNull Set<ServerLibraryDependency> dependencies) {
        ServerLibraryManager libraryManager = this.getDisconnectedServerLibraryManager();
        Set<ServerLibraryDependency> result = Collections.emptySet();
        if (libraryManager != null) {
            result = libraryManager.getMissingDependencies(dependencies);
        }
        return result;
    }

    public void deployLibraries(Set<ServerLibraryDependency> libraries) throws ConfigurationException {
        if (libraries.isEmpty()) {
            return;
        }
        ServerLibraryManager libraryManager = this.getServerLibraryManager();
        if (libraryManager != null) {
            StartServer ss = this.getStartServer();
            if (ss != null && !ss.isRunning() && ss.needsStartForAdminConfig()) {
                this.start();
            }
            libraryManager.deployLibraries(libraries);
        }
    }

    private synchronized MessageDestinationDeployment getMessageDestinationDeploymentConnected() {
        if (this.msgDestDeploymentConnected == null) {
            this.msgDestDeploymentConnected = this.server.getOptionalFactory().getMessageDestinationDeployment(this.getDeploymentManager());
        }
        return this.msgDestDeploymentConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageDestinationDeployment getMessageDestinationDeploymentDisconnected() {
        DeploymentManager dm = null;
        try {
            dm = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException dmce) {
            throw new RuntimeException(dmce);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.msgDestDeploymentDisconnected == null) {
                this.msgDestDeploymentDisconnected = this.server.getOptionalFactory().getMessageDestinationDeployment(dm);
            }
            return this.msgDestDeploymentDisconnected;
        }
    }

    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        MessageDestinationDeployment destDepl = this.getMessageDestinationDeploymentDisconnected();
        if (destDepl != null) {
            return destDepl.getMessageDestinations();
        }
        return Collections.emptySet();
    }

    public void deployMessageDestinations(Set<MessageDestination> destinations) throws ConfigurationException {
        Parameters.notNull((CharSequence)"destinations", destinations);
        if (destinations.isEmpty()) {
            return;
        }
        MessageDestinationDeployment destDepl = this.getMessageDestinationDeploymentConnected();
        if (destDepl != null) {
            destDepl.deployMessageDestinations(destinations);
        }
    }

    public boolean isRunningLastCheck() {
        if (this.lastCheck > 0L) {
            return this.isRunning;
        }
        return false;
    }

    public boolean isReallyRunning() {
        return this.isRunningWithinMillis(0L);
    }

    public boolean isRunning() {
        return this.isRunningWithinMillis(2000L);
    }

    public boolean isRunningWithinMillis(long millisecs) {
        if (System.currentTimeMillis() - this.lastCheck < millisecs) {
            return this.isRunning;
        }
        final StartServer ss = this.getStartServer();
        this.isRunning = ss != null ? this.safeTrueTest(new SafeTrueTest(){

            @Override
            public void run() {
                this.setResult(ss.isRunning());
            }
        }, 10000L) : false;
        this.lastCheck = System.currentTimeMillis();
        return this.isRunning;
    }

    public boolean isDebuggable(final Target target) {
        final StartServer ss = this.getStartServer();
        if (ss != null) {
            return this.safeTrueTest(new SafeTrueTest(){

                @Override
                public void run() {
                    this.setResult(ss.isDebuggable(target));
                }
            }, 10000L);
        }
        return false;
    }

    public ConflictData anotherServerDebuggable(Target target) {
        Target t;
        ConflictData cd = null;
        StartServer thisSS = this.getStartServer();
        if (thisSS == null) {
            return null;
        }
        ServerDebugInfo thisSDI = this.getServerDebugInfo(target);
        if (thisSDI == null && (thisSDI = thisSS.getDebugInfo(t = this._retrieveTarget(target))) == null) {
            LOGGER.log(Level.FINE, "DebuggerInfo cannot be found for: " + this.toString());
            return null;
        }
        ServerInstance[] serverInstances = ServerRegistry.getInstance().getServerInstances();
        for (int i = 0; cd == null && i < serverInstances.length; ++i) {
            Target t2;
            ServerDebugInfo sdi;
            ServerInstance si = serverInstances[i];
            if (this.url.equalsIgnoreCase(si.getUrl()) || !si.isDebuggable(null) || (sdi = si.getServerDebugInfo(t2 = si._retrieveTarget(null))) == null || !thisSDI.getTransport().equals(sdi.getTransport())) continue;
            if (thisSDI.getTransport() == "dt_socket") {
                if (!thisSDI.getHost().equalsIgnoreCase(sdi.getHost()) || thisSDI.getPort() != sdi.getPort()) continue;
                cd = new ConflictData(si, thisSDI);
                continue;
            }
            if (!thisSDI.getShmemName().equalsIgnoreCase(sdi.getShmemName())) continue;
            cd = new ConflictData(si, thisSDI);
        }
        return cd;
    }

    private JPDADebugger getDebugger() {
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        Target target = this._retrieveTarget(null);
        ServerDebugInfo sdi = this.getServerDebugInfo(target);
        if (sdi == null) {
            LOGGER.log(Level.FINE, "DebuggerInfo cannot be found for: " + this.toString());
            return null;
        }
        for (int i = 0; i < sessions.length; ++i) {
            String host;
            Object d;
            String shmem;
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attCookie = (AttachingDICookie)o;
            if (!(sdi.getTransport().equals("dt_shmem") ? (shmem = attCookie.getSharedMemoryName()) != null && shmem.equalsIgnoreCase(sdi.getShmemName()) && (d = s.lookupFirst(null, JPDADebugger.class)) != null : (host = attCookie.getHostName()) != null && this.isSameHost(host, sdi.getHost()) && attCookie.getPortNumber() == sdi.getPort() && (d = s.lookupFirst(null, JPDADebugger.class)) != null)) continue;
            return (JPDADebugger)d;
        }
        return null;
    }

    public boolean isSuspended() {
        JPDADebugger jpda = this.getDebugger();
        if (jpda == null) {
            return false;
        }
        return jpda.getState() == 3;
    }

    public boolean isDebugSupported() {
        StartServer ss = this.getStartServer();
        if (ss == null) {
            return false;
        }
        return ss.supportsStartDebugging(null) || ss.isDebuggable(null);
    }

    public boolean isDebugStartSupported() {
        StartServer ss = this.getStartServer();
        if (ss == null) {
            return false;
        }
        return ss.supportsStartDebugging(null);
    }

    public boolean isProfileSupported() {
        Profiler profiler = ServerRegistry.getProfiler();
        if (profiler == null) {
            return false;
        }
        StartServer ss = this.getStartServer();
        if (ss == null) {
            return false;
        }
        return ss.supportsStartProfiling(null);
    }

    public Set getTargetsStartedByIde() {
        HashSet<ServerTarget> ret = new HashSet<ServerTarget>();
        for (String targetName : this.targetsStartedByIde) {
            ret.add(this.getServerTarget(targetName));
        }
        return ret;
    }

    public void start(ProgressUI ui) throws ServerException {
        try {
            this.setServerState(1);
            this.startTarget(null, ui);
        }
        finally {
            this.refresh();
        }
    }

    public void startDebug(ProgressUI ui) throws ServerException {
        try {
            this.setServerState(1);
            this.startTarget(null, ui, Deployment.Mode.DEBUG);
            this._retrieveDebugInfo(null);
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProfile(boolean forceRestart, ProgressUI ui) throws ServerException {
        ServerInstance tmpProfiledServerInstance = profiledServerInstance.get();
        if (tmpProfiledServerInstance != null && tmpProfiledServerInstance != this) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerProfiling", (Object)tmpProfiledServerInstance.getDisplayName());
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 2);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.CANCEL_OPTION) {
                String err = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ProfilingCancelled", (Object)this.getDisplayName());
                throw new ServerException(err);
            }
        }
        try {
            this.setServerState(1);
            this._startProfile(null, forceRestart, ui);
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(ProgressUI ui) throws ServerException {
        try {
            this.setServerState(1);
            boolean inDebug = this.isDebuggable(null);
            boolean inProfile = profiledServerInstance.get() == this;
            boolean stopped = true;
            if (inProfile || this.isReallyRunning() || this.isSuspended()) {
                this._stop(ui);
            }
            if (stopped) {
                if (inProfile) {
                    this._startProfile(null, true, ui);
                } else if (inDebug) {
                    this.startDebugTarget(null, ui);
                } else {
                    this.startTarget(null, ui);
                }
            }
        }
        finally {
            this.refresh();
        }
    }

    public void stop(ProgressUI ui) throws ServerException {
        try {
            this.setServerState(1);
            if (profiledServerInstance.get() == this || this.isReallyRunning() || this.isSuspended()) {
                this._stop(ui);
            }
            this.debugInfo.clear();
        }
        finally {
            this.refresh();
        }
    }

    public DeploymentManager getDeploymentManagerForConfiguration() throws DeploymentManagerCreationException {
        StartServer ss = this.getStartServer();
        if (ss != null && ss.needsStartForConfigure()) {
            this.start();
            return this.getDeploymentManager();
        }
        return this.getDisconnectedDeploymentManager();
    }

    public void startTarget(Target target, ProgressUI ui) throws ServerException {
        this.startTarget(target, ui, Deployment.Mode.RUN);
    }

    public void startDebugTarget(Target target, ProgressUI ui) throws ServerException {
        this.startTarget(target, ui, Deployment.Mode.DEBUG);
        this._retrieveDebugInfo(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ServerInstance.this.start();
                }
            });
            return;
        }
        if (this.isRunning()) {
            return;
        }
        String title = NbBundle.getMessage(ServerInstance.class, (String)"LBL_StartServerProgressMonitor", (Object)this.getDisplayName());
        ProgressUI ui = new ProgressUI(title, false);
        try {
            ui.start();
            this.start(ui);
        }
        catch (ServerException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        finally {
            ui.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startProfile(boolean forceRestart, Deployment.Logger logger) {
        String title = NbBundle.getMessage(ServerInstance.class, (String)"LBL_StartServerInProfileMode", (Object)this.getDisplayName());
        ProgressUI ui = new ProgressUI(title, false, logger);
        try {
            ui.start();
            this.startProfile(forceRestart, ui);
            boolean bl = true;
            return bl;
        }
        catch (ServerException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            ui.finish();
        }
    }

    public void stopDontWait() {
        if (this.isReallyRunning()) {
            StartServer startServ = this.getStartServer();
            assert (startServ.canStopDeploymentManagerSilently()) : "server does not support silent stop of deployment manager";
            startServ.stopDeploymentManagerSilently();
        }
    }

    public boolean canStopDontWait() {
        StartServer startServ = this.getStartServer();
        return startServ.canStopDeploymentManagerSilently();
    }

    private void resolveServerConflict(Target target, ProgressUI ui, ConflictData cd) throws ServerException {
        ServerInstance si = cd.getServerInstance();
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerRunning", (Object[])new Object[]{si.getDisplayName(), cd.getServerDebugInfo().getHost(), cd.getServerDebugInfo().getTransport().equals("dt_socket") ? "socket" : "shared memory", cd.getServerDebugInfo().getTransport().equals("dt_socket") ? Integer.toString(cd.getServerDebugInfo().getPort()) : cd.getServerDebugInfo().getShmemName()}), 3);
        nd.setOptionType(2);
        JButton yes = new JButton(NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerStopYes"));
        JButton no = new JButton(NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerStopNo"));
        yes.setDefaultCapable(true);
        nd.setOptions(new Object[]{yes, no});
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (option != yes) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ServerStartupCancelled", (Object)this.getDisplayName());
            throw new ServerException(msg);
        }
        if (!si.getStartServer().supportsStartDeploymentManager()) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingThisServerNotSupported", (Object)this.getDisplayName());
            throw new ServerException(msg);
        }
        si.stop(ui);
    }

    private void startTarget(Target target, ProgressUI ui, Deployment.Mode mode) throws ServerException {
        StartServer ss = this.getStartServer();
        if (ss == null) {
            ui.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_PluginHasNoStartServerClass", (Object)this.getServer()));
            return;
        }
        if (this.isSuspended()) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ServerSuspended", (Object)this.getServer());
            throw new ServerException(msg);
        }
        boolean canControlAdmin = ss.supportsStartDeploymentManager();
        boolean canDebug = ss.supportsStartDebugging(target);
        boolean needsRestart = ss.needsRestart(target);
        if (ss.isAlsoTargetServer(target)) {
            switch (mode) {
                case PROFILE: {
                    assert (false);
                    break;
                }
                case DEBUG: {
                    if (ss.isDebuggable(target)) {
                        if (!needsRestart) {
                            return;
                        }
                        if (!canControlAdmin || !canDebug) {
                            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_RestartingThisServerNotSupported", (Object)this.getDisplayName());
                            throw new ServerException(msg);
                        }
                        this._stop(ui);
                    } else if (this.isReallyRunning()) {
                        if (!canControlAdmin || !canDebug) {
                            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_DebugginThisServerNotSupported", (Object)this.getDisplayName());
                            throw new ServerException(msg);
                        }
                        this._stop(ui);
                    }
                    if (!canDebug) {
                        String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_DebugginThisServerNotSupported", (Object)this.getDisplayName());
                        throw new ServerException(msg);
                    }
                    ConflictData cd = this.anotherServerDebuggable(target);
                    if (cd != null) {
                        this.resolveServerConflict(target, ui, cd);
                    }
                    this._startDebug(target, ui);
                    break;
                }
                case RUN: {
                    if (this.isReallyRunning()) {
                        if (!needsRestart) {
                            return;
                        }
                        if (!canControlAdmin) {
                            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_RestartingThisServerNotSupported", (Object)this.getDisplayName());
                            throw new ServerException(msg);
                        }
                        this._stop(ui);
                    }
                    if (!canControlAdmin) {
                        String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingThisServerNotSupported", (Object)this.getDisplayName());
                        throw new ServerException(msg);
                    }
                    this._start(ui);
                }
            }
        } else {
            if (!this.isReallyRunning()) {
                if (!canControlAdmin) {
                    String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingThisServerNotSupported", (Object)this.getDisplayName());
                    throw new ServerException(msg);
                }
                this._start(ui);
            }
            switch (mode) {
                case PROFILE: {
                    assert (false);
                    break;
                }
                case DEBUG: {
                    if (ss.isDebuggable(target)) {
                        if (!needsRestart) {
                            return;
                        }
                        this._stop(target, ui);
                    } else if (ss.isRunning(target)) {
                        this._stop(target, ui);
                    }
                    ConflictData cd = this.anotherServerDebuggable(target);
                    if (cd != null) {
                        this.resolveServerConflict(target, ui, cd);
                    }
                    this._startDebug(target, ui);
                    break;
                }
                case RUN: {
                    if (ss.isRunning(target)) {
                        if (!needsRestart) {
                            return;
                        }
                        this._stop(target, ui);
                    }
                    this._start(target, ui);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _start(ProgressUI ui) throws ServerException {
        ProgressObject po = this.getStartServer().startDeploymentManager();
        try {
            boolean completedSuccessfully = ProgressObjectUtil.trackProgressObject(ui, po, this.getStartupTimeout());
            if (!completedSuccessfully) {
                throw new ServerException(po.getDeploymentStatus().getMessage());
            }
        }
        catch (TimeoutException e) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartServerTimeout", (Object)this.getDisplayName());
            throw new ServerException(msg);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            this.managerStartedByIde = true;
            this.coTarget = null;
            this.targets = null;
        }
        this.initCoTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startDebug(Target target, ProgressUI ui) throws ServerException {
        ProgressObject po = this.getStartServer().startDebugging(target);
        try {
            boolean completedSuccessfully = ProgressObjectUtil.trackProgressObject(ui, po, this.getStartupTimeout());
            if (!completedSuccessfully) {
                throw new ServerException(po.getDeploymentStatus().getMessage());
            }
        }
        catch (TimeoutException e) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartDebugTimeout", (Object)this.getDisplayName());
            throw new ServerException(msg);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            this.managerStartedByIde = true;
            this.coTarget = null;
            this.targets = null;
        }
        this.initCoTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startProfile(Target target, boolean forceRestart, ProgressUI ui) throws ServerException {
        Profiler profiler;
        ServerInstance tmpProfiledServerInstance = profiledServerInstance.get();
        if (tmpProfiledServerInstance == this && !forceRestart) {
            return;
        }
        if (tmpProfiledServerInstance != null && tmpProfiledServerInstance != this) {
            tmpProfiledServerInstance.stop(ui);
            boolean done = profiledServerInstance.compareAndSet(tmpProfiledServerInstance, null);
            assert (done) : "Unxpected profiled instance " + profiledServerInstance.get();
        }
        if (profiledServerInstance.get() == this || this.isReallyRunning() || this.isDebuggable(target)) {
            this._stop(ui);
            this.debugInfo.clear();
        }
        if ((profiler = ServerRegistry.getProfiler()) == null) {
            throw new ServerException(NbBundle.getMessage(ServerInstance.class, (String)"MSG_ProfilerNotRegistered"));
        }
        final ScheduledExecutorService statusUpdater = Executors.newSingleThreadScheduledExecutor();
        StateListener l = new StateListener(){

            @Override
            public void stateChanged(int oldState, int newState) {
                if (oldState != newState && newState == 2) {
                    ServerInstance.this.removeStateListener(this);
                    statusUpdater.shutdownNow();
                    ServerInstance.this.refresh();
                    ServerInstance old = profiledServerInstance.getAndSet(null);
                    assert (old == null || old == ServerInstance.this) : "Unxpected profiled instance " + old;
                }
            }
        };
        this.addStateListener(l);
        profiler.notifyStarting();
        statusUpdater.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ServerInstance.this.updateStateFromProfiler();
            }
        }, 50L, 100L, TimeUnit.MILLISECONDS);
        ProgressObject po = this.getStartServer().startProfiling(target);
        try {
            boolean completedSuccessfully = ProgressObjectUtil.trackProgressObject(ui, po, 1200000L);
            if (!completedSuccessfully) {
                throw new ServerException(po.getDeploymentStatus().getMessage());
            }
        }
        catch (TimeoutException e) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartProfileTimeout", (Object)this.getDisplayName());
            throw new ServerException(msg);
        }
        profiledServerInstance.set(this);
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            this.managerStartedByIde = true;
        }
    }

    private void shutdownProfiler(ProgressUI ui) throws ServerException {
        ui.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_StoppingProfiler"));
        Profiler profiler = ServerRegistry.getProfiler();
        if (profiler != null) {
            ProgressObject po = profiler.shutdown();
            try {
                boolean completedSuccessfully = ProgressObjectUtil.trackProgressObject(ui, po, this.getShutdownTimeout());
                if (!completedSuccessfully) {
                    throw new ServerException(po.getDeploymentStatus().getMessage());
                }
            }
            catch (TimeoutException e) {
                String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ProfilerShutdownTimeout");
                throw new ServerException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stop(ProgressUI ui) throws ServerException {
        ServerInstance old;
        if (profiledServerInstance.get() == this) {
            this.shutdownProfiler(ui);
            old = profiledServerInstance.getAndSet(null);
            assert (old == null || old == this) : "Unxpected profiled instance " + old;
        }
        old = this;
        synchronized (old) {
            if (this.isSuspended()) {
                Target target = this._retrieveTarget(null);
                ServerDebugInfo sdi = this.getServerDebugInfo(target);
                Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
                for (int i = 0; i < sessions.length; ++i) {
                    AttachingDICookie attCookie;
                    Session s = sessions[i];
                    if (s == null || (attCookie = (AttachingDICookie)s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
                    if (sdi.getTransport().equals("dt_shmem")) {
                        String shmem = attCookie.getSharedMemoryName();
                        if (shmem == null || !shmem.equalsIgnoreCase(sdi.getShmemName())) continue;
                        s.kill();
                        continue;
                    }
                    String host = attCookie.getHostName();
                    if (host == null || !this.isSameHost(host, sdi.getHost()) || attCookie.getPortNumber() != sdi.getPort()) continue;
                    s.kill();
                }
            }
        }
        ProgressObject po = this.getStartServer().stopDeploymentManager();
        try {
            boolean completedSuccessfully = ProgressObjectUtil.trackProgressObject(ui, po, this.getShutdownTimeout());
            if (!completedSuccessfully) {
                throw new ServerException(po.getDeploymentStatus().getMessage());
            }
        }
        catch (TimeoutException e) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StopServerTimeout", (Object)this.getDisplayName());
            throw new ServerException(msg);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            this.managerStartedByIde = false;
        }
        this.reset();
    }

    private void _start(Target target, ProgressUI ui) throws ServerException {
        ServerTarget serverTarget = this.getServerTarget(target.getName());
        if (serverTarget.isRunning()) {
            return;
        }
        ProgressObject po = serverTarget.start();
        try {
            boolean completedSuccessfully = ProgressObjectUtil.trackProgressObject(ui, po, this.getStartupTimeout());
            if (!completedSuccessfully) {
                throw new ServerException(po.getDeploymentStatus().getMessage());
            }
        }
        catch (TimeoutException e) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartServerTimeout", (Object)target.getName());
            throw new ServerException(msg);
        }
        this.targetsStartedByIde.add(serverTarget.getName());
    }

    private void _stop(Target target, ProgressUI ui) throws ServerException {
        ServerTarget serverTarget = this.getServerTarget(target.getName());
        if (serverTarget.isRunning()) {
            return;
        }
        ProgressObject po = serverTarget.stop();
        try {
            boolean completedSuccessfully = ProgressObjectUtil.trackProgressObject(ui, po, this.getShutdownTimeout());
            if (!completedSuccessfully) {
                throw new ServerException(po.getDeploymentStatus().getMessage());
            }
        }
        catch (TimeoutException e) {
            String msg = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StopServerTimeout", (Object)target.getName());
            throw new ServerException(msg);
        }
        this.targetsStartedByIde.remove(serverTarget.getName());
    }

    public boolean canStartServer() {
        return this.getStartServer() != null && this.getStartServer().supportsStartDeploymentManager();
    }

    public boolean isManagerOf(Target target) {
        return this.getTargetMap().containsKey(target.getName());
    }

    public synchronized ServerTarget getCoTarget() {
        return this.coTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCoTarget() {
        ServerTarget[] childs = this.getTargets();
        for (int i = 0; i < childs.length; ++i) {
            if (!this.getStartServer().isAlsoTargetServer(childs[i].getTarget())) continue;
            ServerInstance serverInstance = this;
            synchronized (serverInstance) {
                this.coTarget = childs[i];
                continue;
            }
        }
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static boolean isProgressing(ProgressObject po) {
        StateType state = po.getDeploymentStatus().getState();
        return state == StateType.RUNNING || state == StateType.RELEASED;
    }

    public static boolean hasFailed(ProgressObject po) {
        StateType state = po.getDeploymentStatus().getState();
        return state == StateType.FAILED;
    }

    void notifyUpdated(Iterable<ArtifactListener.Artifact> artifacts) {
        JPDADebugger jpda = this.getDebugger();
        if (jpda != null) {
            try {
                Method fixBreakpointsMethod = jpda.getClass().getMethod("fixBreakpoints", new Class[0]);
                fixBreakpointsMethod.invoke((Object)jpda, new Object[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void addStateListener(StateListener sl) {
        this.stateListeners.add(sl);
    }

    public void removeStateListener(StateListener sl) {
        this.stateListeners.remove(sl);
    }

    private void fireStateChanged(int oldState, int newState) {
        if (oldState == newState) {
            return;
        }
        for (StateListener listener : this.stateListeners) {
            listener.stateChanged(oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean safeTrueTest(SafeTrueTest test, long timeout) {
        try {
            new RequestProcessor().post((Runnable)test).waitFinished(timeout);
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.INFO, null, ie);
        }
        finally {
            return test.result();
        }
    }

    private ServerDebugInfo _retrieveDebugInfo(Target target) {
        StartServer ss = this.getStartServer();
        if (ss == null) {
            return null;
        }
        Target t = this._retrieveTarget(target);
        ServerDebugInfo sdi = ss.getDebugInfo(t);
        if (sdi != null || t != null) {
            this.debugInfo.remove(t);
            this.debugInfo.put(t, sdi);
        }
        return sdi;
    }

    private Target _retrieveTarget(Target target) {
        StartServer ss = this.getStartServer();
        if (ss == null) {
            return null;
        }
        Target t = null;
        if (!this.isReallyRunning() && ss.needsStartForTargetList()) {
            Iterator it = this.debugInfo.keySet().iterator();
            while (t == null && it.hasNext()) {
                Target cachedTarget = (Target)it.next();
                if (!ss.isAlsoTargetServer(cachedTarget)) continue;
                t = cachedTarget;
            }
        } else {
            ServerTarget[] targets = this.getTargets();
            for (int i = 0; t == null && i < targets.length; ++i) {
                if (!ss.isAlsoTargetServer(targets[i].getTarget())) continue;
                t = targets[i].getTarget();
            }
            if (t == null && targets.length > 0) {
                t = targets[0].getTarget();
            }
        }
        return t;
    }

    public int compareTo(Object other) {
        if (!(other instanceof ServerInstance)) {
            throw new IllegalArgumentException();
        }
        return this.getDisplayName().compareTo(((ServerInstance)other).getDisplayName());
    }

    private void firePossibleManagerChange() {
        this.managerChangeSupport.fireChange();
    }

    private boolean isSameHost(String firstName, String secondName) {
        if (firstName != null && firstName.equals(secondName)) {
            return true;
        }
        if (("127.0.0.1".equals(firstName) || "localhost".equals(firstName)) && ("127.0.0.1".equals(secondName) || "localhost".equals(secondName))) {
            return true;
        }
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(firstName);
            int n = inetAddressArray.length;
            for (int i = 0; i < n; ++i) {
                InetAddress firstAddress = inetAddressArray[i];
                if (!localhost.equals(firstAddress) && !"127.0.0.1".equals(firstName) && !"localhost".equals(firstName)) continue;
                InetAddress[] inetAddressArray2 = InetAddress.getAllByName(secondName);
                int n2 = inetAddressArray2.length;
                for (int j = 0; j < n2; ++j) {
                    InetAddress secondAddress = inetAddressArray2[j];
                    if (!localhost.equals(secondAddress) && !"127.0.0.1".equals(secondName) && !"localhost".equals(secondName)) continue;
                    return true;
                }
                break;
            }
        }
        catch (UnknownHostException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        try {
            for (InetAddress firstAddress : InetAddress.getAllByName(firstName)) {
                for (InetAddress secondAddress : InetAddress.getAllByName(secondName)) {
                    if (!firstAddress.equals(secondAddress) && !firstAddress.getCanonicalHostName().equals(secondAddress.getCanonicalHostName())) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        try {
            NetworkInterface firstInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(firstName));
            NetworkInterface secondInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(secondName));
            if (firstInterface != null && firstInterface.equals(secondInterface)) {
                return true;
            }
        }
        catch (SocketException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (UnknownHostException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return false;
    }

    private void updateStateFromProfiler() {
        int profState = ProfilerSupport.getState();
        if (profState == 1) {
            this.setServerState(8);
        } else if (profState == 2) {
            this.setServerState(7);
        } else if (profState == 4 || profState == 3) {
            if (this.isReallyRunning()) {
                this.initCoTarget();
            }
            this.setServerState(6);
        } else {
            this.setServerState(2);
        }
    }

    private class DebuggerStateListener
    extends DebuggerManagerAdapter {
        private RequestProcessor.Task refreshTask;

        private DebuggerStateListener() {
        }

        public void sessionAdded(final Session session) {
            DEBUGGER_STATE_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    if (ServerRegistry.getInstance().getServerInstance(ServerInstance.this.url) == null) {
                        return;
                    }
                    Target target = ServerInstance.this._retrieveTarget(null);
                    ServerDebugInfo sdi = ServerInstance.this.getServerDebugInfo(target);
                    if (sdi == null) {
                        LOGGER.log(Level.FINE, "DebuggerInfo cannot be found for: " + ServerInstance.this);
                        return;
                    }
                    AttachingDICookie attCookie = (AttachingDICookie)session.lookupFirst(null, AttachingDICookie.class);
                    if (attCookie == null) {
                        LOGGER.log(Level.FINE, "AttachingDICookie cannot be found for: " + ServerInstance.this);
                        return;
                    }
                    if ("dt_shmem".equals(sdi.getTransport())) {
                        String shmem = attCookie.getSharedMemoryName();
                        if (shmem != null && shmem.equalsIgnoreCase(sdi.getShmemName())) {
                            DebuggerStateListener.this.registerListener(session);
                        }
                    } else {
                        String host = attCookie.getHostName();
                        if (host != null && ServerInstance.this.isSameHost(host, sdi.getHost()) && attCookie.getPortNumber() == sdi.getPort()) {
                            DebuggerStateListener.this.registerListener(session);
                        }
                    }
                }
            });
        }

        public void sessionRemoved(Session session) {
            DEBUGGER_STATE_PROCESSOR.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DebuggerStateListener debuggerStateListener = DebuggerStateListener.this;
                    synchronized (debuggerStateListener) {
                        DebuggerStateListener.this.refreshTask = null;
                    }
                }
            });
        }

        private void registerListener(Session session) {
            final JPDADebugger jpda = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
            if (jpda != null) {
                jpda.addPropertyChangeListener("state", new PropertyChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        RequestProcessor.Task task;
                        DebuggerStateListener debuggerStateListener = DebuggerStateListener.this;
                        synchronized (debuggerStateListener) {
                            if (DebuggerStateListener.this.refreshTask == null) {
                                DebuggerStateListener.this.refreshTask = DEBUGGER_STATE_PROCESSOR.create(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (jpda.getState() == 3) {
                                            ServerInstance.this.setServerState(5);
                                        } else {
                                            ServerInstance.this.setServerState(4);
                                        }
                                    }
                                });
                            }
                            task = DebuggerStateListener.this.refreshTask;
                        }
                        task.schedule(500);
                    }
                });
            }
        }
    }

    private static abstract class SafeTrueTest
    implements Runnable {
        private volatile boolean result = false;

        private SafeTrueTest() {
        }

        @Override
        public abstract void run();

        public final boolean result() {
            return this.result;
        }

        public final void setResult(boolean result) {
            this.result = result;
        }
    }

    private static class ConflictData {
        private ServerInstance si;
        private ServerDebugInfo sdi;

        public ConflictData(ServerInstance si, ServerDebugInfo sdi) {
            this.si = si;
            this.sdi = sdi;
        }

        public ServerInstance getServerInstance() {
            return this.si;
        }

        public ServerDebugInfo getServerDebugInfo() {
            return this.sdi;
        }
    }

    public static interface StateListener
    extends EventListener {
        public void stateChanged(int var1, int var2);
    }
}

