/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.classpath.AbstractClassPathProvider;
import org.netbeans.modules.java.api.common.classpath.ModuleClassPaths;
import org.netbeans.modules.java.api.common.impl.MultiModule;
import org.netbeans.modules.java.api.common.impl.Utilities;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class MultiModuleClassPathProvider
extends AbstractClassPathProvider {
    private static final Logger LOG = Logger.getLogger(MultiModuleClassPathProvider.class.getName());
    private static final String INTERNAL_MODULE_BINARIES_PATH = "internal-module-bin-path";
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator eval;
    private final Map<String, Function<Owner, ClassPath>> modSensitivePrjPathFcts;
    private final Cache sourceCache;
    private final Cache testCache;
    private final String[] modulePath;
    private final String[] testModulePath;
    private final String[] javacClassPath;
    private final String[] testJavacClassPath;
    private final String[] executeModulePath;
    private final String[] testExecuteModulePath;
    private final String[] executeClassPath;
    private final String[] testExecuteClassPath;
    private final String[] processorClassPath;
    private final String[] testProcessorClassPath;
    private final String[] processorModulePath;
    private final String[] testProcessorModulePath;
    private final String platformType;
    private final String buildModulesDirProperty;
    private final Map<String, URL> urlCache = new ConcurrentHashMap<String, URL>();
    private final Map<String, FileObject> dirCache = new ConcurrentHashMap<String, FileObject>();

    private MultiModuleClassPathProvider(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator eval, @NonNull MultiModule modules, @NonNull MultiModule testModules, @NonNull String[] modulePath, @NonNull String[] testModulePath, @NonNull String[] javacClassPath, @NonNull String[] testJavacClassPath, @NonNull String[] executeModulePath, @NonNull String[] testExecuteModulePath, @NonNull String[] executeClassPath, @NonNull String[] testExecuteClassPath, @NonNull String[] processorModulePath, @NonNull String[] testProcessorModulePath, @NonNull String[] processorClassPath, @NonNull String[] testProcessorClassPath, @NonNull String platformType, @NonNull String buildModulesDirProperty) {
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"eval", (Object)eval);
        Parameters.notNull((CharSequence)"modules", (Object)modules);
        Parameters.notNull((CharSequence)"testModules", (Object)testModules);
        Parameters.notNull((CharSequence)"modulePath", (Object)modulePath);
        Parameters.notNull((CharSequence)"testModulePath", (Object)testModulePath);
        Parameters.notNull((CharSequence)"javacClassPath", (Object)javacClassPath);
        Parameters.notNull((CharSequence)"testJavacClassPath", (Object)testJavacClassPath);
        Parameters.notNull((CharSequence)"executeModulePath", (Object)executeModulePath);
        Parameters.notNull((CharSequence)"testExecuteModulePath", (Object)testExecuteModulePath);
        Parameters.notNull((CharSequence)"executeClassPath", (Object)executeClassPath);
        Parameters.notNull((CharSequence)"testExecuteClassPath", (Object)testExecuteClassPath);
        Parameters.notNull((CharSequence)"processorModulePath", (Object)processorModulePath);
        Parameters.notNull((CharSequence)"testProcessorModulePath", (Object)testProcessorModulePath);
        Parameters.notNull((CharSequence)"processorClassPath", (Object)processorClassPath);
        Parameters.notNull((CharSequence)"testProcessorClassPath", (Object)testProcessorClassPath);
        Parameters.notNull((CharSequence)"platformType", (Object)platformType);
        Parameters.notNull((CharSequence)"buildModulesDirProperty", (Object)buildModulesDirProperty);
        this.helper = helper;
        this.projectDirectory = FileUtil.toFile((FileObject)helper.getProjectDirectory());
        this.eval = eval;
        this.modSensitivePrjPathFcts = new HashMap<String, Function<Owner, ClassPath>>();
        this.modSensitivePrjPathFcts.put("classpath/boot", o -> this.getBootClassPath((Owner)o));
        this.modSensitivePrjPathFcts.put("classpath/compile", o -> this.getCompileTimeClasspath((Owner)o));
        this.modSensitivePrjPathFcts.put("classpath/source", o -> this.getSourcepath((Owner)o));
        this.modSensitivePrjPathFcts.put("classpath/execute", o -> this.getRunTimeClasspath((Owner)o));
        this.sourceCache = new Cache(modules, () -> this.fireClassPathsChange(this.modSensitivePrjPathFcts.keySet()));
        this.testCache = new Cache(testModules, () -> this.fireClassPathsChange(this.modSensitivePrjPathFcts.keySet()));
        this.modulePath = modulePath;
        this.testModulePath = testModulePath;
        this.javacClassPath = javacClassPath;
        this.testJavacClassPath = testJavacClassPath;
        this.executeModulePath = executeModulePath;
        this.testExecuteModulePath = testExecuteModulePath;
        this.executeClassPath = executeClassPath;
        this.testExecuteClassPath = testExecuteClassPath;
        this.processorModulePath = processorModulePath;
        this.testProcessorModulePath = testProcessorModulePath;
        this.processorClassPath = processorClassPath;
        this.testProcessorClassPath = testProcessorClassPath;
        this.platformType = platformType;
        this.buildModulesDirProperty = buildModulesDirProperty;
    }

    @CheckForNull
    private URL getURL(@NonNull String propname) {
        File file;
        String prop;
        URL u = this.urlCache.get(propname);
        if (u == null && (prop = this.eval.getProperty(propname)) != null && (file = this.helper.resolveFile(prop)) != null) {
            try {
                u = BaseUtilities.toURI((File)file).toURL();
                this.urlCache.put(propname, u);
            }
            catch (MalformedURLException e) {
                LOG.log(Level.WARNING, "Cannot convert to URL: {0}", file.getAbsolutePath());
            }
        }
        return u;
    }

    @CheckForNull
    private FileObject getDir(@NonNull String propname) {
        URL u;
        FileObject fo = this.dirCache.get(propname);
        if (!(fo != null && fo.isValid() || (u = this.getURL(propname)) == null || (fo = URLMapper.findFileObject((URL)u)) == null)) {
            this.dirCache.put(propname, fo);
        }
        return fo;
    }

    @CheckForNull
    private Owner getOwner(@NonNull FileObject file) {
        String modName = this.sourceCache.getModules().getModuleName(file);
        if (modName != null) {
            return new Owner(false, Location.SOURCE, modName);
        }
        modName = this.testCache.getModules().getModuleName(file);
        if (modName != null) {
            return new Owner(true, Location.SOURCE, modName);
        }
        return null;
    }

    @CheckForNull
    private ClassPath getModuleSourcePath(@NonNull FileObject file) {
        return this.getModuleSourcePath(this.getOwner(file));
    }

    @CheckForNull
    private ClassPath getModuleSourcePath(@NullAllowed Owner owner) {
        if (owner != null && owner.isSource()) {
            return this.cacheFor(owner).computeIfAbsent(null, "modules/source", mods -> mods.getSourceModulePath());
        }
        return null;
    }

    @CheckForNull
    private ClassPath getModuleBootPath() {
        Owner owner = Owner.GLOBAL_SOURCE;
        return this.cacheFor(owner).computeIfAbsent(null, "modules/boot", mods -> ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createPlatformModulePath(this.eval, this.platformType)));
    }

    @CheckForNull
    private ClassPath getModuleCompilePath(@NonNull FileObject file) {
        return this.getModuleCompilePath(this.getOwner(file));
    }

    @CheckForNull
    private ClassPath getModuleCompilePath(@NullAllowed Owner owner) {
        if (owner != null && owner.isSource()) {
            return this.cacheFor(owner).computeIfAbsent(null, "modules/compile", !owner.isTest() ? mods -> {
                ClassPath impl = ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createPropertyBasedModulePath(this.projectDirectory, this.eval, null, this.modulePath));
                impl = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.getMultiModuleBinariesPath(Owner.GLOBAL_SOURCE), impl});
                return impl;
            } : mods -> {
                ClassPath impl = ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createPropertyBasedModulePath(this.projectDirectory, this.eval, root -> {
                    URL buildModules = this.getURL(this.buildModulesDirProperty);
                    return buildModules == null || !Utilities.isParentOf(buildModules, root);
                }, this.testModulePath));
                impl = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.getMultiModuleBinariesPath(Owner.GLOBAL_TESTS), ClassPathFactory.createClassPath((ClassPathImplementation)new TranslateBuildModules(this.getMultiModuleBinariesPath(Owner.GLOBAL_SOURCE), this.testModulePath)), impl});
                return impl;
            });
        }
        return null;
    }

    @CheckForNull
    private ClassPath getModuleLegacyClassPath(@NonNull FileObject file) {
        return this.getModuleLegacyClassPath(this.getOwner(file));
    }

    @CheckForNull
    private ClassPath getModuleLegacyClassPath(@NullAllowed Owner owner) {
        if (owner != null && owner.isSource()) {
            return this.cacheFor(owner).computeIfAbsent(null, "modules/classpath", mods -> ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.eval, (String[])(owner.isTest() ? this.testJavacClassPath : this.javacClassPath))));
        }
        return null;
    }

    @CheckForNull
    private ClassPath getModuleExecutePath(@NonNull FileObject file) {
        return this.getModuleExecutePath(this.getOwner(file));
    }

    @CheckForNull
    private ClassPath getModuleExecutePath(@NullAllowed Owner owner) {
        if (owner != null) {
            return this.cacheFor(owner).computeIfAbsent(null, MultiModuleClassPathProvider.upgradeType("modules/execute", owner), mods -> ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupport.createProxyClassPathImplementation((ClassPathImplementation[])new ClassPathImplementation[]{ModuleClassPaths.createMultiModuleBinariesPath(mods, owner.getLocation() == Location.DIST, owner.isTest()), ModuleClassPaths.createPropertyBasedModulePath(this.projectDirectory, this.eval, null, owner.isTest() ? this.testExecuteModulePath : this.executeModulePath)})));
        }
        return null;
    }

    @CheckForNull
    private ClassPath getModuleLegacyExecuteClassPath(@NonNull FileObject file) {
        return this.getModuleLegacyExecuteClassPath(this.getOwner(file));
    }

    @CheckForNull
    private ClassPath getModuleLegacyExecuteClassPath(@NullAllowed Owner owner) {
        if (owner != null) {
            return this.cacheFor(owner).computeIfAbsent(null, "modules/execute-classpath", mods -> ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.eval, (String[])(owner.isTest() ? this.testExecuteClassPath : this.executeClassPath))));
        }
        return null;
    }

    @CheckForNull
    private ClassPath getProcessorClasspath(@NonNull FileObject file) {
        return this.getProcessorClasspath(this.getOwner(file));
    }

    @CheckForNull
    private ClassPath getProcessorClasspath(@NullAllowed Owner owner) {
        if (owner != null && owner.isSource()) {
            return this.cacheFor(owner).computeIfAbsent(null, "classpath/processor", mods -> ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.eval, (String[])(owner.isTest() ? this.testProcessorClassPath : this.processorClassPath))));
        }
        return null;
    }

    @CheckForNull
    private ClassPath getProcessorModulepath(@NonNull FileObject file) {
        return this.getProcessorModulepath(this.getOwner(file));
    }

    @CheckForNull
    private ClassPath getProcessorModulepath(@NullAllowed Owner owner) {
        if (owner != null && owner.isSource()) {
            return this.cacheFor(owner).computeIfAbsent(null, "modules/processor", mods -> ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.eval, (String[])(owner.isTest() ? this.testProcessorModulePath : this.processorModulePath))));
        }
        return null;
    }

    @CheckForNull
    private ClassPath getSourcepath(@NonNull FileObject file) {
        return this.getSourcepath(this.getOwner(file));
    }

    @CheckForNull
    private ClassPath getSourcepath(@NullAllowed Owner owner) {
        if (owner != null && owner.isSource() && owner.getModuleName() != null) {
            return this.cacheFor(owner).getModules().getModuleSources(owner.getModuleName());
        }
        return null;
    }

    @CheckForNull
    private ClassPath getBootClassPath(@NonNull FileObject file) {
        return this.getBootClassPath(this.getOwner(file));
    }

    private ClassPath getBootClassPath(@NullAllowed Owner owner) {
        if (owner != null && owner.getModuleName() != null) {
            return this.cacheFor(owner).computeIfAbsent(owner.getModuleName(), "classpath/boot", mods -> {
                ClassPath sourcePath = this.getSourcepath(owner);
                ClassPath systemModules = this.getModuleBootPath();
                ClassPath modulePath = this.getModuleCompilePath(owner);
                if (sourcePath != null && systemModules != null && modulePath != null) {
                    return ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createModuleInfoBasedPath(systemModules, sourcePath, systemModules, modulePath, null, null));
                }
                return null;
            });
        }
        return null;
    }

    @CheckForNull
    private ClassPath getCompileTimeClasspath(@NonNull FileObject file) {
        return this.getCompileTimeClasspath(this.getOwner(file));
    }

    @CheckForNull
    private ClassPath getCompileTimeClasspath(@NullAllowed Owner owner) {
        if (owner != null && owner.isSource() && owner.getModuleName() != null) {
            return this.cacheFor(owner).computeIfAbsent(owner.getModuleName(), "classpath/compile", mods -> {
                ClassPath sourcePath = this.getSourcepath(owner);
                ClassPath systemModules = this.getModuleBootPath();
                ClassPath modulePath = this.getModuleCompilePath(owner);
                if (sourcePath != null && systemModules != null && modulePath != null) {
                    return ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createModuleInfoBasedPath(modulePath, sourcePath, systemModules, modulePath, this.getModuleLegacyClassPath(owner), null));
                }
                return null;
            });
        }
        return null;
    }

    @CheckForNull
    private ClassPath getRunTimeClasspath(@NonNull FileObject file) {
        return this.getRunTimeClasspath(this.getOwner(file));
    }

    @CheckForNull
    private ClassPath getRunTimeClasspath(@NullAllowed Owner owner) {
        if (owner != null && owner.getModuleName() != null) {
            return this.cacheFor(owner).computeIfAbsent(owner.getModuleName(), "classpath/execute", mods -> {
                ClassPath sourcePath = this.getSourcepath(owner);
                ClassPath systemModules = this.getModuleBootPath();
                ClassPath execPath = this.getModuleExecutePath(owner);
                if (sourcePath != null && systemModules != null && execPath != null) {
                    return ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createModuleInfoBasedPath(execPath, sourcePath, systemModules, execPath, this.getModuleLegacyExecuteClassPath(owner), this.getFilter(owner)));
                }
                return null;
            });
        }
        return null;
    }

    @NonNull
    private ClassPath getMultiModuleBinariesPath(@NonNull Owner owner) {
        return this.cacheFor(owner).computeIfAbsent(null, INTERNAL_MODULE_BINARIES_PATH, mods -> ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createMultiModuleBinariesPath(mods, !owner.isTest(), owner.isTest())));
    }

    @NonNull
    private Function<URL, Boolean> getFilter(@NonNull Owner owner) {
        if (owner.isTest()) {
            if (owner.getLocation() == Location.DIST) {
                return new Filter(this.helper, this.eval, "dist.dir");
            }
            return new Filter(this.helper, this.eval, "build.modules.dir");
        }
        if (owner.getLocation() == Location.DIST) {
            return new Filter(this.helper, this.eval, "dist.dir");
        }
        return new Filter(this.helper, this.eval, "build.modules.dir");
    }

    @NonNull
    private static String upgradeType(@NonNull String type, @NonNull Owner owner) {
        if (owner.getLocation() == Location.DIST) {
            return String.format("%s+dist", type);
        }
        return type;
    }

    @NonNull
    private Cache cacheFor(@NonNull Owner owner) {
        return owner.isTest() ? this.testCache : this.sourceCache;
    }

    private void collectPath(@NonNull List<? super ClassPath> collector, @NonNull Owner owner, @NonNull Function<Owner, ClassPath> f) {
        for (String string : this.cacheFor(owner).getModules().getModuleNames()) {
            ClassPath cp = f.apply(new Owner(owner.isTest(), owner.getLocation(), string));
            if (cp == null) continue;
            collector.add((ClassPath)cp);
        }
    }

    public ClassPath findClassPath(@NonNull FileObject file, @NonNull String type) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        Parameters.notNull((CharSequence)"type", (Object)type);
        LOG.log(Level.FINE, "Find ClassPath of type {0} for {1}", new Object[]{type, file});
        Object res = type.equals("modules/source") ? this.getModuleSourcePath(file) : (type.equals("modules/boot") ? this.getModuleBootPath() : (type.equals("modules/compile") ? this.getModuleCompilePath(file) : (type.equals("modules/classpath") ? this.getModuleLegacyClassPath(file) : (type.equals("modules/processor") ? this.getProcessorModulepath(file) : (type.equals("modules/execute") ? this.getModuleExecutePath(file) : (type.equals("modules/execute-classpath") ? this.getModuleLegacyExecuteClassPath(file) : (type.equals("classpath/endorsed") ? ClassPath.EMPTY : (type.equals("classpath/processor") ? this.getProcessorClasspath(file) : (type.equals("classpath/source") ? this.getSourcepath(file) : (type.equals("classpath/boot") ? this.getBootClassPath(file) : (type.equals("classpath/compile") ? this.getCompileTimeClasspath(file) : (type.equals("classpath/execute") ? this.getRunTimeClasspath(file) : null))))))))))));
        LOG.log(Level.FINE, "Result: ", res);
        return res;
    }

    @Override
    public String[] getPropertyName(SourceGroup sg, String type) {
        FileObject root = sg.getRootFolder();
        Owner fOwner = this.getOwner(root);
        if (fOwner == null) {
            return null;
        }
        if (fOwner.isTest()) {
            switch (type) {
                case "classpath/compile": {
                    return this.testJavacClassPath;
                }
                case "classpath/execute": {
                    return this.testExecuteClassPath;
                }
                case "classpath/processor": {
                    return this.testProcessorClassPath;
                }
                case "modules/compile": {
                    return this.testModulePath;
                }
                case "modules/processor": {
                    return this.testProcessorModulePath;
                }
                case "modules/execute": {
                    return this.testExecuteModulePath;
                }
            }
            return null;
        }
        switch (type) {
            case "classpath/compile": {
                return this.javacClassPath;
            }
            case "classpath/execute": {
                return this.executeClassPath;
            }
            case "classpath/processor": {
                return this.processorClassPath;
            }
            case "modules/compile": {
                return this.modulePath;
            }
            case "modules/processor": {
                return this.processorModulePath;
            }
            case "modules/execute": {
                return this.executeModulePath;
            }
        }
        return null;
    }

    @Override
    public ClassPath[] getProjectClassPaths(String type) {
        return (ClassPath[])ProjectManager.mutex().readAccess(() -> {
            if ("modules/boot".equals(type)) {
                return new ClassPath[]{this.getModuleBootPath()};
            }
            if ("modules/source".equals(type)) {
                return new ClassPath[]{this.getModuleSourcePath(Owner.GLOBAL_SOURCE), this.getModuleSourcePath(Owner.GLOBAL_TESTS)};
            }
            if ("modules/classpath".equals(type)) {
                return new ClassPath[]{this.getModuleLegacyClassPath(Owner.GLOBAL_SOURCE), this.getModuleLegacyClassPath(Owner.GLOBAL_TESTS)};
            }
            if ("modules/compile".equals(type)) {
                return new ClassPath[]{this.getModuleCompilePath(Owner.GLOBAL_SOURCE), this.getModuleCompilePath(Owner.GLOBAL_TESTS)};
            }
            if ("modules/processor".equals(type)) {
                return new ClassPath[]{this.getProcessorModulepath(Owner.GLOBAL_SOURCE), this.getProcessorModulepath(Owner.GLOBAL_TESTS)};
            }
            if ("classpath/processor".equals(type)) {
                return new ClassPath[]{this.getProcessorClasspath(Owner.GLOBAL_SOURCE), this.getProcessorClasspath(Owner.GLOBAL_TESTS)};
            }
            if ("modules/execute".equals(type)) {
                return new ClassPath[]{this.getModuleExecutePath(Owner.GLOBAL_SOURCE), this.getModuleExecutePath(Owner.GLOBAL_TESTS)};
            }
            if ("modules/execute-classpath".equals(type)) {
                return new ClassPath[]{this.getModuleLegacyExecuteClassPath(Owner.GLOBAL_SOURCE), this.getModuleLegacyExecuteClassPath(Owner.GLOBAL_TESTS)};
            }
            Function<Owner, ClassPath> f = this.modSensitivePrjPathFcts.get(type);
            if (f != null) {
                ArrayList cps = new ArrayList();
                this.collectPath(cps, Owner.GLOBAL_SOURCE, f);
                this.collectPath(cps, Owner.GLOBAL_TESTS, f);
                return cps.toArray(new ClassPath[0]);
            }
            assert (false) : "Unsupported ClassPath type: " + type;
            return new ClassPath[0];
        });
    }

    public ClassPath getProjectSourcesClassPath(String type) {
        return (ClassPath)ProjectManager.mutex().readAccess(() -> {
            if ("modules/boot".equals(type)) {
                return this.getModuleBootPath();
            }
            if ("modules/source".equals(type)) {
                return this.getModuleSourcePath(Owner.GLOBAL_SOURCE);
            }
            if ("modules/classpath".equals(type)) {
                return this.getModuleLegacyClassPath(Owner.GLOBAL_SOURCE);
            }
            if ("modules/compile".equals(type)) {
                return this.getModuleCompilePath(Owner.GLOBAL_SOURCE);
            }
            if ("modules/processor".equals(type)) {
                return this.getProcessorModulepath(Owner.GLOBAL_SOURCE);
            }
            if ("classpath/processor".equals(type)) {
                return this.getProcessorClasspath(Owner.GLOBAL_SOURCE);
            }
            if ("modules/execute".equals(type)) {
                return this.getModuleExecutePath(Owner.GLOBAL_SOURCE);
            }
            if ("modules/execute-classpath".equals(type)) {
                return this.getModuleLegacyExecuteClassPath(Owner.GLOBAL_SOURCE);
            }
            Function<Owner, ClassPath> f = this.modSensitivePrjPathFcts.get(type);
            if (f != null) {
                ArrayList cps = new ArrayList();
                this.collectPath(cps, Owner.GLOBAL_SOURCE, f);
                return cps.isEmpty() ? null : ClassPathSupport.createProxyClassPath((ClassPath[])cps.toArray(new ClassPath[0]));
            }
            assert (false) : "Unsupported ClassPath type: " + type;
            return null;
        });
    }

    private static final class Cache
    implements PropertyChangeListener {
        private final MultiModule modules;
        private final Runnable firer;
        private final Map<String, ClassPath> globals;
        private final Map<String, Map<String, ClassPath>> perModule;
        private final Set<String> currentModuleNames;

        Cache(@NonNull MultiModule modules, @NonNull Runnable firer) {
            this.modules = modules;
            this.firer = firer;
            this.globals = new HashMap<String, ClassPath>();
            this.perModule = new HashMap<String, Map<String, ClassPath>>();
            this.currentModuleNames = new HashSet<String>(this.modules.getModuleNames());
            this.modules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.modules));
        }

        @NonNull
        MultiModule getModules() {
            return this.modules;
        }

        @CheckForNull
        ClassPath computeIfAbsent(@NullAllowed String module, @NonNull String cpType, @NonNull Function<MultiModule, ClassPath> factory) {
            if (module == null) {
                return this.computeIfAbsentGlobal(cpType, factory);
            }
            return this.computeIfAbsentModule(module, cpType, factory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("modules".equals(evt.getPropertyName())) {
                boolean fire = false;
                Cache cache = this;
                synchronized (cache) {
                    HashSet<String> toRemove = new HashSet<String>(this.currentModuleNames);
                    Collection<? extends String> newModuleNames = this.modules.getModuleNames();
                    HashSet<? extends String> toAdd = new HashSet<String>(newModuleNames);
                    toAdd.removeAll(toRemove);
                    toRemove.removeAll(newModuleNames);
                    for (String string : toRemove) {
                        fire |= this.perModule.remove(string) != null;
                        this.currentModuleNames.remove(string);
                    }
                    for (String string : toAdd) {
                        fire |= this.currentModuleNames.add(string);
                    }
                }
                if (fire) {
                    this.firer.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        private ClassPath computeIfAbsentGlobal(@NonNull String cpType, @NonNull Function<MultiModule, ClassPath> factory) {
            Cache cache = this;
            synchronized (cache) {
                ClassPath res = this.globals.get(cpType);
                if (res != null) {
                    return res;
                }
            }
            return (ClassPath)ProjectManager.mutex().readAccess(() -> {
                Cache cache = this;
                synchronized (cache) {
                    ClassPath oldCp;
                    ClassPath cp = this.globals.get(cpType);
                    if (cp == null && (oldCp = this.globals.putIfAbsent(cpType, cp = (ClassPath)factory.apply(this.modules))) != null) {
                        cp = oldCp;
                    }
                    return cp;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        private ClassPath computeIfAbsentModule(@NonNull String module, @NonNull String cpType, @NonNull Function<MultiModule, ClassPath> factory) {
            Cache cache = this;
            synchronized (cache) {
                ClassPath cp = Optional.ofNullable(this.perModule.get(module)).map(m -> (ClassPath)m.get(cpType)).orElse(null);
                if (cp != null) {
                    return cp;
                }
            }
            return (ClassPath)ProjectManager.mutex().readAccess(() -> {
                Cache cache = this;
                synchronized (cache) {
                    ClassPath oldCp;
                    Map moduleCps = this.perModule.computeIfAbsent(module, mn -> new HashMap());
                    ClassPath cp = (ClassPath)moduleCps.get(cpType);
                    if (cp == null && (oldCp = moduleCps.putIfAbsent(cpType, cp = (ClassPath)factory.apply(this.modules))) != null) {
                        cp = oldCp;
                    }
                    return cp;
                }
            });
        }
    }

    private static final class Owner {
        private static final Owner GLOBAL_SOURCE = new Owner(false, Location.SOURCE, null);
        private static final Owner GLOBAL_TESTS = new Owner(true, Location.SOURCE, null);
        private final boolean test;
        private final Location loc;
        private final String moduleName;

        Owner(boolean test, @NonNull Location location, @NullAllowed String moduleName) {
            this.test = test;
            this.loc = location;
            this.moduleName = moduleName;
        }

        boolean isTest() {
            return this.test;
        }

        boolean isSource() {
            return this.loc.isSource();
        }

        @NonNull
        Location getLocation() {
            return this.loc;
        }

        @CheckForNull
        String getModuleName() {
            return this.moduleName;
        }
    }

    private static enum Location {
        SOURCE(true),
        BUILD(false),
        DIST(false);

        private final boolean source;

        private Location(boolean source) {
            this.source = source;
        }

        boolean isSource() {
            return this.source;
        }
    }

    private static final class Filter
    implements Function<URL, Boolean>,
    PropertyChangeListener {
        private final AntProjectHelper helper;
        private final PropertyEvaluator eval;
        private final String ownerProp;
        private Set<URL> includeIn;

        private Filter(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator eval, @NonNull String ownerProp) {
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"ownerProp", (Object)ownerProp);
            this.helper = helper;
            this.eval = eval;
            this.ownerProp = ownerProp;
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.eval));
        }

        @Override
        public Boolean apply(URL t) {
            Collection<? extends URL> roots = this.getRoots();
            for (URL uRL : roots) {
                if (!Filter.isParentOf(uRL, t)) continue;
                return true;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || propName.equals(this.ownerProp)) {
                Filter filter = this;
                synchronized (filter) {
                    this.includeIn = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private Collection<? extends URL> getRoots() {
            Filter filter = this;
            synchronized (filter) {
                if (this.includeIn != null) {
                    return this.includeIn;
                }
            }
            URL url = null;
            String val = this.eval.getProperty(this.ownerProp);
            if (val != null) {
                try {
                    File f = this.helper.resolveFile(val);
                    url = BaseUtilities.toURI((File)f).toURL();
                }
                catch (MalformedURLException e) {
                    LOG.warning(e.toString());
                }
            }
            Filter filter2 = this;
            synchronized (filter2) {
                if (this.includeIn == null) {
                    this.includeIn = url == null ? Collections.emptySet() : Collections.singleton(url);
                }
                return this.includeIn;
            }
        }

        private static boolean isParentOf(@NonNull URL folder, @NonNull URL file) {
            Object sfld = folder.toExternalForm();
            if (((String)sfld).charAt(((String)sfld).length() - 1) != '/') {
                sfld = (String)sfld + "/";
            }
            String sfil = file.toExternalForm();
            return sfil.startsWith((String)sfld);
        }
    }

    private final class TranslateBuildModules
    implements ClassPathImplementation,
    PropertyChangeListener {
        private final ClassPath delegate;
        private final Collection<String> props;
        private final AtomicReference<List<PathResourceImplementation>> cache;
        private final PropertyChangeSupport listeners;

        TranslateBuildModules(@NonNull ClassPath delegate, String ... props) {
            this.delegate = delegate;
            this.props = new HashSet<String>();
            Collections.addAll(this.props, props);
            this.cache = new AtomicReference();
            this.listeners = new PropertyChangeSupport(this);
            this.delegate.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.delegate));
            MultiModuleClassPathProvider.this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)MultiModuleClassPathProvider.this.eval));
        }

        public List<? extends PathResourceImplementation> getResources() {
            List<Object> res = this.cache.get();
            if (res == null) {
                Set seen = this.props.stream().map(p -> MultiModuleClassPathProvider.this.eval.getProperty(p)).filter(p -> p != null).flatMap(p -> Arrays.stream(PropertyUtils.tokenizePath((String)p))).map(p -> MultiModuleClassPathProvider.this.helper.resolveFile(p)).collect(Collectors.toSet());
                URL url = MultiModuleClassPathProvider.this.getURL(MultiModuleClassPathProvider.this.buildModulesDirProperty);
                res = Collections.emptyList();
                if (url != null) {
                    try {
                        File buildModules = BaseUtilities.toFile((URI)url.toURI());
                        if (seen.contains(buildModules)) {
                            res = Collections.unmodifiableList(this.delegate.entries().stream().map(e -> ClassPathSupport.createResource((URL)e.getURL())).collect(Collectors.toList()));
                        }
                    }
                    catch (URISyntaxException e2) {
                        LOG.log(Level.WARNING, "Cannot convert to URI: {0}", url);
                    }
                }
                if (!this.cache.compareAndSet(null, res)) {
                    res = Optional.ofNullable(this.cache.get()).orElse(res);
                }
            }
            return res;
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            this.listeners.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            this.listeners.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("entries".equals(propName) || propName == null || this.props.contains(propName)) {
                this.cache.set(null);
                this.listeners.firePropertyChange("resources", null, null);
            }
        }
    }

    public static final class Builder {
        private final AntProjectHelper helper;
        private final PropertyEvaluator eval;
        private final MultiModule modules;
        private final MultiModule testModules;
        private String[] modulePath = new String[]{"javac.modulepath"};
        private String[] testModulePath = new String[]{"javac.test.modulepath"};
        private String[] javacClassPath = new String[]{"javac.classpath"};
        private String[] testJavacClassPath = new String[]{"javac.test.classpath"};
        private String[] executeModulePath = new String[]{"run.modulepath"};
        private String[] testExecuteModulePath = new String[]{"run.test.modulepath"};
        private String[] executeClassPath = new String[]{"run.classpath"};
        private String[] testExecuteClassPath = new String[]{"run.test.classpath"};
        private String[] processorModulePath = new String[]{"javac.processormodulepath"};
        private String[] testProcessorModulePath = new String[]{"javac.test.processormodulepath"};
        private String[] processorClassPath = new String[]{"javac.processorpath"};
        private String[] testProcessorClassPath = new String[]{"javac.test.processorpath"};
        private String platformType = "j2se";
        private String buildModulesDirProperty = "build.modules.dir";

        private Builder(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull MultiModule modules, @NonNull MultiModule testModules) {
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
            Parameters.notNull((CharSequence)"modules", (Object)modules);
            Parameters.notNull((CharSequence)"testModules", (Object)testModules);
            this.helper = helper;
            this.eval = evaluator;
            this.modules = modules;
            this.testModules = testModules;
        }

        @NonNull
        public static Builder newInstance(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots sourceModules, @NonNull SourceRoots srcRoots, @NonNull SourceRoots testModules, @NonNull SourceRoots testRoots) {
            return new Builder(helper, evaluator, MultiModule.getOrCreate(sourceModules, srcRoots), MultiModule.getOrCreate(testModules, testRoots));
        }

        @NonNull
        public Builder setModulepathProperties(@NonNull String[] modulepathProperties) {
            Parameters.notNull((CharSequence)"modulePathProperties", (Object)modulepathProperties);
            this.modulePath = Arrays.copyOf(modulepathProperties, modulepathProperties.length);
            return this;
        }

        @NonNull
        public Builder setTestModulepathProperties(@NonNull String[] modulepathProperties) {
            Parameters.notNull((CharSequence)"modulePathProperties", (Object)modulepathProperties);
            this.testModulePath = Arrays.copyOf(modulepathProperties, modulepathProperties.length);
            return this;
        }

        @NonNull
        public Builder setJavacClasspathProperties(@NonNull String[] classpathProperties) {
            Parameters.notNull((CharSequence)"classPathProperties", (Object)classpathProperties);
            this.javacClassPath = Arrays.copyOf(classpathProperties, classpathProperties.length);
            return this;
        }

        @NonNull
        public Builder setTestJavacClasspathProperties(@NonNull String[] classpathProperties) {
            Parameters.notNull((CharSequence)"classpathProperties", (Object)classpathProperties);
            this.testJavacClassPath = Arrays.copyOf(classpathProperties, classpathProperties.length);
            return this;
        }

        @NonNull
        public Builder setRunModulepathProperties(@NonNull String[] modulePathProperties) {
            Parameters.notNull((CharSequence)"modulePathProperties", (Object)modulePathProperties);
            this.executeModulePath = Arrays.copyOf(modulePathProperties, modulePathProperties.length);
            return this;
        }

        @NonNull
        public Builder setTestRunModulepathProperties(@NonNull String[] modulePathProperties) {
            Parameters.notNull((CharSequence)"modulePathProperties", (Object)modulePathProperties);
            this.testExecuteModulePath = Arrays.copyOf(modulePathProperties, modulePathProperties.length);
            return this;
        }

        @NonNull
        public Builder setRunClasspathProperties(@NonNull String[] runClasspathProperties) {
            Parameters.notNull((CharSequence)"runClasspathProperties", (Object)runClasspathProperties);
            this.executeClassPath = Arrays.copyOf(runClasspathProperties, runClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setTestRunClasspathProperties(@NonNull String[] runTestClasspathProperties) {
            Parameters.notNull((CharSequence)"runTestClasspathProperties", (Object)runTestClasspathProperties);
            this.testExecuteClassPath = Arrays.copyOf(runTestClasspathProperties, runTestClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setProcessorModulepathProperties(@NonNull String[] processorModulepathProperties) {
            Parameters.notNull((CharSequence)"processorModulepathProperties", (Object)processorModulepathProperties);
            this.processorModulePath = Arrays.copyOf(processorModulepathProperties, processorModulepathProperties.length);
            return this;
        }

        @NonNull
        public Builder setTestProcessorModulepathProperties(@NonNull String[] processorModulepathProperties) {
            Parameters.notNull((CharSequence)"processorModulepathProperties", (Object)processorModulepathProperties);
            this.testProcessorModulePath = Arrays.copyOf(processorModulepathProperties, processorModulepathProperties.length);
            return this;
        }

        @NonNull
        public Builder setProcessorClasspathProperties(@NonNull String[] processorClasspathProperties) {
            Parameters.notNull((CharSequence)"processorClasspathProperties", (Object)processorClasspathProperties);
            this.processorClassPath = Arrays.copyOf(processorClasspathProperties, processorClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setTestProcessorClasspathProperties(@NonNull String[] processorClasspathProperties) {
            Parameters.notNull((CharSequence)"processorClasspathProperties", (Object)processorClasspathProperties);
            this.testProcessorClassPath = Arrays.copyOf(processorClasspathProperties, processorClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setPlatformType(@NonNull String platformType) {
            Parameters.notNull((CharSequence)"platformType", (Object)platformType);
            this.platformType = platformType;
            return this;
        }

        @NonNull
        public Builder setBuildModulesDirProperty(@NonNull String buildModulesDirProperty) {
            Parameters.notNull((CharSequence)"buildModulesDirProperty", (Object)buildModulesDirProperty);
            this.buildModulesDirProperty = buildModulesDirProperty;
            return this;
        }

        @NonNull
        public MultiModuleClassPathProvider build() {
            return new MultiModuleClassPathProvider(this.helper, this.eval, this.modules, this.testModules, this.modulePath, this.testModulePath, this.javacClassPath, this.testJavacClassPath, this.executeModulePath, this.testExecuteModulePath, this.executeClassPath, this.testExecuteClassPath, this.processorModulePath, this.testProcessorModulePath, this.processorClassPath, this.testProcessorClassPath, this.platformType, this.buildModulesDirProperty);
        }
    }
}

