/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AddPageActionProvider
extends AbstractAction
implements ContextAwareAction {
    private static final String LBL_AddPage = NbBundle.getMessage(AddPageActionProvider.class, (String)"LBL_AddPage");

    public Action createContextAwareInstance(Lookup lookup) {
        AddPageAction addPageAction;
        PageFlowScene scene = (PageFlowScene)((Object)lookup.lookup(PageFlowScene.class));
        if (scene != null) {
            this.setEnabled(true);
            addPageAction = new AddPageAction(scene);
        } else {
            this.setEnabled(false);
            addPageAction = null;
        }
        return addPageAction;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class AddPageAction
    extends AbstractAction {
        private final PageFlowScene scene;

        public AddPageAction(PageFlowScene scene) {
            this.putValue("Name", LBL_AddPage);
            this.scene = scene;
        }

        protected String getDisplayName() {
            return LBL_AddPage;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PageFlowController pfc = this.scene.getPageFlowView().getPageFlowController();
                FileObject webFileObject = pfc.getWebFolder();
                String name = FileUtil.findFreeFileName((FileObject)webFileObject, (String)"page", (String)"jsp");
                name = JOptionPane.showInputDialog("Select Page Name", (Object)name);
                this.createIndexJSP(webFileObject, name);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void createIndexJSP(FileObject targetFolder, String name) throws IOException {
            FileObject jspTemplate = FileUtil.getConfigFile((String)"Templates/JSP_Servlet/JSP.jsp");
            if (jspTemplate == null) {
                return;
            }
            DataObject mt = DataObject.find((FileObject)jspTemplate);
            DataFolder webDf = DataFolder.findFolder((FileObject)targetFolder);
            mt.createFromTemplate(webDf, name);
        }
    }
}

