/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.hints;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.apisupport.hints.Bundle;
import org.netbeans.modules.apisupport.hints.Hinter;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;

public class DataObjectRegistrationHinter
implements Hinter {
    public static final String ACTIONS_FOLDER = "Actions";
    public static final String METHOD_DOPOOL_FACTORY = "method:org.openide.loaders.DataLoaderPool.factory";
    private static final String LOADERS_FOLDER = "Loaders/";
    private static final String FACTORIES_FOLDER = "Factories";

    @Override
    public void process(Hinter.Context ctx) throws Exception {
        FileObject file = ctx.file();
        if (file.getPath().startsWith(LOADERS_FOLDER)) {
            if (file.getPath().contains(FACTORIES_FOLDER)) {
                this.processFactories(ctx, file);
            }
            if (file.getPath().endsWith(ACTIONS_FOLDER)) {
                this.processActions(ctx, file);
            }
        }
    }

    private void processActions(final Hinter.Context ctx, FileObject file) throws Exception {
        if (this.annotationsActionsDataObjectAvailable(ctx)) {
            String actionsMime = Utility.getMimeTypeFromActionsPath(file.getPath());
            HashMap<String, Object> visibleLoaderFactories = new HashMap<String, Object>();
            FileObject startingPath = file.getFileSystem().findResource(LOADERS_FOLDER);
            if (startingPath != null) {
                for (FileObject aLoadersFileObject : NbCollections.iterable((Enumeration)startingPath.getChildren(true))) {
                    Object instanceCreate;
                    if (!aLoadersFileObject.getPath().contains(FACTORIES_FOLDER) || (instanceCreate = ctx.instanceAttribute(aLoadersFileObject)) == null || METHOD_DOPOOL_FACTORY.equals(instanceCreate)) continue;
                    String ic = instanceCreate.toString();
                    if (visibleLoaderFactories.containsKey(ic)) {
                        ((List)visibleLoaderFactories.get(ic)).add(Utility.getMimeTypeFromFactoryPath(aLoadersFileObject.getPath()));
                        continue;
                    }
                    LinkedList mime = new LinkedList();
                    mime.add(Utility.getMimeTypeFromFactoryPath(aLoadersFileObject.getPath()));
                    visibleLoaderFactories.put(ic, mime);
                }
                if (visibleLoaderFactories.isEmpty()) {
                    ctx.addHint(Severity.VERIFIER, Bundle.DataObjectRegistrationHinter_no_DataObject(), new Fix[0]);
                } else {
                    ArrayList<1> fixes = new ArrayList<1>();
                    boolean mimeMatch = false;
                    for (Map.Entry loader : visibleLoaderFactories.entrySet()) {
                        for (String aMime : (List)loader.getValue()) {
                            if (!actionsMime.equals(aMime)) continue;
                            mimeMatch = true;
                        }
                    }
                    for (Map.Entry loader : visibleLoaderFactories.entrySet()) {
                        boolean restrict = true;
                        StringBuilder sbMime = new StringBuilder();
                        for (String aMime : (List)loader.getValue()) {
                            if (actionsMime.equals(aMime)) {
                                restrict = false;
                            }
                            sbMime.append(aMime);
                            sbMime.append(",");
                        }
                        sbMime.deleteCharAt(sbMime.length() - 1);
                        String fname = ((String)loader.getKey()).substring(((String)loader.getKey()).lastIndexOf(".") + 1) + ".java";
                        final String text = mimeMatch ? Bundle.DataObjectRegistrationHinter_fix_regular(fname, sbMime) : Bundle.DataObjectRegistrationHinter_fix_special(fname, sbMime);
                        final String fixParam = (String)loader.getKey();
                        if (!mimeMatch) {
                            restrict = false;
                        }
                        if (restrict) continue;
                        fixes.add(new Fix(){

                            public String getText() {
                                return text;
                            }

                            public ChangeInfo implement() throws Exception {
                                ctx.findAndModifyDeclaration(fixParam, new RegisterActionsDataObject(ctx));
                                return null;
                            }
                        });
                    }
                    if (!fixes.isEmpty()) {
                        ctx.addHint(Severity.WARNING, ctx.standardAnnotationDescription(), fixes.toArray(new Fix[0]));
                    }
                }
            }
        }
    }

    private Object getInstanceDataObject(Object instanceCreate, FileObject file) {
        if (METHOD_DOPOOL_FACTORY.equals(instanceCreate)) {
            return "new:" + file.getAttribute("literal:dataObjectClass");
        }
        return instanceCreate;
    }

    private void processFactories(final Hinter.Context ctx, final FileObject file) throws Exception {
        final Object instanceCreate = ctx.instanceAttribute(file);
        if (instanceCreate == null) {
            return;
        }
        if (this.checkAttributes(file, ctx)) {
            ctx.addStandardAnnotationHint(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (!DataObjectRegistrationHinter.this.annotationsDataObjectAvailable(ctx)) {
                        return null;
                    }
                    ctx.findAndModifyDeclaration(DataObjectRegistrationHinter.this.getInstanceDataObject(instanceCreate, file), new RegisterDataObject(ctx));
                    return null;
                }
            });
        }
    }

    private boolean annotationsDataObjectAvailable(Hinter.Context ctx) {
        if (ctx.canAccess(DataObject.Registration.class.getName()) && ctx.canAccess(DataObject.Registrations.class.getName())) {
            return true;
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.DataObjectRegistrationHinter_missing_dep(), 2));
        return false;
    }

    private boolean annotationsActionsDataObjectAvailable(Hinter.Context ctx) {
        if (ctx.canAccess("org.openide.awt.ActionReferences")) {
            return true;
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ActionRegistrationHinter_missing_org_openide_awt(), 2));
        return false;
    }

    private boolean checkAttributes(FileObject file, Hinter.Context ctx) {
        boolean attributesCompatible = true;
        for (String attr : NbCollections.iterable((Enumeration)file.getAttributes())) {
            if (attr.matches("mimeType|position|displayName|iconBase|dataObjectClass|instanceCreate|SystemFileSystem.localizingBundle")) continue;
            ctx.addHint(Severity.WARNING, Bundle.DataObjectHinter_unrecognized_attr(attr), new Fix[0]);
            attributesCompatible = false;
        }
        if (file.getAttribute("literal:SystemFileSystem.localizingBundle") != null) {
            attributesCompatible = false;
            ctx.addHint(Severity.HINT, Bundle.DataObjectRegistrationHinter_use_displayName(), new Fix[0]);
        }
        return attributesCompatible;
    }

    static class Utility {
        Utility() {
        }

        private static String getMime(String path, String right) {
            String mimeType = path.replace(DataObjectRegistrationHinter.LOADERS_FOLDER, "");
            mimeType = mimeType.substring(0, mimeType.indexOf(right) - 1);
            return mimeType;
        }

        private static String getMimeTypeFromFactoryPath(String path) {
            return Utility.getMime(path, DataObjectRegistrationHinter.FACTORIES_FOLDER);
        }

        private static String getMimeTypeFromActionsPath(String path) {
            return Utility.getMime(path, DataObjectRegistrationHinter.ACTIONS_FOLDER);
        }
    }

    private static class RegisterActionsDataObject
    implements Hinter.Context.ModifyDeclarationTask {
        private final Hinter.Context ctx;

        private RegisterActionsDataObject(Hinter.Context ctx) {
            this.ctx = ctx;
        }

        private boolean isSeparator(FileObject fo) {
            return fo != null && fo.hasExt("instance") && "javax.swing.JSeparator".equals(fo.getAttribute("instanceClass"));
        }

        private boolean isSameLayer(FileObject fo) {
            return Utilities.compareObjects((Object)this.ctx.file().getAttribute("layers"), (Object)fo.getAttribute("layers"));
        }

        @Override
        public void run(WorkingCopy wc, Element declaration, ModifiersTree modifiers) throws Exception {
            FileObject file = this.ctx.file();
            ArrayList<FileObject> toDelete = new ArrayList<FileObject>();
            TypeElement annActionID = wc.getElements().getTypeElement("org.openide.awt.ActionID");
            if (annActionID == null) {
                throw new IllegalArgumentException("Could not find ActionID in classpath");
            }
            TypeElement annActionRef = wc.getElements().getTypeElement("org.openide.awt.ActionReference");
            if (annActionRef == null) {
                throw new IllegalArgumentException("Could not find ActionReference in classpath");
            }
            TypeElement annActionRefs = wc.getElements().getTypeElement("org.openide.awt.ActionReferences");
            if (annActionRefs == null) {
                throw new IllegalArgumentException("Could not find ActionReferences in classpath");
            }
            if (!file.isData()) {
                List<FileObject> foList = new ArrayList();
                for (FileObject achildren : NbCollections.iterable((Enumeration)file.getData(true))) {
                    foList.add(achildren);
                }
                foList = FileUtil.getOrder(foList, (boolean)true);
                ListIterator iter = foList.listIterator();
                TreeMaker make = wc.getTreeMaker();
                ArrayList<AnnotationTree> anns = new ArrayList<AnnotationTree>();
                while (iter.hasNext()) {
                    FileObject candidateSep;
                    FileObject fo = (FileObject)iter.next();
                    if (!fo.hasExt("shadow") || !this.isSameLayer(fo)) continue;
                    ArrayList<AssignmentTree> argumentsActionID = new ArrayList<AssignmentTree>();
                    FileObject originalFile = FileUtil.getConfigFile((String)fo.getAttribute("originalFile").toString());
                    argumentsActionID.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"category"), (ExpressionTree)make.Literal((Object)originalFile.getParent().getPath().substring("Actions/".length()))));
                    argumentsActionID.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"id"), (ExpressionTree)make.Literal((Object)originalFile.getName().replace('-', '.'))));
                    ArrayList<AssignmentTree> arguments = new ArrayList<AssignmentTree>();
                    arguments.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"id"), (ExpressionTree)make.Annotation((Tree)make.QualIdent((Element)annActionID), argumentsActionID)));
                    arguments.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"path"), (ExpressionTree)make.Literal((Object)fo.getParent().getPath())));
                    arguments.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"position"), (ExpressionTree)make.Literal(fo.getAttribute("position"))));
                    if (iter.hasPrevious()) {
                        iter.previous();
                        if (iter.hasPrevious()) {
                            candidateSep = (FileObject)iter.previous();
                            iter.next();
                            if (this.isSeparator(candidateSep) && !toDelete.contains(candidateSep)) {
                                arguments.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"separatorBefore"), (ExpressionTree)make.Literal(candidateSep.getAttribute("position"))));
                                toDelete.add(candidateSep);
                            }
                        }
                        iter.next();
                    }
                    if (iter.hasNext()) {
                        candidateSep = (FileObject)iter.next();
                        iter.previous();
                        if (this.isSeparator(candidateSep)) {
                            arguments.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"separatorAfter"), (ExpressionTree)make.Literal(candidateSep.getAttribute("position"))));
                            toDelete.add(candidateSep);
                        }
                    }
                    anns.add(make.Annotation((Tree)make.QualIdent((Element)annActionRef), arguments));
                    toDelete.add(fo);
                }
                if (!anns.isEmpty()) {
                    ModifiersTree nue = null;
                    boolean existingActionReference = false;
                    List<? extends AnnotationTree> existanns = modifiers.getAnnotations();
                    for (int i = 0; i < existanns.size(); ++i) {
                        NewArrayTree arr;
                        AnnotationTree ann = existanns.get(i);
                        Tree annotationType = ann.getAnnotationType();
                        if (!annotationType.toString().matches("ActionReferences")) continue;
                        existingActionReference = true;
                        List<? extends ExpressionTree> args = ann.getArguments();
                        AssignmentTree assign = (AssignmentTree)args.get(0);
                        if (!assign.getVariable().toString().equals("value")) {
                            throw new Exception("expected value=... for @ActionReference");
                        }
                        ExpressionTree arg = assign.getExpression();
                        if (arg.getKind() == Tree.Kind.STRING_LITERAL) {
                            arr = make.NewArray(null, Collections.emptyList(), Collections.singletonList(arg));
                        } else if (arg.getKind() == Tree.Kind.NEW_ARRAY) {
                            arr = (NewArrayTree)arg;
                        } else {
                            throw new Exception("unknown arg kind " + (Object)((Object)arg.getKind()) + ": " + arg);
                        }
                        for (ExpressionTree expressionTree : anns) {
                            arr = make.addNewArrayInitializer(arr, expressionTree);
                        }
                        ann = make.Annotation(annotationType, Collections.singletonList(arr));
                        nue = make.insertModifiersAnnotation(make.removeModifiersAnnotation(modifiers, i), i, ann);
                    }
                    if (!existingActionReference) {
                        nue = make.addModifiersAnnotation(modifiers, make.Annotation((Tree)make.QualIdent((Element)annActionRefs), Collections.singletonList(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"value"), (ExpressionTree)make.NewArray(null, Collections.emptyList(), anns)))));
                    }
                    wc.rewrite((Tree)modifiers, GeneratorUtilities.get((WorkingCopy)wc).importFQNs(nue));
                }
                for (FileObject fo : toDelete) {
                    this.ctx.delete(fo);
                }
            }
        }
    }

    private static class RegisterDataObject
    implements Hinter.Context.ModifyDeclarationTask {
        private static final String DATAOBJECT_REGISTRATION = "org.openide.loaders.DataObject.Registration";
        private static final String DATAOBJECT_REGISTRATIONS = "org.openide.loaders.DataObject.Registrations";
        private static final String MIME_TYPE = "mimeType";
        private final Hinter.Context ctx;

        private RegisterDataObject(Hinter.Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run(WorkingCopy wc, Element declaration, ModifiersTree modifiers) throws Exception {
            HashMap<String, Object> params = new HashMap<String, Object>();
            FileObject file = this.ctx.file();
            String displayName = this.ctx.bundlevalue(file.getAttribute("literal:displayName"), declaration);
            if (displayName == null) {
                displayName = "#TODO";
            }
            if (file.getAttribute(MIME_TYPE) != null) {
                params.put(MIME_TYPE, file.getAttribute(MIME_TYPE));
            } else {
                if (Utility.getMimeTypeFromFactoryPath(file.getPath()).isEmpty()) {
                    throw new IllegalArgumentException("Could not find a non empty mimetype");
                }
                params.put(MIME_TYPE, Utility.getMimeTypeFromFactoryPath(file.getPath()));
            }
            params.put("position", file.getAttribute("position"));
            params.put("displayName", displayName);
            params.put("iconBase", file.getAttribute("iconBase"));
            ModifiersTree mt = this.ctx.addAnnotation(wc, modifiers, DATAOBJECT_REGISTRATION, DATAOBJECT_REGISTRATIONS, params);
            wc.rewrite((Tree)modifiers, GeneratorUtilities.get((WorkingCopy)wc).importFQNs((Tree)mt));
            this.ctx.delete(file);
        }
    }
}

