/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.formatter;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.editor.formatter.FormatToken;
import org.netbeans.modules.javascript2.editor.formatter.FormatTokenStream;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;

final class TokenUtils {
    private final TokenSequence<? extends JsTokenId> ts;
    private final FormatTokenStream tokenStream;
    private final int formatFinish;

    TokenUtils(TokenSequence<? extends JsTokenId> ts, FormatTokenStream tokenStream, int formatFinish) {
        this.ts = ts;
        this.tokenStream = tokenStream;
        this.formatFinish = formatFinish;
    }

    public FormatToken getNextToken(int offset, JsTokenId expected) {
        return this.getToken(offset, expected, false, false, null);
    }

    public FormatToken getNextToken(int offset, JsTokenId expected, int stop) {
        return this.getToken(offset, expected, false, false, stop);
    }

    public FormatToken getNextToken(int offset, JsTokenId expected, boolean startFallback) {
        return this.getToken(offset, expected, false, startFallback, null);
    }

    public FormatToken getPreviousToken(int offset, JsTokenId expected) {
        return this.getPreviousToken(offset, expected, false);
    }

    public FormatToken getPreviousToken(int offset, JsTokenId expected, int stop) {
        return this.getToken(offset, expected, true, false, stop);
    }

    public FormatToken getPreviousToken(int offset, JsTokenId expected, boolean startFallback) {
        return this.getToken(offset, expected, true, startFallback, null);
    }

    private FormatToken getToken(int offset, JsTokenId expected, boolean backward, boolean startFallback, Integer stopMark) {
        this.ts.move(offset);
        if (!this.ts.moveNext() && !this.ts.movePrevious()) {
            return null;
        }
        Token token = this.ts.token();
        if (expected != null) {
            while (expected != token.id() && (stopMark == null || stopMark >= this.ts.offset() && !backward || stopMark <= this.ts.offset() && backward) && (backward && this.ts.movePrevious() || !backward && this.ts.moveNext())) {
                token = this.ts.token();
            }
            if (expected != token.id()) {
                return null;
            }
        }
        if (stopMark != null && (this.ts.offset() > stopMark && !backward || this.ts.offset() < stopMark && backward)) {
            return null;
        }
        if (token != null) {
            return this.getFallback(this.ts.offset(), startFallback);
        }
        return null;
    }

    public Token<? extends JsTokenId> getPreviousNonEmptyToken(int offset) {
        this.ts.move(offset);
        if (!this.ts.moveNext() && !this.ts.movePrevious()) {
            return null;
        }
        Token ret = null;
        while (this.ts.movePrevious()) {
            Token token = this.ts.token();
            if (token.id() == JsTokenId.BLOCK_COMMENT || token.id() == JsTokenId.DOC_COMMENT || token.id() == JsTokenId.LINE_COMMENT || token.id() == JsTokenId.EOL || token.id() == JsTokenId.WHITESPACE) continue;
            ret = token;
            break;
        }
        return ret;
    }

    public Token<? extends JsTokenId> getNextNonEmptyToken(int offset) {
        this.ts.move(offset);
        if (!this.ts.moveNext() && !this.ts.movePrevious()) {
            return null;
        }
        Token ret = null;
        while (this.ts.moveNext()) {
            Token token = this.ts.token();
            if (token.id() == JsTokenId.BLOCK_COMMENT || token.id() == JsTokenId.DOC_COMMENT || token.id() == JsTokenId.LINE_COMMENT || token.id() == JsTokenId.EOL || token.id() == JsTokenId.WHITESPACE) continue;
            ret = token;
            break;
        }
        return ret;
    }

    public FormatToken getPreviousNonWhiteToken(int offset, int stop, JsTokenId expected, boolean startFallback) {
        assert (stop <= offset);
        FormatToken ret = this.getPreviousToken(offset, expected, startFallback);
        if (startFallback && ret != null && ret.getKind() == FormatToken.Kind.SOURCE_START) {
            return ret;
        }
        if (ret != null) {
            if (expected == null) {
                return ret;
            }
            Token token = null;
            while (this.ts.movePrevious() && this.ts.offset() >= stop) {
                Token current = this.ts.token();
                if (current.id() == JsTokenId.WHITESPACE) continue;
                token = current;
                break;
            }
            if (token != null) {
                return this.getFallback(this.ts.offset(), startFallback);
            }
        }
        return null;
    }

    public FormatToken getFallback(int offset, boolean fallback) {
        FormatToken ret = this.tokenStream.getToken(offset);
        if (ret == null && fallback && offset < this.formatFinish) {
            ret = this.tokenStream.getTokens().get(0);
            assert (ret != null && ret.getKind() == FormatToken.Kind.SOURCE_START);
        }
        return ret;
    }

    @CheckForNull
    public static FormatToken findVirtualToken(FormatToken token, FormatToken.Kind kind, boolean backwards) {
        FormatToken result;
        FormatToken formatToken = result = backwards ? token.previous() : token.next();
        while (result != null && result.isVirtual() && result.getKind() != kind) {
            result = backwards ? result.previous() : result.next();
        }
        if (result != null && result.getKind() != kind) {
            return null;
        }
        return result;
    }

    public static void appendTokenAfterLastVirtual(FormatToken previous, FormatToken token) {
        TokenUtils.appendTokenAfterLastVirtual(previous, token, false);
    }

    public static void appendTokenAfterLastVirtual(FormatToken previous, FormatToken token, boolean checkDuplicity) {
        assert (previous != null);
        FormatToken current = previous;
        for (FormatToken next = current.next(); next != null && next.isVirtual(); next = next.next()) {
            current = next;
        }
        if (!(checkDuplicity && current.isVirtual() && token.isVirtual() && current.getKind() == token.getKind())) {
            TokenUtils.appendToken(current, token);
        }
    }

    public static void appendToken(FormatToken previous, FormatToken token) {
        FormatToken original = previous.next();
        previous.setNext(token);
        token.setPrevious(previous);
        token.setNext(original);
        if (original != null) {
            original.setPrevious(token);
        }
    }
}

