/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class StatementInfo {
    private final String sql;
    private final int rawStartOffset;
    private final int startOffset;
    private final int startLine;
    private final int startColumn;
    private final int rawEndOffset;
    private final int endOffset;
    private final Map<Integer, Integer> sqlPosToRawPos;
    private final List<Integer> newLineOffsets;

    public StatementInfo(String sql, int rawStartOffset, int startOffset, int startLine, int startColumn, int endOffset, int rawEndOffset, Map<Integer, Integer> sqlPosToRawPos, List<Integer> newLineOffsets) {
        this.sql = sql;
        this.rawStartOffset = rawStartOffset;
        this.startOffset = startOffset;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endOffset = endOffset;
        this.rawEndOffset = rawEndOffset;
        this.sqlPosToRawPos = Collections.unmodifiableMap(new TreeMap<Integer, Integer>(sqlPosToRawPos));
        this.newLineOffsets = Collections.unmodifiableList(new ArrayList<Integer>(newLineOffsets));
    }

    public String getSQL() {
        return this.sql;
    }

    public int getRawStartOffset() {
        return this.rawStartOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getRawEndOffset() {
        return this.rawEndOffset;
    }

    private int translateToRawPos(int sqlPos) {
        int rawOffset = 0;
        int locicalOffset = 0;
        for (Map.Entry<Integer, Integer> entry : this.sqlPosToRawPos.entrySet()) {
            if (entry.getKey() > sqlPos) break;
            locicalOffset = entry.getKey();
            rawOffset = entry.getValue();
        }
        return rawOffset + (sqlPos - locicalOffset);
    }

    Map<Integer, Integer> getSqlPosToRawPos() {
        return this.sqlPosToRawPos;
    }

    List<Integer> getNewLineOffsets() {
        return this.newLineOffsets;
    }

    public int[] translateToRawPosLineColumn(int logicalOffset) {
        int rawOffset = this.translateToRawPos(logicalOffset);
        int line = 0;
        int newLineOffset = -1;
        for (Integer offset : this.getNewLineOffsets()) {
            if (offset > rawOffset) break;
            newLineOffset = offset;
            ++line;
        }
        return new int[]{line, rawOffset - newLineOffset - 1};
    }
}

