/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.elements.EnumCaseElement;
import org.netbeans.modules.php.editor.api.elements.EnumElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.CaseDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.CaseDeclaration;
import org.openide.util.Parameters;

public final class CaseElementImpl
extends PhpElementImpl
implements EnumCaseElement {
    public static final String IDX_FIELD = "enum.case";
    private final TypeElement enclosingType;
    private final String value;
    private final PhpModifiers modifiers;
    private final boolean isBacked;

    private CaseElementImpl(TypeElement enclosingType, String caseName, String value, int offset, int flags, String fileUrl, ElementQuery elementQuery, boolean isDeprecated, boolean isBacked) {
        super(caseName, enclosingType.getName(), fileUrl, offset, elementQuery, isDeprecated);
        this.enclosingType = enclosingType;
        this.value = value;
        this.modifiers = PhpModifiers.fromBitMask(flags);
        this.isBacked = isBacked;
    }

    public static Set<EnumCaseElement> fromSignature(TypeElement type, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        return CaseElementImpl.fromSignature(type, (NameKind)NameKind.empty(), indexScopeQuery, indexResult);
    }

    public static Set<EnumCaseElement> fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<EnumCaseElement> retval = values.length > 0 ? new HashSet<EnumCaseElement>() : Collections.emptySet();
        for (String val : values) {
            EnumCaseElement enumCase = CaseElementImpl.fromSignature(type, query, indexScopeQuery, Signature.get(val));
            if (enumCase == null) continue;
            retval.add(enumCase);
        }
        return retval;
    }

    private static EnumCaseElement fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexScopeQuery, Signature signature) {
        CaseSignatureParser signParser = new CaseSignatureParser(signature);
        CaseElementImpl retval = null;
        if (CaseElementImpl.matchesQuery(query, signParser)) {
            retval = new CaseElementImpl(type, signParser.getName(), signParser.getValue(), signParser.getOffset(), signParser.getFlags(), signParser.getFileUrl(), indexScopeQuery, signParser.isDeprecated(), signParser.isBacked());
        }
        return retval;
    }

    public static EnumCaseElement fromNode(TypeElement type, CaseDeclaration node, ElementQuery.File fileQuery) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        CaseDeclarationInfo info = CaseDeclarationInfo.create(node);
        boolean isBacked = false;
        if (type instanceof EnumElement) {
            EnumElement enumElement = (EnumElement)type;
            isBacked = enumElement.getBackingType() != null;
        }
        return new CaseElementImpl(type, info.getName(), info.getValue(), info.getRange().getStart(), info.getAccessModifiers().toFlags(), fileQuery.getURL().toExternalForm(), fileQuery, VariousUtils.isDeprecated(fileQuery.getResult().getModel().getFileScope(), fileQuery.getResult().getProgram(), node), isBacked);
    }

    private static boolean matchesQuery(NameKind query, CaseSignatureParser signParser) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(EnumCaseElement.KIND, signParser.getName());
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getValue()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.isDeprecated() ? 1 : 0).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getFilenameUrl()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getPhpModifiers().toFlags()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.isBacked() ? 1 : 0).append((Object)PhpElementImpl.Separator.SEMICOLON);
        this.checkSignature(sb);
        return sb.toString();
    }

    @Override
    public PhpModifiers getPhpModifiers() {
        return this.modifiers;
    }

    @Override
    public PhpElementKind getPhpElementKind() {
        return EnumCaseElement.KIND;
    }

    @Override
    public TypeElement getType() {
        return this.enclosingType;
    }

    @Override
    public boolean isBacked() {
        return this.isBacked;
    }

    private void checkSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            CaseSignatureParser parser = new CaseSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getPhpModifiers().toFlags() == parser.getFlags());
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isStatic() {
        return this.getPhpModifiers().isStatic();
    }

    @Override
    public boolean isPublic() {
        return this.getPhpModifiers().isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.getPhpModifiers().isProtected();
    }

    @Override
    public boolean isPrivate() {
        return this.getPhpModifiers().isPrivate();
    }

    @Override
    public boolean isFinal() {
        return this.getPhpModifiers().isFinal();
    }

    @Override
    public boolean isAbstract() {
        return this.getPhpModifiers().isAbstract();
    }

    private static class CaseSignatureParser {
        private final Signature signature;

        CaseSignatureParser(Signature signature) {
            this.signature = signature;
        }

        String getName() {
            return this.signature.string(SigElement.NAME.getIndex());
        }

        int getOffset() {
            return this.signature.integer(SigElement.OFFSET.getIndex());
        }

        String getValue() {
            return this.signature.string(SigElement.VALUE.getIndex());
        }

        boolean isDeprecated() {
            return this.signature.integer(SigElement.DEPRECATED.getIndex()) == 1;
        }

        String getFileUrl() {
            return this.signature.string(SigElement.FILENAME_URL.getIndex());
        }

        int getFlags() {
            return this.signature.integer(SigElement.MODIFIERS.getIndex());
        }

        boolean isBacked() {
            return this.signature.integer(SigElement.BACKED.getIndex()) == 1;
        }
    }

    private static enum SigElement {
        NAME_LOWERCASE(0),
        NAME(1),
        OFFSET(2),
        VALUE(3),
        DEPRECATED(4),
        FILENAME_URL(5),
        MODIFIERS(6),
        BACKED(7);

        private final int index;

        private SigElement(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

