/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.ui.picker;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.web.browser.ui.picker.ListItem;
import org.netbeans.modules.web.browser.ui.picker.SelectionList;
import org.openide.util.ChangeSupport;

final class SelectionModel {
    private final ListSelectionListener selectionListener;
    private final ArrayList<SelectionList> lists = new ArrayList(10);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean ignoreSelectionEvents = false;

    SelectionModel() {
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectionModel.this.onSelectionChange(e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(SelectionList sl) {
        ArrayList<SelectionList> arrayList = this.lists;
        synchronized (arrayList) {
            if (this.lists.contains(sl)) {
                return;
            }
            boolean hasSelection = null != this.getSelectedItem();
            this.lists.add(sl);
            if (hasSelection) {
                sl.clearSelection();
            }
            sl.getSelectionModel().addListSelectionListener(this.selectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListItem getSelectedItem() {
        ArrayList<SelectionList> arrayList = this.lists;
        synchronized (arrayList) {
            for (SelectionList sl : this.lists) {
                ListItem sel = sl.getSelectedItem();
                if (null == sel) continue;
                return sel;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedItem(ListItem item) {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayList<SelectionList> arrayList = this.lists;
        synchronized (arrayList) {
            if (null == item) {
                for (SelectionList sl : this.lists) {
                    sl.clearSelection();
                }
            } else {
                for (SelectionList sl : this.lists) {
                    if (!sl.setSelectedItem(item)) continue;
                    return;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeSupport.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeSupport.removeChangeListener(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSelectionChange(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.ignoreSelectionEvents) {
            return;
        }
        this.ignoreSelectionEvents = true;
        ArrayList<SelectionList> arrayList = this.lists;
        synchronized (arrayList) {
            for (SelectionList sl : this.lists) {
                if (sl.getSelectionModel() == e.getSource()) continue;
                sl.clearSelection();
            }
        }
        this.ignoreSelectionEvents = false;
        this.changeSupport.fireChange();
    }
}

