/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.web.common.api.DependencyType;
import org.openide.filesystems.FileObject;

public class DependenciesGraph {
    private static final Logger LOGGER = Logger.getLogger(DependenciesGraph.class.getSimpleName());
    private Map<FileObject, Node> file2node = new HashMap<FileObject, Node>();
    private Node sourceNode;

    public DependenciesGraph(FileObject source) {
        this.sourceNode = new Node(source);
    }

    public Node getNode(FileObject source) {
        Node node = this.file2node.get(source);
        if (node == null) {
            node = new Node(source);
            this.file2node.put(source, node);
        }
        return node;
    }

    public Node getSourceNode() {
        return this.sourceNode;
    }

    public Collection<FileObject> getFiles(DependencyType type) {
        switch (type) {
            case REFERRING: {
                return this.getAllReferingFiles();
            }
            case REFERRED: {
                return this.getAllReferedFiles();
            }
            case REFERRING_AND_REFERRED: {
                return this.getAllRelatedFiles();
            }
        }
        throw new IllegalStateException();
    }

    public Collection<FileObject> getAllRelatedFiles() {
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        this.walk(files, this.getSourceNode(), true, true);
        return files;
    }

    public Collection<FileObject> getAllReferedFiles() {
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        this.walk(files, this.getSourceNode(), true, false);
        return files;
    }

    public Collection<FileObject> getAllReferingFiles() {
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        this.walk(files, this.getSourceNode(), false, true);
        return files;
    }

    private void walk(Collection<FileObject> files, Node node, boolean refered, boolean refering) {
        if (files.add(node.getFile())) {
            if (refered) {
                for (Node n : node.refered) {
                    this.walk(files, n, refered, refering);
                }
            }
            if (refering) {
                for (Node n : node.refering) {
                    this.walk(files, n, refered, refering);
                }
            }
        }
    }

    public class Node {
        private FileObject source;
        private Collection<Node> refering = new LinkedHashSet<Node>();
        private Collection<Node> refered = new LinkedHashSet<Node>();

        private Node(FileObject source) {
            this.source = source;
        }

        public DependenciesGraph getDependencyGraph() {
            return DependenciesGraph.this;
        }

        public FileObject getFile() {
            return this.source;
        }

        public boolean addReferedNode(Node node) {
            if (this.refered.add(node)) {
                boolean added = node.refering.add(this);
                if (!added) {
                    LOGGER.info(String.format("A graph cycle detected when adding refered node %s to node %s", node.toString(), this.toString()));
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean addReferingNode(Node node) {
            if (this.refering.add(node)) {
                boolean added = node.refered.add(this);
                if (!added) {
                    LOGGER.info(String.format("A graph cycle detected when adding refering node %s to node %s", node.toString(), this.toString()));
                    return false;
                }
                return true;
            }
            return false;
        }

        public Collection<Node> getReferingNodes() {
            return Collections.unmodifiableCollection(this.refering);
        }

        public Collection<Node> getReferedNodes() {
            return Collections.unmodifiableCollection(this.refered);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.source == other.source || this.source != null && this.source.equals(other.source);
        }

        public int hashCode() {
            int hash = 5;
            hash = 41 * hash + (this.source != null ? this.source.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return "Node[" + this.source.getPath() + "]";
        }
    }
}

