/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.api;

import javax.swing.text.Document;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.xml.text.indent.XMLLexerFormatter;

public final class XMLTextUtils {
    public static final String XML_MIME = "text/xml";
    static String[] knownEntityStrings = new String[]{"&lt;", "&gt;", "&apos;", "&quot;", "&amp;"};
    static char[] knownEntityChars = new char[]{'<', '>', '\'', '\"', '&'};

    private XMLTextUtils() {
    }

    public static Token<XMLTokenId> skipAttributeValue(TokenSequence ts, char delim) {
        boolean ok = true;
        while (ok) {
            Token next = ts.token();
            CharSequence cs = next.text();
            if (cs.charAt(cs.length() - 1) == delim) {
                ts.moveNext();
                return ts.token();
            }
            ok = ts.moveNext();
        }
        return null;
    }

    public static String actualAttributeValue(String attributeValue) {
        int ltIndex = attributeValue.indexOf(60);
        int gtIndex = attributeValue.indexOf(62);
        int firstUnwantedIndex = -1;
        firstUnwantedIndex = gtIndex != -1 ? (ltIndex != -1 && ltIndex < gtIndex ? ltIndex : gtIndex) : ltIndex;
        if (firstUnwantedIndex != -1) {
            char charAtIndex = attributeValue.charAt(firstUnwantedIndex);
            while ((charAtIndex == ' ' || charAtIndex == '\t' || charAtIndex == '\n' || charAtIndex == '\r' || charAtIndex == '<' || charAtIndex == '>') && --firstUnwantedIndex >= 0) {
                charAtIndex = attributeValue.charAt(firstUnwantedIndex);
            }
            return attributeValue.substring(0, firstUnwantedIndex + 1);
        }
        return attributeValue;
    }

    public static String replaceEntityStringsWithChars(String value) {
        StringBuffer buf = new StringBuffer(value);
        for (int entity = 0; entity < knownEntityStrings.length; ++entity) {
            String curEntityString = knownEntityStrings[entity];
            int indexOfEntity = buf.toString().indexOf(curEntityString);
            while (indexOfEntity != -1) {
                buf.replace(indexOfEntity, indexOfEntity + curEntityString.length(), new String(new char[]{knownEntityChars[entity]}));
                indexOfEntity = buf.toString().indexOf(curEntityString);
            }
        }
        return buf.toString();
    }

    public static String replaceCharsWithEntityStrings(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer replBuf = new StringBuffer(value.length());
        for (int ind = 0; ind < value.length(); ++ind) {
            boolean charReplaced = false;
            char curChar = value.charAt(ind);
            for (int entity = 0; entity < knownEntityChars.length; ++entity) {
                if (curChar != knownEntityChars[entity]) continue;
                replBuf.append(knownEntityStrings[entity]);
                charReplaced = true;
                break;
            }
            if (charReplaced) continue;
            replBuf.append(curChar);
        }
        return replBuf.toString();
    }

    public static void reformat(final LineDocument doc, final int startOffset, final int endOffset) {
        final XMLLexerFormatter formatter = new XMLLexerFormatter(null);
        AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)doc, AtomicLockDocument.class);
        ald.runAtomic(new Runnable(){

            @Override
            public void run() {
                formatter.doReformat(doc, startOffset, endOffset);
            }
        });
    }
}

