/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbPreferences;

public final class Configuration {
    private final String id;
    private final String description;
    private final boolean defaultEnabled;
    public static final String ENABLED_KEY = "enabled";
    public static final String SEVERITY_KEY = "severity";
    static final String IN_TASK_LIST_KEY = "inTaskList";
    private final HintSeverity defaultSeverity;
    private final String displayName;
    private final Map<String, Object> id2Saved = new HashMap<String, Object>();

    public Configuration(String id, String displayName, String description, boolean defaultEnabled, HintSeverity defaultSeverity) {
        this.id = id;
        this.description = description;
        this.defaultEnabled = defaultEnabled;
        this.defaultSeverity = defaultSeverity;
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(this.getClass()).node(this.getId());
    }

    public String getDescription() {
        return this.description;
    }

    public final boolean isEnabled(Preferences p) {
        boolean enabled = p.getBoolean(ENABLED_KEY, this.defaultEnabled);
        if (!this.id2Saved.containsKey(ENABLED_KEY)) {
            this.id2Saved.put(ENABLED_KEY, enabled);
        }
        return enabled;
    }

    public void setEnabled(Preferences p, boolean value) {
        p.putBoolean(ENABLED_KEY, value);
    }

    public final HintSeverity getSeverity(Preferences p) {
        HintSeverity severity;
        String s = p.get(SEVERITY_KEY, null);
        HintSeverity hintSeverity = severity = s == null ? this.defaultSeverity : Configuration.fromPreferenceString(s);
        if (!this.id2Saved.containsKey(SEVERITY_KEY)) {
            this.id2Saved.put(SEVERITY_KEY, (Object)severity);
        }
        return severity;
    }

    public void setSeverity(Preferences p, HintSeverity severity) {
        p.put(SEVERITY_KEY, severity.toPreferenceString());
    }

    public Object getSavedValue(String key) {
        return this.id2Saved.get(key);
    }

    public void resetSavedValues() {
        this.id2Saved.clear();
    }

    public static HintSeverity fromPreferenceString(String sev) {
        if (sev.equals("error")) {
            return HintSeverity.ERROR;
        }
        if (sev.equals("warning")) {
            return HintSeverity.WARNING;
        }
        throw new IllegalStateException(sev);
    }

    public static enum HintSeverity {
        ERROR,
        WARNING;


        public Severity toEditorSeverity() {
            switch (this) {
                case ERROR: {
                    return Severity.ERROR;
                }
                case WARNING: {
                    return Severity.VERIFIER;
                }
            }
            return null;
        }

        public String toPreferenceString() {
            switch (this) {
                case ERROR: {
                    return "error";
                }
                case WARNING: {
                    return "warning";
                }
            }
            return null;
        }
    }
}

