/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.support.java.method;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.openide.util.NbBundle;

public final class ReturnTypeUIHelper {
    private static final List<String> LVALUE_TYPES = Arrays.asList("boolean", "int", "char", "byte", "short", "long", "float", "double", "Object", "String");
    static final Separator SEPARATOR_ITEM = new Separator();
    static final Object NEW_ITEM = new Object(){

        public String toString() {
            return NbBundle.getMessage(ReturnTypeUIHelper.class, (String)"LBL_Choose");
        }
    };

    public static ListCellRenderer createDatasourceListCellRenderer() {
        return new ReturnTypeListCellRenderer();
    }

    private ReturnTypeUIHelper() {
    }

    public static void connect(JComboBox combo, ClasspathInfo cpInfo) {
        ReturnTypeUIHelper.connect(combo, null, cpInfo);
    }

    private static final void connect(final JComboBox combo, String selectedType, final ClasspathInfo cpInfo) {
        combo.setEditable(true);
        combo.setEditor(new ReturnTypeComboBoxEditor(combo.getEditor()));
        combo.setRenderer(new ReturnTypeListCellRenderer());
        ReturnTypeUIHelper.populate(LVALUE_TYPES, true, combo, selectedType, false);
        JComboBox toListenOn = combo.isEditable() ? combo.getEditor().getEditorComponent() : combo;
        toListenOn.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object selectedItem;
                int keyCode = e.getKeyCode();
                if (10 == keyCode && (selectedItem = combo.getSelectedItem()) == NEW_ITEM) {
                    ReturnTypeUIHelper.performBrowseType(combo, cpInfo);
                    e.consume();
                }
            }
        });
        combo.addActionListener(new ActionListener(){
            Object previousItem;
            int previousIndex;
            {
                this.previousIndex = combo.getSelectedIndex();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = combo.getSelectedItem();
                if (selectedItem == SEPARATOR_ITEM) {
                    int selectedIndex = combo.getSelectedIndex();
                    if (selectedIndex > this.previousIndex) {
                        this.previousIndex = selectedIndex + 1;
                        this.previousItem = combo.getItemAt(this.previousIndex);
                    } else {
                        this.previousIndex = selectedIndex - 1;
                        this.previousItem = combo.getItemAt(this.previousIndex);
                    }
                    combo.setSelectedItem(this.previousItem);
                } else if ((e.getModifiers() & 0x10) != 0 && selectedItem == NEW_ITEM) {
                    ReturnTypeUIHelper.performBrowseType(combo, cpInfo);
                }
            }
        });
    }

    private static void performBrowseType(final JComboBox combo, final ClasspathInfo cpInfo) {
        final ReturnTypeComboBoxModel model = (ReturnTypeComboBoxModel)combo.getModel();
        combo.setPopupVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ElementHandle handle = TypeElementFinder.find((ClasspathInfo)cpInfo, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
                    }

                    public boolean accept(ElementHandle<TypeElement> typeHandle) {
                        return true;
                    }
                });
                combo.setPopupVisible(false);
                if (handle == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReturnTypeUIHelper.setSelectedItem(combo, model.getPreviousItem());
                        }
                    });
                } else {
                    ReturnTypeUIHelper.setSelectedItem(combo, handle.getQualifiedName());
                }
            }
        });
    }

    private static List populate(List<String> types, boolean creationSupported, final JComboBox combo, final String selectedType, boolean selectItemLater) {
        LinkedList<Object> items;
        LinkedList<Object> linkedList = items = types == null ? new LinkedList<Object>() : new LinkedList<String>(types);
        if (items.size() > 0) {
            items.add(SEPARATOR_ITEM);
        }
        if (creationSupported) {
            items.add(NEW_ITEM);
        }
        ReturnTypeComboBoxModel model = new ReturnTypeComboBoxModel(types, items);
        combo.setModel(model);
        if (selectedType != null) {
            ReturnTypeUIHelper.setSelectedItem(combo, selectedType);
            if (selectItemLater) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReturnTypeUIHelper.setSelectedItem(combo, selectedType);
                    }
                });
            }
        }
        return types;
    }

    private static void setSelectedItem(JComboBox combo, Object item) {
        combo.setSelectedItem(item);
        if (combo.isEditable() && combo.getEditor() != null) {
            combo.configureEditor(combo.getEditor(), combo.getSelectedItem());
        }
    }

    private static class ReturnTypeListCellRenderer
    extends DefaultListCellRenderer {
        private ReturnTypeListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value == SEPARATOR_ITEM) {
                return SEPARATOR_ITEM;
            }
            this.setText(value != null ? value.toString() : "");
            this.setToolTipText("");
            return this;
        }
    }

    private static class ReturnTypeComboBoxEditor
    implements ComboBoxEditor {
        private ComboBoxEditor delegate;
        private Object oldValue;

        ReturnTypeComboBoxEditor(ComboBoxEditor delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getEditorComponent() {
            return this.delegate.getEditorComponent();
        }

        @Override
        public void setItem(Object anObject) {
            JTextComponent editor = this.getEditor();
            if (anObject != null) {
                String text = anObject.toString();
                editor.setText(text);
                this.oldValue = anObject;
            } else {
                editor.setText("");
            }
        }

        @Override
        public Object getItem() {
            JTextComponent editor = this.getEditor();
            Object newValue = editor.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (newValue.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> cls = this.oldValue.getClass();
                try {
                    Method method = cls.getMethod("valueOf", String.class);
                    newValue = method.invoke(this.oldValue, editor.getText());
                }
                catch (Exception ex) {
                    Logger.getLogger("ReturnTypeUIHelper").log(Level.FINE, "ignored excep[tion", ex);
                }
            }
            return newValue;
        }

        @Override
        public void selectAll() {
            this.delegate.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.delegate.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.delegate.removeActionListener(l);
        }

        private JTextComponent getEditor() {
            Component comp = this.getEditorComponent();
            assert (comp instanceof JTextComponent);
            return (JTextComponent)comp;
        }
    }

    private static class ReturnTypeComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private List<Object> items;
        private Object selectedItem;
        private List<String> returnTypes;
        private Object previousItem;

        private ReturnTypeComboBoxModel(List<String> returnTypes, List<Object> items) {
            this.returnTypes = returnTypes;
            this.items = items;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.selectedItem == null || !this.selectedItem.equals(anItem)) {
                this.previousItem = this.selectedItem;
                this.selectedItem = anItem;
                this.fireContentsChanged(this, 0, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public Object getElementAt(int index) {
            return this.items.get(index);
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        Object getPreviousItem() {
            return this.previousItem;
        }

        List<String> getReturnTypes() {
            return this.returnTypes;
        }

        public void addElement(Object elem) {
            this.items.add(elem);
        }

        @Override
        public void removeElement(Object elem) {
            this.items.remove(elem);
        }

        public void insertElementAt(Object elem, int index) {
            this.items.set(index, elem);
        }

        @Override
        public void removeElementAt(int index) {
            this.items.remove(index);
        }
    }

    private static final class Separator
    extends JSeparator {
        Separator() {
            this.setPreferredSize(new Dimension(this.getWidth(), 1));
            this.setForeground(Color.BLACK);
        }
    }
}

