/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms;

import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cordova.platforms.BrowserCustomizer;
import org.netbeans.modules.cordova.platforms.RefreshOnSaveListenerImpl;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectEnhancedBrowserImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.ProjectConfigurationCustomizer;
import org.netbeans.modules.web.clientproject.spi.platform.RefreshOnSaveListener;
import org.netbeans.spi.project.ActionProvider;

public final class EnhancedBrowserImpl
implements ClientProjectEnhancedBrowserImplementation {
    private final Project project;
    private final WebBrowser browser;
    protected BrowserSupport browserSupport;
    private static final Logger LOGGER = Logger.getLogger(EnhancedBrowserImpl.class.getName());
    private BrowserCustomizer browserCustomizer;
    private static final String PROJECT_AUTO_REFRESH = "browser.autorefresh";
    private static final String PROJECT_HIGHLIGHT_SELECTION = "browser.highlightselection";
    private final ActionProvider actionProvider;

    public EnhancedBrowserImpl(Project project, WebBrowser browser, BrowserSupport support, ActionProvider actionProvider) {
        this.project = project;
        this.browser = browser;
        this.browserSupport = support;
        this.actionProvider = actionProvider;
    }

    public void save() {
        if (this.browserCustomizer != null && this.browser.hasNetBeansIntegration()) {
            Preferences p = ProjectUtils.getPreferences((Project)this.project, EnhancedBrowserImpl.class, (boolean)false);
            p.put("browser.autorefresh." + this.browser.getId(), Boolean.toString(this.browserCustomizer.isAutoRefresh()));
            p.put("browser.highlightselection." + this.browser.getId(), Boolean.toString(this.browserCustomizer.isHighlightSelection()));
        }
    }

    public RefreshOnSaveListener getRefreshOnSaveListener() {
        return new RefreshOnSaveListenerImpl(this.project, this.browserSupport, this);
    }

    public ProjectConfigurationCustomizer getProjectConfigurationCustomizer() {
        if (this.browserCustomizer == null) {
            this.browserCustomizer = new BrowserCustomizer(this.project, this, this.browser);
        }
        return this.browserCustomizer;
    }

    public void deactivate() {
        this.browserSupport.close(false);
    }

    public void close() {
        this.browserSupport.close(true);
    }

    public boolean isAutoRefresh() {
        Preferences p = ProjectUtils.getPreferences((Project)this.project, EnhancedBrowserImpl.class, (boolean)false);
        return p.getBoolean("browser.autorefresh." + this.browser.getId(), true);
    }

    public boolean isHighlightSelectionEnabled() {
        Preferences p = ProjectUtils.getPreferences((Project)this.project, EnhancedBrowserImpl.class, (boolean)false);
        return p.getBoolean("browser.highlightselection." + this.browser.getId(), this.browser.hasNetBeansIntegration());
    }

    public ActionProvider getActionProvider() {
        return this.actionProvider;
    }
}

