/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.PoolReader;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.Convert;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.tools.JavaFileObject;

public class ModuleNameReader {
    private static final int INITIAL_BUFFER_SIZE = 65520;
    private ByteBuffer buf = new ByteBuffer(65520);
    private int bp;
    private PoolReader reader;

    public String readModuleName(Path p) throws IOException, BadClassFile {
        try (InputStream in = Files.newInputStream(p, new OpenOption[0]);){
            String string = this.readModuleName(in);
            return string;
        }
    }

    public String readModuleName(JavaFileObject jfo) throws IOException, BadClassFile {
        try (InputStream in = jfo.openInputStream();){
            String string = this.readModuleName(in);
            return string;
        }
    }

    public String readModuleName(InputStream in) throws IOException, BadClassFile {
        this.bp = 0;
        this.buf.reset();
        this.buf.appendStream(in);
        int magic = this.nextInt();
        if (magic != -889275714) {
            throw new BadClassFile("illegal.start.of.class.file");
        }
        char minorVersion = this.nextChar();
        char majorVersion = this.nextChar();
        if (majorVersion < '5') {
            throw new BadClassFile("bad major version number for module: " + majorVersion);
        }
        this.reader = new PoolReader(this.buf);
        this.bp = this.reader.readPool(this.buf, this.bp);
        char access_flags = this.nextChar();
        if (access_flags != '\u8000') {
            throw new BadClassFile("invalid access flags for module: 0x" + Integer.toHexString(access_flags));
        }
        char this_class = this.nextChar();
        this.checkZero(this.nextChar(), "super_class");
        this.checkZero(this.nextChar(), "interface_count");
        this.checkZero(this.nextChar(), "fields_count");
        this.checkZero(this.nextChar(), "methods_count");
        int attributes_count = this.nextChar();
        for (int i = 0; i < attributes_count; ++i) {
            char attr_name = this.nextChar();
            int attr_length = this.nextInt();
            if (this.reader.peekName(attr_name, this.utf8Mapper(false)).equals("Module") && attr_length > 2) {
                return this.reader.peekModuleName(this.nextChar(), this.utf8Mapper(true));
            }
            this.bp += attr_length;
        }
        throw new BadClassFile("no Module attribute");
    }

    void checkZero(int count, String name) throws BadClassFile {
        if (count != 0) {
            throw new BadClassFile("invalid " + name + " for module: " + count);
        }
    }

    char nextChar() throws BadClassFile {
        char res;
        try {
            res = this.buf.getChar(this.bp);
        }
        catch (ByteBuffer.UnderflowException e) {
            throw new BadClassFile("class file truncated at offset " + e.getLength());
        }
        this.bp += 2;
        return res;
    }

    int nextInt() throws BadClassFile {
        int res;
        try {
            res = this.buf.getInt(this.bp);
        }
        catch (ByteBuffer.UnderflowException e) {
            throw new BadClassFile("class file truncated at offset " + e.getLength());
        }
        this.bp += 4;
        return res;
    }

    PoolReader.Utf8Mapper<String> utf8Mapper(boolean internalize) {
        return internalize ? (buf, offset, len) -> {
            buf = ClassFile.internalize(buf, offset, len);
            return Convert.utf2string(buf, 0, buf.length, Convert.Validation.STRICT);
        } : (buf, offset, len) -> Convert.utf2string(buf, offset, len, Convert.Validation.STRICT);
    }

    public static class BadClassFile
    extends Exception {
        private static final long serialVersionUID = 0L;

        BadClassFile(String msg) {
            super(msg);
        }
    }
}

